/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.workbench.swt;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.MUILabel;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public abstract class AbstractPartRenderer {
    public static final String OWNING_ME = "modelElement";
    protected IEclipseContext context;
    protected EModelService modelService;

    public void init(IEclipseContext context) {
        this.context = context;
        this.modelService = (EModelService)context.get(EModelService.class);
    }

    public abstract Object createWidget(MUIElement var1, Object var2);

    public abstract void processContents(MElementContainer<MUIElement> var1);

    public void postProcess(MUIElement childElement) {
    }

    public abstract void bindWidget(MUIElement var1, Object var2);

    protected abstract Object getParentWidget(MUIElement var1);

    public abstract void disposeWidget(MUIElement var1);

    public abstract void hookControllerLogic(MUIElement var1);

    public abstract void childRendered(MElementContainer<MUIElement> var1, MUIElement var2);

    public void hideChild(MElementContainer<MUIElement> parentElement, MUIElement child) {
    }

    protected abstract Object getImage(MUILabel var1);

    protected IEclipseContext getContextForParent(MUIElement element) {
        return this.modelService.getContainingContext(element);
    }

    protected IEclipseContext getContext(MUIElement part) {
        if (part instanceof MContext) {
            return ((MContext)part).getContext();
        }
        return this.getContextForParent(part);
    }

    public void activate(MPart element) {
        EPartService ps;
        IEclipseContext curContext = this.getContext((MUIElement)element);
        if (curContext != null && (ps = (EPartService)curContext.get(EPartService.class.getName())) != null) {
            ps.activate(element, this.requiresFocus(element));
        }
    }

    protected abstract boolean requiresFocus(MPart var1);

    public void removeGui(MUIElement element, Object widget) {
    }

    public Object getUIContainer(MUIElement element) {
        if (element.getParent() != null) {
            return element.getParent().getWidget();
        }
        Object value = element.getTransientData().get("Rendering Parent");
        if (value != null) {
            return value;
        }
        return null;
    }

    public void forceFocus(MUIElement element) {
    }

    public int getStyleOverride(MUIElement mElement) {
        String overrideStr = (String)mElement.getPersistedState().get("styleOverride");
        if (overrideStr == null || overrideStr.length() == 0) {
            return -1;
        }
        int val = -1;
        val = Integer.parseInt(overrideStr);
        return val;
    }
}

