/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.jface.gridviewer;

import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerRow;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.jface.gridviewer.GridViewerRow;
import org.eclipse.nebula.jface.gridviewer.internal.SelectionWithFocusRow;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridItem;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Widget;

public class GridTableViewer
extends AbstractTableViewer {
    private Grid grid;
    private GridViewerRow cachedRow;
    private CellLabelProvider rowHeaderLabelProvider;
    private boolean autoPreferredHeight = false;

    public GridTableViewer(Composite parent) {
        this(parent, 2818);
    }

    public GridTableViewer(Composite parent, int style) {
        this(new Grid(parent, style));
    }

    public GridTableViewer(Grid grid) {
        this.grid = grid;
        this.hookControl((Control)grid);
    }

    public Grid getGrid() {
        return this.grid;
    }

    protected ViewerRow internalCreateNewRowPart(int style, int rowIndex) {
        GridItem item = rowIndex >= 0 ? new GridItem(this.grid, style, rowIndex) : new GridItem(this.grid, style);
        return this.getViewerRowFromItem((Widget)item);
    }

    protected ColumnViewerEditor createViewerEditor() {
        return new GridViewerEditor((ColumnViewer)this, new ColumnViewerEditorActivationStrategy((ColumnViewer)this), 1);
    }

    protected void doClear(int index) {
    }

    protected void doClearAll() {
    }

    protected void doSetItemCount(int count) {
    }

    protected void doDeselectAll() {
        this.grid.deselectAll();
    }

    protected Widget doGetColumn(int index) {
        return this.grid.getColumn(index);
    }

    protected int doGetColumnCount() {
        return this.grid.getColumnCount();
    }

    protected Item doGetItem(int index) {
        return this.grid.getItem(index);
    }

    protected int doGetItemCount() {
        return this.grid.getItemCount();
    }

    protected Item[] doGetItems() {
        return this.grid.getItems();
    }

    protected Item[] doGetSelection() {
        return this.grid.getSelection();
    }

    protected int[] doGetSelectionIndices() {
        return this.grid.getSelectionIndices();
    }

    protected int doIndexOf(Item item) {
        return this.grid.indexOf((GridItem)item);
    }

    protected void doRemove(int[] indices) {
        this.grid.remove(indices);
    }

    protected void doRemove(int start, int end) {
        this.grid.remove(start, end);
    }

    protected void doRemoveAll() {
        this.grid.removeAll();
    }

    protected void doSetSelection(Item[] items) {
        GridItem[] items2 = new GridItem[items.length];
        int i = 0;
        while (i < items.length) {
            items2[i] = (GridItem)items[i];
            ++i;
        }
        this.grid.setSelection(items2);
        this.grid.showSelection();
    }

    protected void doSetSelection(int[] indices) {
        this.grid.setSelection(indices);
    }

    protected void doShowItem(Item item) {
        this.grid.showItem((GridItem)item);
    }

    protected void doShowSelection() {
        this.grid.showSelection();
    }

    protected Item getItemAt(Point point) {
        return this.grid.getItem(point);
    }

    public Control getControl() {
        return this.grid;
    }

    protected ViewerRow getViewerRowFromItem(Widget item) {
        if (this.cachedRow == null) {
            this.cachedRow = new GridViewerRow((GridItem)item);
        } else {
            this.cachedRow.setItem((GridItem)item);
        }
        return this.cachedRow;
    }

    protected void doResetItem(Item item) {
        GridItem gridItem = (GridItem)item;
        int columnCount = Math.max(1, this.grid.getColumnCount());
        int i = 0;
        while (i < columnCount) {
            gridItem.setText(i, "");
            gridItem.setImage(null);
            ++i;
        }
    }

    protected void doSelect(int[] indices) {
        this.grid.select(indices);
    }

    public void setAutoPreferredHeight(boolean autoPreferredHeight) {
        this.autoPreferredHeight = autoPreferredHeight;
    }

    public boolean getAutoPreferredHeight() {
        return this.autoPreferredHeight;
    }

    protected void doUpdateItem(Widget widget, Object element, boolean fullMap) {
        super.doUpdateItem(widget, element, fullMap);
        this.updateRowHeader(widget);
        if (this.autoPreferredHeight && !widget.isDisposed()) {
            ((GridItem)widget).pack();
        }
    }

    private void updateRowHeader(Widget widget) {
        if (this.rowHeaderLabelProvider != null) {
            ViewerCell cell = this.getViewerRowFromItem(widget).getCell(Integer.MAX_VALUE);
            this.rowHeaderLabelProvider.update(cell);
        }
    }

    public void setRowHeaderLabelProvider(CellLabelProvider rowHeaderLabelProvider) {
        this.rowHeaderLabelProvider = rowHeaderLabelProvider;
    }

    public void refreshRowHeaders(Object element) {
        boolean refresh = element == null;
        GridItem[] items = this.getGrid().getItems();
        int i = 0;
        while (i < items.length) {
            if (refresh || element.equals(items[i].getData())) {
                refresh = true;
                this.updateRowHeader((Widget)items[i]);
            }
            ++i;
        }
    }

    public void editElement(Object element, int column) {
        try {
            ViewerCell cell;
            ViewerRow row;
            this.getControl().setRedraw(false);
            Widget item = this.findItem(element);
            if (item != null && (row = this.getViewerRowFromItem(item)) != null && (cell = row.getCell(column)) != null) {
                this.triggerEditorActivationEvent(new ColumnViewerEditorActivationEvent(cell));
            }
        }
        finally {
            this.getControl().setRedraw(true);
        }
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        Object el;
        super.setSelectionToWidget(selection, reveal);
        if (selection instanceof SelectionWithFocusRow && (el = ((SelectionWithFocusRow)selection).getFocusElement()) != null) {
            GridItem[] items = this.grid.getItems();
            int i = 0;
            while (i < items.length) {
                GridItem item = items[i];
                if (item.getData() == el || item.getData().equals(el) || this.getComparer() != null && this.getComparer().equals(item.getData(), el)) {
                    this.grid.setFocusItem(item);
                    break;
                }
                ++i;
            }
        }
    }

    public ISelection getSelection() {
        IStructuredSelection selection = (IStructuredSelection)super.getSelection();
        Object el = null;
        if (this.grid.getFocusItem() != null) {
            el = this.grid.getFocusItem().getData();
        }
        return new SelectionWithFocusRow(selection.toList(), el, this.getComparer());
    }
}

