/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.javascript.internal;

import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.ScriptException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.transform.javascript.internal.JavaScriptEngineManager;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, property={"smarthome.transform=JS"})
public class JavaScriptTransformationService
implements TransformationService {
    private Logger logger = LoggerFactory.getLogger(JavaScriptTransformationService.class);
    @NonNullByDefault(value={})
    private JavaScriptEngineManager manager;

    @Reference
    public void setJavaScriptEngineManager(JavaScriptEngineManager manager) {
        this.manager = manager;
    }

    public void unsetJavaScriptEngineManager(JavaScriptEngineManager manager) {
        this.manager = null;
    }

    public @Nullable String transform(String filename, String source) throws TransformationException {
        if (filename == null || source == null) {
            throw new TransformationException("the given parameters 'filename' and 'source' must not be null");
        }
        long startTime = System.currentTimeMillis();
        this.logger.debug("about to transform '{}' by the JavaScript '{}'", (Object)source, (Object)filename);
        String result = "";
        try {
            CompiledScript cScript = this.manager.getScript(filename);
            Bindings bindings = cScript.getEngine().createBindings();
            bindings.put("input", (Object)source);
            String string = result = String.valueOf(cScript.eval(bindings));
            return string;
        }
        catch (ScriptException e) {
            throw new TransformationException("An error occurred while executing script. " + e.getMessage(), (Throwable)e);
        }
        finally {
            this.logger.trace("JavaScript execution elapsed {} ms. Result: {}", (Object)(System.currentTimeMillis() - startTime), (Object)result);
        }
    }
}

