/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.NewModelFileCreationPage;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNewModelFileWizard<T extends IMetaModelDescriptor>
extends BasicNewResourceWizard {
    protected NewModelFileCreationPage<T> mainPage;
    protected String metaModelName;

    public AbstractNewModelFileWizard() {
        this(null);
    }

    public AbstractNewModelFileWizard(String metaModelName) {
        this.metaModelName = metaModelName;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.setWindowTitle(NLS.bind((String)Messages.wizard_newModelFile_title, (Object)(this.metaModelName != null ? this.metaModelName : Messages.default_metamodelName_cap)));
    }

    public void addPages() {
        this.mainPage = this.createMainPage();
        Assert.isNotNull(this.mainPage);
        this.addPage((IWizardPage)this.mainPage);
    }

    protected abstract NewModelFileCreationPage<T> createMainPage();

    public boolean performFinish() {
        final IFile newFile = this.mainPage.getNewFile();
        String jobName = NLS.bind((String)Messages.job_creatingNewModelFile_name, (Object)(this.metaModelName != null ? this.metaModelName : Messages.default_metamodelName));
        Job job = this.createCreateNewModelFileJob(jobName, newFile);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display display;
                if (event.getResult() != null && event.getResult().isOK() && (display = ExtendedPlatformUI.getDisplay()) != null) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            AbstractNewModelFileWizard.this.selectAndReveal((IResource)newFile);
                            AbstractNewModelFileWizard.this.openNewModelInEditor(newFile);
                        }
                    });
                }
            }
        });
        job.schedule();
        return true;
    }

    protected abstract Job createCreateNewModelFileJob(String var1, IFile var2);

    protected void openNewModelInEditor(IFile newFile) {
        try {
            IWorkbenchPage page;
            IWorkbenchWindow window = this.getWorkbench().getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null) {
                page.openEditor((IEditorInput)new FileEditorInput(newFile), this.getWorkbench().getEditorRegistry().getDefaultEditor(newFile.getFullPath().toString()).getId());
            }
        }
        catch (PartInitException exception) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)exception));
        }
    }
}

