/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.richstring;

public class TextLine
implements CharSequence {
    private final String completeText;
    private final int offset;
    private final int length;
    private final int delimiterLength;

    public TextLine(String completeText, int offset, int length, int delimiterLength) {
        this.completeText = completeText;
        this.offset = offset;
        this.length = length;
        this.delimiterLength = delimiterLength;
    }

    public String getCompleteText() {
        return this.completeText;
    }

    public boolean hasLeadingWhiteSpace() {
        if (this.length == 0) {
            return false;
        }
        boolean result = Character.isWhitespace(this.charAt(0));
        return result;
    }

    public boolean containsOnlyWhitespace() {
        int i = 0;
        while (i < this.length()) {
            if (!Character.isWhitespace(this.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public CharSequence getLeadingWhiteSpace() {
        int i = 0;
        while (i < this.length()) {
            if (!Character.isWhitespace(this.charAt(i))) {
                if (i == 0) {
                    return "";
                }
                return new LeadingWSTextLinePart(this.completeText, this.offset, i);
            }
            ++i;
        }
        return new LeadingWSTextLinePart(this.completeText, this.offset, this.length);
    }

    public boolean hasTrailingLineBreak() {
        return this.delimiterLength > 0;
    }

    public int getRelativeOffset() {
        return this.offset;
    }

    public int length() {
        return this.length;
    }

    public char charAt(int index) {
        return this.completeText.charAt(index + this.offset);
    }

    public int getDelimiterLength() {
        return this.delimiterLength;
    }

    public String toString() {
        return this.completeText.substring(this.offset, this.offset + this.length);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.toString().hashCode();
        result = 31 * result + this.delimiterLength;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextLine other = (TextLine)obj;
        if (this.length != other.length) {
            return false;
        }
        if (this.delimiterLength != other.delimiterLength) {
            return false;
        }
        return this.completeText.regionMatches(this.offset, other.completeText, other.offset, this.length);
    }

    public CharSequence subSequence(int start, int end) {
        if (start < 0 || start > end) {
            this.throwIndexOutOfBounds(start);
        }
        if (end < 0 || end > this.length) {
            this.throwIndexOutOfBounds(end);
        }
        if (start > end) {
            this.throwIndexOutOfBounds(end - start);
        }
        return this.completeText.subSequence(start + this.offset, end + this.offset);
    }

    protected void throwIndexOutOfBounds(int offset) {
        throw new IndexOutOfBoundsException("Index out of range: " + offset);
    }

    protected static class LeadingWSTextLinePart
    extends TextLine {
        public LeadingWSTextLinePart(String completeText, int offset, int length) {
            super(completeText, offset, length, 0);
        }

        public CharSequence getLeadingWhiteSpace() {
            return this;
        }

        public boolean hasLeadingWhiteSpace() {
            return this.length() > 0;
        }

        public boolean containsOnlyWhitespace() {
            return true;
        }
    }
}

