/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.core.typing;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend.core.jvmmodel.IXtendJvmAssociations;
import org.eclipse.xtend.core.xtend.XtendFunction;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeParameterDeclarator;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVisibility;
import org.eclipse.xtext.common.types.util.FeatureOverridesService;
import org.eclipse.xtext.common.types.util.ITypeArgumentContext;
import org.eclipse.xtext.common.types.util.SuperTypeCollector;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.common.types.util.TypeReferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XtendOverridesService {
    @Inject
    private IXtendJvmAssociations xtendjvmAssociations;
    @Inject
    private FeatureOverridesService featureOverridesService;
    @Inject
    private TypeArgumentContextProvider typeArgumentContextProvider;
    @Inject
    private TypeReferences typeReferences;
    @Inject
    private SuperTypeCollector superTypeCollector;

    public JvmOperation findOverriddenOperation(XtendFunction function) {
        JvmOperation inferredOperation = this.xtendjvmAssociations.getDirectlyInferredOperation(function);
        if (inferredOperation == null) {
            return null;
        }
        return this.findOverriddenOperation(inferredOperation);
    }

    public JvmOperation findOverriddenOperation(JvmOperation operation) {
        JvmParameterizedTypeReference typeRef = this.typeReferences.createTypeRef((JvmType)operation.getDeclaringType(), new JvmTypeReference[0]);
        ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.ReceiverRequest((JvmTypeReference)typeRef));
        for (JvmOperation superOperation : this.allSuperOperations(operation.getDeclaringType())) {
            if (superOperation.getVisibility() == JvmVisibility.PRIVATE || !this.featureOverridesService.isOverridden((JvmFeature)operation, (JvmFeature)superOperation, typeArgumentContext, false)) continue;
            return superOperation;
        }
        return null;
    }

    protected Iterable<JvmOperation> allSuperOperations(JvmDeclaredType type) {
        Set superTypes = this.superTypeCollector.collectSuperTypes((JvmType)type);
        superTypes.add(this.typeReferences.getTypeForName(Object.class, (Notifier)type, new JvmTypeReference[0]));
        Iterable result = Iterables.filter((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)superTypes, (Function)new Function<JvmTypeReference, Iterable<JvmFeature>>(){

            public Iterable<JvmFeature> apply(JvmTypeReference from) {
                return XtendOverridesService.this.featureOverridesService.getAllJvmFeatures(from);
            }
        })), JvmOperation.class);
        return result;
    }

    public JvmTypeReference getOverriddenReturnType(XtendFunction func) {
        final JvmOperation operation = this.findOverriddenOperation(func);
        if (operation == null) {
            return null;
        }
        JvmTypeReference overriddenReturnType = operation.getReturnType();
        final JvmOperation inferredOperation = this.xtendjvmAssociations.getDirectlyInferredOperation(func);
        ITypeArgumentContext typeArgumentContext = this.typeArgumentContextProvider.getTypeArgumentContext((TypeArgumentContextProvider.Request)new TypeArgumentContextProvider.AbstractRequest(){

            public JvmTypeParameterDeclarator getNearestDeclarator() {
                return inferredOperation;
            }

            public JvmTypeReference getReceiverType() {
                return XtendOverridesService.this.typeReferences.createTypeRef((JvmType)inferredOperation.getDeclaringType(), new JvmTypeReference[0]);
            }

            public JvmFeature getFeature() {
                return operation;
            }

            public List<JvmTypeReference> getExplicitTypeArgument() {
                EList parameters = inferredOperation.getTypeParameters();
                ArrayList result = Lists.newArrayList();
                for (JvmTypeParameter typeParameter : parameters) {
                    result.add(XtendOverridesService.this.typeReferences.createTypeRef((JvmType)typeParameter, new JvmTypeReference[0]));
                }
                return result;
            }
        });
        JvmTypeReference resolved = typeArgumentContext.resolve(overriddenReturnType);
        return resolved;
    }
}

