/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.scoping.batch.FeatureScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IBatchScopeProvider;
import org.eclipse.xtext.xbase.scoping.batch.IFeatureScopeSession;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeProviderAccess {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private IQualifiedNameConverter qualifiedNameConverter;
    @Inject
    private FeatureScopeProvider featureScopeProvider;
    @Inject
    private IBatchScopeProvider constructorScopeProvider;
    @Inject
    private LazyURIEncoder encoder;

    public Iterable<IEObjectDescription> getCandidateDescriptions(XExpression expression, EReference reference, IFeatureScopeSession session, IResolvedTypes types) throws IllegalNodeException {
        EObject toBeLinked = (EObject)expression.eGet((EStructuralFeature)reference, false);
        if (toBeLinked == null) {
            return Collections.emptyList();
        }
        if (!toBeLinked.eIsProxy()) {
            throw new IllegalStateException(expression + " was already linked to " + toBeLinked);
        }
        URI uri = EcoreUtil.getURI((EObject)toBeLinked);
        String fragment = uri.fragment();
        if (this.encoder.isCrossLinkFragment(expression.eResource(), fragment)) {
            List split = Strings.split((String)fragment, (String)"::");
            ICompositeNode compositeNode = NodeModelUtils.getNode((EObject)expression);
            if (compositeNode == null) {
                throw new IllegalStateException("Couldn't resolve lazy link, because no node model is attached.");
            }
            INode node = this.encoder.getNode((INode)compositeNode, (String)split.get(3));
            EClass requiredType = reference.getEReferenceType();
            if (requiredType == null) {
                return Collections.emptyList();
            }
            String crossRefString = this.linkingHelper.getCrossRefNodeAsString(node, true);
            if (crossRefString != null && !crossRefString.equals("")) {
                IScope scope = session.getScope(expression, reference, types);
                QualifiedName qualifiedLinkName = this.qualifiedNameConverter.toQualifiedName(crossRefString);
                Iterable descriptions = scope.getElements(qualifiedLinkName);
                return descriptions;
            }
            return Collections.emptyList();
        }
        throw new IllegalStateException(expression + " uses unsupported uri fragment " + uri);
    }
}

