/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typing;

import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.TypeArgumentContextProvider;
import org.eclipse.xtext.xbase.typing.Closures;
import org.eclipse.xtext.xbase.typing.SynonymTypesProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XbaseTypeArgumentContextProvider
extends TypeArgumentContextProvider {
    @Inject
    private Closures closures;
    @Inject
    private SynonymTypesProvider synonymTypeProvider;

    protected void resolveAgainstActualType(JvmTypeReference declaredType, JvmTypeReference actualType, Multimap<JvmTypeParameter, TypeArgumentContextProvider.ResolveInfo> result, boolean allowWildcardResolutions, int hint) {
        JvmTypeReference declaredClosureType = this.closures.getCompatibleFunctionType(declaredType, false, false);
        JvmTypeReference actualClosureType = this.closures.getCompatibleFunctionType(actualType, true, false);
        if (declaredClosureType == null || actualClosureType == null) {
            super.resolveAgainstActualType(declaredType, actualType, result, allowWildcardResolutions, hint);
            Set<JvmTypeReference> actualSynonyms = this.synonymTypeProvider.getSynonymTypes(actualType, true);
            for (JvmTypeReference synonym : actualSynonyms) {
                super.resolveAgainstActualType(declaredType, synonym, result, allowWildcardResolutions, hint);
            }
        } else {
            super.resolveAgainstActualType(declaredClosureType, actualClosureType, result, allowWildcardResolutions, hint);
        }
    }
}

