/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.ui.internal.views.markers.CachedMarkerBuilder;
import org.eclipse.ui.internal.views.markers.ExtendedMarkersView;
import org.eclipse.ui.internal.views.markers.MarkerUpdateJob;
import org.eclipse.ui.internal.views.markers.UIUpdateJob;

class MarkerUpdateScheduler {
    static final int SHORT_DELAY = 150;
    static final int LONG_DELAY = 10000;
    static final long TIME_OUT = 30000L;
    private CachedMarkerBuilder builder;
    private ExtendedMarkersView view;
    private MarkerUpdateJob updateJob;
    private UIUpdateJob uiUpdateJob;
    private final Object schedulingLock;
    private MarkerUpdateTimer updateTimer;

    public MarkerUpdateScheduler(ExtendedMarkersView view, CachedMarkerBuilder builder) {
        this.view = view;
        this.builder = builder;
        this.schedulingLock = new Object();
        this.updateTimer = new MarkerUpdateTimer();
    }

    Object getSchedulingLock() {
        return this.schedulingLock;
    }

    void scheduleUpdate(long delay, boolean cancelPrevious, boolean[] changeFlags) {
        this.builder.setBuilding(true);
        if (cancelPrevious) {
            this.cancelQueuedUIUpdates();
            this.cancelUpdate();
        }
        this.updateJob = this.builder.scheduleUpdateJob(delay, true, changeFlags);
    }

    void scheduleUpdate(long delay, boolean cancelPrevious) {
        this.builder.setBuilding(true);
        if (cancelPrevious) {
            this.cancelQueuedUIUpdates();
            this.cancelUpdate();
        }
        this.updateJob = this.builder.scheduleUpdateJob(delay, true);
    }

    void scheduleUpdate(long delay, boolean[] changeFlags) {
        this.scheduleUpdate(delay, true, changeFlags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleUpdate(boolean[] changeFlags) {
        MarkerUpdateTimer markerUpdateTimer = this.updateTimer;
        synchronized (markerUpdateTimer) {
            this.builder.updateChangeFlags(changeFlags);
            this.updateTimer.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleUpdate() {
        MarkerUpdateTimer markerUpdateTimer = this.updateTimer;
        synchronized (markerUpdateTimer) {
            this.updateTimer.update();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void speedUpPendingUpdates() {
        MarkerUpdateTimer markerUpdateTimer = this.updateTimer;
        synchronized (markerUpdateTimer) {
            this.updateTimer.speedUpPendingUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean updatesPending() {
        MarkerUpdateTimer markerUpdateTimer = this.updateTimer;
        synchronized (markerUpdateTimer) {
            block7: {
                if (!this.builder.isBuilding()) break block7;
                return true;
            }
            boolean pending = false;
            if (this.updateJob != null) {
                boolean bl = pending = this.updateJob.getState() != 0;
            }
            if (!pending && this.uiUpdateJob != null) {
                boolean bl = pending = this.uiUpdateJob.getState() != 0;
            }
            if (!pending) {
                pending = this.updateTimer.updatesPending();
            }
            return pending;
        }
    }

    void scheduleUIUpdate(long delay) {
        this.uiUpdateJob = this.view.scheduleUpdate(delay);
    }

    void cancelUpdate() {
        this.builder.cancelUpdate();
    }

    void cancelQueuedUIUpdates() {
        this.view.cancelQueuedUpdates();
    }

    class MarkerUpdateTimer {
        private final long CANCEL_MARGIN_DELAY = 450L;
        private final long NO_CANCEL_TIME_OUT = 30000L;
        private static final long AFTER_MARGIN = 2L;
        private long timeB4Update;
        private long timerValidStart;

        MarkerUpdateTimer() {
        }

        void update() {
            long startTime = MarkerUpdateScheduler.this.view.getLastUIRefreshTime();
            long currentTime = System.currentTimeMillis();
            long updateTimeGap = currentTime - startTime;
            boolean cancelable = updateTimeGap <= 30000L;
            updateTimeGap %= 30000L;
            if (!cancelable) {
                boolean bl = cancelable = !this.isValidTimeOut(startTime, currentTime, 30000L);
                if (this.timeB4Update != -1L && cancelable && updateTimeGap < 450L) {
                    updateTimeGap = 450L;
                }
            }
            if (this.timeB4Update == -1L) {
                this.go(450L, cancelable);
                return;
            }
            long delay = 30000L - updateTimeGap;
            if (delay + updateTimeGap > 30000L) {
                if (delay > 30000L) {
                    delay = 10000L;
                }
                if (this.isValidTimeOut(startTime, currentTime, 30000L)) {
                    cancelable = false;
                }
            }
            if (!MarkerUpdateScheduler.this.builder.getMarkerListener().workspaceBuilding()) {
                if (updateTimeGap + 10000L > 30000L) {
                    if (updateTimeGap + 450L >= 30000L) {
                        this.go(delay, false);
                    } else {
                        this.go(delay, cancelable);
                    }
                } else {
                    this.go(10000L, cancelable);
                }
            } else {
                this.go(delay, cancelable);
            }
        }

        void speedUpPendingUpdates() {
            if (this.updatesPending()) {
                this.timeB4Update = -1L;
                this.update();
            }
            this.timeB4Update = -1L;
        }

        boolean updatesPending() {
            long diff = this.timeB4Update - System.currentTimeMillis();
            return diff > 450L;
        }

        private boolean isValidTimeOut(long startTime, long currentTime, long timeOut) {
            if (this.timeB4Update != -1L && startTime > this.timeB4Update) {
                this.timerValidStart = currentTime;
                return false;
            }
            return currentTime - this.timerValidStart >= timeOut;
        }

        private void go(long delay, boolean cancelPrevious) {
            this.timeB4Update = System.currentTimeMillis() + delay;
            MarkerUpdateScheduler.this.scheduleUpdate(delay + 2L, cancelPrevious);
        }
    }
}

