/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangePool;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.Infector;
import org.eclipse.stem.diseasemodels.standard.SI;
import org.eclipse.stem.diseasemodels.standard.SIInfector;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardFactory;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SILabelValueImpl;
import org.eclipse.stem.diseasemodels.standard.impl.StandardDiseaseModelImpl;

public class SIImpl
extends StandardDiseaseModelImpl
implements SI {
    protected static final double TRANSMISSION_RATE_EDEFAULT = 0.0;
    protected double transmissionRate = 0.0;
    protected static final double NON_LINEARITY_COEFFICIENT_EDEFAULT = 1.0;
    protected double nonLinearityCoefficient = 1.0;
    protected static final double RECOVERY_RATE_EDEFAULT = 0.0;
    protected double recoveryRate = 0.0;
    protected static final double INFECTIOUS_MORTALITY_RATE_EDEFAULT = 0.0;
    protected double infectiousMortalityRate = 0.0;

    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedInfectiousMortalityRate = this.getAdjustedInfectiousMortalityRate(timeDelta);
        double transmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SILabelValue currentSI = (SILabelValue)currentState;
            double diseaseDeaths = adjustedInfectiousMortalityRate * currentSI.getI();
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSI.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * currentSI.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * currentSI.getS() * effectiveInfectious;
            double numberOfInfectedToSusceptible = adjustedRecoveryRate * currentSI.getI();
            double deltaS = -numberOfSusceptibleToInfected + numberOfInfectedToSusceptible;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToSusceptible - diseaseDeaths;
            SILabelValueImpl ret = (SILabelValueImpl)deltaValue;
            Exchange siExchange = (Exchange)ExchangePool.POOL.get();
            siExchange.setSource(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            siExchange.setTarget(StandardPackage.eINSTANCE.getSILabelValue_I());
            siExchange.setCount(numberOfSusceptibleToInfected);
            siExchange.getForIncidence().add((Object)StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence());
            siExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)siExchange);
            Exchange isExchange = (Exchange)ExchangePool.POOL.get();
            isExchange.setSource(StandardPackage.eINSTANCE.getSILabelValue_I());
            isExchange.setTarget(StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S());
            isExchange.setCount(numberOfInfectedToSusceptible);
            isExchange.setType(ExchangeType.COMPARTMENT_TRANSITION);
            ret.getDepartures().add((Object)isExchange);
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setDiseaseDeaths(diseaseDeaths);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    public double getTransmissionRateScaleFactor(StandardDiseaseModelLabel diseaseLabel) {
        double referenceDensity = this.getReferencePopulationDensity();
        assert (this.getArea(diseaseLabel.getPopulationLabel()) > 0.0);
        double localDensity = ((StandardDiseaseModelLabelValue)diseaseLabel.getTempValue()).getPopulationCount() / this.getArea(diseaseLabel.getPopulationLabel());
        return localDensity / referenceDensity;
    }

    @Override
    public DiseaseModelLabel createDiseaseModelLabel(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSILabel();
    }

    @Override
    public DiseaseModelLabelValue createDiseaseModelLabelValue(String populationIdentifier) {
        return StandardFactory.eINSTANCE.createSILabelValue();
    }

    @Override
    public Infector createInfector() {
        SIInfector retValue = StandardFactory.eINSTANCE.createSIInfector();
        retValue.setDiseaseName(this.getDiseaseName());
        retValue.setPopulationIdentifier(this.getPopulationIdentifier());
        return retValue;
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.SI;
    }

    @Override
    public double getTransmissionRate() {
        return this.transmissionRate;
    }

    @Override
    public void setTransmissionRate(double newTransmissionRate) {
        this.transmissionRate = newTransmissionRate;
    }

    @Override
    public double getRecoveryRate() {
        return this.recoveryRate;
    }

    @Override
    public void setRecoveryRate(double newRecoveryRate) {
        this.recoveryRate = newRecoveryRate;
    }

    @Override
    public double getInfectiousMortalityRate() {
        return this.infectiousMortalityRate;
    }

    @Override
    public void setInfectiousMortalityRate(double newInfectiousMortalityRate) {
        this.infectiousMortalityRate = newInfectiousMortalityRate;
    }

    @Override
    public double getAdjustedInfectiousMortalityRate(long timeDelta) {
        return this.getInfectiousMortalityRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public double getNonLinearityCoefficient() {
        return this.nonLinearityCoefficient;
    }

    @Override
    public void setNonLinearityCoefficient(double newNonLinearityCoefficient) {
        this.nonLinearityCoefficient = newNonLinearityCoefficient;
    }

    @Override
    public double getAdjustedTransmissionRate(long timeDelta) {
        return this.getTransmissionRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public double getAdjustedRecoveryRate(long timeDelta) {
        return this.getRecoveryRate() * ((double)timeDelta / (double)this.getTimePeriod());
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 19: {
                return this.getTransmissionRate();
            }
            case 20: {
                return this.getNonLinearityCoefficient();
            }
            case 21: {
                return this.getRecoveryRate();
            }
            case 22: {
                return this.getInfectiousMortalityRate();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 19: {
                this.setTransmissionRate((Double)newValue);
                return;
            }
            case 20: {
                this.setNonLinearityCoefficient((Double)newValue);
                return;
            }
            case 21: {
                this.setRecoveryRate((Double)newValue);
                return;
            }
            case 22: {
                this.setInfectiousMortalityRate((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 19: {
                this.setTransmissionRate(0.0);
                return;
            }
            case 20: {
                this.setNonLinearityCoefficient(1.0);
                return;
            }
            case 21: {
                this.setRecoveryRate(0.0);
                return;
            }
            case 22: {
                this.setInfectiousMortalityRate(0.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 19: {
                return this.transmissionRate != 0.0;
            }
            case 20: {
                return this.nonLinearityCoefficient != 1.0;
            }
            case 21: {
                return this.recoveryRate != 0.0;
            }
            case 22: {
                return this.infectiousMortalityRate != 0.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (transmissionRate: ");
        result.append(this.transmissionRate);
        result.append(", nonLinearityCoefficient: ");
        result.append(this.nonLinearityCoefficient);
        result.append(", recoveryRate: ");
        result.append(this.recoveryRate);
        result.append(", infectiousMortalityRate: ");
        result.append(this.infectiousMortalityRate);
        result.append(')');
        return result.toString();
    }

    @Override
    public boolean sane() {
        boolean retValue = super.sane();
        boolean bl = retValue = retValue && this.getTransmissionRate() >= 0.0;
        assert (retValue);
        boolean bl2 = retValue = retValue && !Double.isInfinite(this.getTransmissionRate());
        assert (retValue);
        boolean bl3 = retValue = retValue && !Double.isNaN(this.getTransmissionRate());
        assert (retValue);
        boolean bl4 = retValue = retValue && this.getRecoveryRate() >= 0.0;
        assert (retValue);
        boolean bl5 = retValue = retValue && !Double.isInfinite(this.getRecoveryRate());
        assert (retValue);
        boolean bl6 = retValue = retValue && !Double.isNaN(this.getRecoveryRate());
        assert (retValue);
        boolean bl7 = retValue = retValue && this.getNonLinearityCoefficient() >= 0.0;
        assert (retValue);
        boolean bl8 = retValue = retValue && !Double.isInfinite(this.getNonLinearityCoefficient());
        assert (retValue);
        boolean bl9 = retValue = retValue && !Double.isNaN(this.getNonLinearityCoefficient());
        assert (retValue);
        return retValue;
    }
}

