/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.provider.StandardItemProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.util.StandardAdapterFactory;

public class StandardRelativeValueProviderAdapterFactory
extends StandardAdapterFactory
implements RelativeValueProviderAdapterFactory {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    private static StandardItemProviderAdapterFactory itemProviderFactory;

    public StandardRelativeValueProviderAdapterFactory() {
        RelativeValueProviderAdapterFactory.INSTANCE.addAdapterFactory((AdapterFactory)this);
    }

    @Override
    public Adapter createDiseaseModelLabelAdapter() {
        return new DiseaseModelLabelRelativeValueProvider();
    }

    @Override
    public Adapter createDiseaseModelLabelValueAdapter() {
        return new DiseaseModelLabelValueRelativeValueProvider();
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    @Override
    public boolean isFactoryForType(Object type) {
        return type == RelativeValueProvider.class || super.isFactoryForType(type);
    }

    public void dispose() {
    }

    private static RelativeValueProviderAdapterFactory getRelativeValueProviderAdapterFactory() {
        return RelativeValueProviderAdapterFactory.INSTANCE;
    }

    private static StandardItemProviderAdapterFactory getItemProviderFactory() {
        if (itemProviderFactory == null) {
            itemProviderFactory = new StandardItemProviderAdapterFactory();
        }
        return itemProviderFactory;
    }

    public static class DiseaseModelLabelRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            DiseaseModelLabel dml = (DiseaseModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)dml.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getProperties();
        }

        public double getRelativeValue(EStructuralFeature feature) {
            DiseaseModelLabel dml = (DiseaseModelLabel)this.getTarget();
            RelativeValueProvider rvp = (RelativeValueProvider)StandardRelativeValueProviderAdapterFactory.getRelativeValueProviderAdapterFactory().adapt((Notifier)dml.getCurrentValue(), RelativeValueProvider.class);
            return rvp.getRelativeValue(feature);
        }

        public double getDenominator(EStructuralFeature feature) {
            DiseaseModelLabel dml = (DiseaseModelLabel)this.getTarget();
            StandardDiseaseModelLabelValue dmlv = (StandardDiseaseModelLabelValue)dml.getCurrentValue();
            return dmlv.getPopulationCount();
        }
    }

    public static class DiseaseModelLabelValueRelativeValueProvider
    extends RelativeValueProviderAdapter
    implements RelativeValueProvider {
        public List<IItemPropertyDescriptor> getProperties() {
            ArrayList<IItemPropertyDescriptor> retValue = new ArrayList<IItemPropertyDescriptor>();
            StandardItemProviderAdapterFactory itemProviderFactory = StandardRelativeValueProviderAdapterFactory.getItemProviderFactory();
            DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)this.getTarget();
            IItemPropertySource propertySource = (IItemPropertySource)itemProviderFactory.adapt((Notifier)dmlv, (Object)PropertySource.class);
            List properties = propertySource.getPropertyDescriptors(null);
            for (IItemPropertyDescriptor descriptor : properties) {
                EStructuralFeature feature = (EStructuralFeature)descriptor.getFeature(null);
                if (feature instanceof EReference) continue;
                feature.getFeatureID();
                retValue.add(descriptor);
            }
            return retValue;
        }

        public double getRelativeValue(EStructuralFeature feature) {
            DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)this.getTarget();
            double stateCount = (Double)dmlv.eGet(feature);
            double populationCount = dmlv.getPopulationCount();
            double retValue = populationCount <= 0.0 ? 0.0 : stateCount / populationCount;
            return retValue;
        }

        public double getDenominator(EStructuralFeature feature) {
            DiseaseModelLabelValue dmlv = (DiseaseModelLabelValue)this.getTarget();
            return dmlv.getPopulationCount();
        }
    }
}

