/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import com.ibm.icu.util.Calendar;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.computation.DataSetIterator;
import org.eclipse.birt.chart.computation.IConstants;
import org.eclipse.birt.chart.computation.LabelLimiter;
import org.eclipse.birt.chart.computation.LegendItemRenderingHints;
import org.eclipse.birt.chart.computation.Methods;
import org.eclipse.birt.chart.computation.PlotComputation;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.IntersectionValue;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisOrigin;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Grid;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.render.AxesRenderer;
import org.eclipse.birt.chart.render.IAxesDecorator;
import org.eclipse.birt.chart.util.CDateTime;
import org.eclipse.birt.chart.util.ChartUtil;

public abstract class PlotWithAxes
extends PlotComputation
implements IConstants {
    protected static final double AXIS_TITLE_PERCENT = 0.3;
    protected int iDimension = 0;
    protected double dSeriesThickness = 10.0;
    protected double dXAxisPlotSpacing = 0.0;
    protected double dYAxisPlotSpacing = 0.0;
    protected AllAxes aax = null;
    protected Bounds boPlot = goFactory.createBounds(0.0, 0.0, 100.0, 100.0);
    protected AlignZeroHelper azHelper = null;

    public PlotWithAxes(IDisplayServer ids, RunTimeContext rtc, ChartWithAxes cwa) {
        super(ids, rtc, cwa);
    }

    public void putLabelLimiter(Label la, LabelLimiter lbLimit) {
        Map<Label, LabelLimiter> mapLimiter = this.rtc.getState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY);
        mapLimiter.put(la, lbLimit);
    }

    public LabelLimiter getLabellLimiter(Label la) {
        Map<Label, LabelLimiter> mapLimiter = this.rtc.getState(RunTimeContext.StateKey.LABEL_LIMITER_LOOKUP_KEY);
        return mapLimiter.get(la);
    }

    protected static final int getDimension(ChartDimension cd) {
        switch (cd.getValue()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 0;
    }

    public static final int getAxisType(Axis ax) {
        int iAxisType = 0;
        AxisType at = ax.getType();
        switch (at.getValue()) {
            case 0: {
                iAxisType = 3;
                break;
            }
            case 1: {
                iAxisType = 5;
                break;
            }
            case 2: {
                iAxisType = 16;
                break;
            }
            case 3: {
                iAxisType = 8;
            }
        }
        if (ax.isPercent()) {
            iAxisType |= 0x20;
        }
        return iAxisType;
    }

    protected static final int getTickStyle(Axis ax, int iMajorOrMinor) {
        int iTickStyle = 0;
        Grid gr = iMajorOrMinor == 0 ? ax.getMajorGrid() : ax.getMinorGrid();
        LineAttributes lia = gr.getTickAttributes();
        if (!lia.isVisible()) {
            return iTickStyle;
        }
        TickStyle ts = gr.getTickStyle();
        switch (ts.getValue()) {
            case 0: {
                iTickStyle = 1;
                break;
            }
            case 1: {
                iTickStyle = 2;
                break;
            }
            case 2: {
                iTickStyle = 1;
                break;
            }
            case 3: {
                iTickStyle = 2;
                break;
            }
            case 4: {
                iTickStyle = 3;
            }
        }
        return iTickStyle;
    }

    protected static final IntersectionValue getIntersection(Axis ax) {
        IntersectionValue iv = null;
        AxisOrigin ao = ax.getOrigin();
        iv = ao.getType() == IntersectionType.MAX_LITERAL ? IntersectionValue.MAX_VALUE : (ao.getType() == IntersectionType.MIN_LITERAL ? IntersectionValue.MIN_VALUE : new IntersectionValue(3, ao.getValue()));
        return iv;
    }

    public final int getDimension() {
        return this.iDimension;
    }

    public final double getSeriesThickness() {
        return this.dSeriesThickness;
    }

    public final double getHorizontalSpacingInPixels() {
        return this.dXAxisPlotSpacing;
    }

    public final double getVerticalSpacingInPixels() {
        return this.dYAxisPlotSpacing;
    }

    abstract void buildAxes() throws IllegalArgumentException, ChartException;

    public final AllAxes getAxes() {
        return this.aax;
    }

    public final IDisplayServer getDisplayServer() {
        return this.ids;
    }

    protected final OneAxis findOrthogonalAxis(Series se) {
        Axis[] axaBase = ((ChartWithAxesImpl)this.getModel()).getBaseAxes();
        Axis axPrimaryBase = axaBase[0];
        Axis[] axaOrthogonal = ((ChartWithAxesImpl)this.getModel()).getOrthogonalAxes(axPrimaryBase, true);
        int i = 0;
        while (i < axaOrthogonal.length) {
            Series[] sea = axaOrthogonal[i].getRuntimeSeries();
            int j = 0;
            while (j < sea.length) {
                if (sea[j] == se) {
                    if (i == 0) {
                        return this.aax.getPrimaryOrthogonal();
                    }
                    return this.aax.getOverlay(i - 1);
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    protected void validateAxis(Axis ax) throws ChartException {
        int iOrientation = ax.getOrientation().getValue();
        if (iOrientation == 1) {
            int iPosition = -1;
            if (ax.getLabel().isVisible() && (iPosition = ax.getLabelPosition().getValue()) != 2 && iPosition != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.vaxis.label.position", new Object[]{ax.getLabelPosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            if (ax.getTitle().isVisible() && (iPosition = ax.getTitlePosition().getValue()) != 2 && iPosition != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.vaxis.title.position", new Object[]{ax.getLabelPosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            int iTickStyle = ax.getMajorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 0 && iTickStyle != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.vaxis.major.tick.style", new Object[]{ax.getMajorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            iTickStyle = ax.getMinorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 0 && iTickStyle != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.vaxis.minor.tick.style", new Object[]{ax.getMinorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
        } else if (iOrientation == 0) {
            int iPosition = -1;
            if (ax.getLabel().isVisible() && (iPosition = ax.getLabelPosition().getValue()) != 0 && iPosition != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.haxis.label.position", new Object[]{ax.getLabelPosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            if (ax.getTitle().isVisible() && (iPosition = ax.getTitlePosition().getValue()) != 0 && iPosition != 1) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.haxis.title.position", new Object[]{ax.getTitlePosition().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            int iTickStyle = ax.getMajorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 2 && iTickStyle != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.haxis.major.tick.style", new Object[]{ax.getMajorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
            iTickStyle = ax.getMinorGrid().getTickStyle().getValue();
            if (iTickStyle != 4 && iTickStyle != 2 && iTickStyle != 3) {
                throw new ChartException("org.eclipse.birt.chart.engine", 30, "exception.illegal.haxis.minor.tick.style", new Object[]{ax.getMinorGrid().getTickStyle().getName(), ax}, Messages.getResourceBundle(this.rtc.getULocale()));
            }
        }
    }

    protected final DataSetIterator getTypedDataSet(Axis ax, int iType, int iSeriesIndex) throws ChartException, IllegalArgumentException {
        Series[] sea = ax.getRuntimeSeries();
        if (sea.length == 0) {
            if ((iType & 1) == 1) {
                return new DataSetIterator(new Double[]{new Double(1.0), new Double(2.0)});
            }
            if ((iType & 8) == 8) {
                return new DataSetIterator(new Calendar[]{new CDateTime(), new CDateTime()});
            }
            if ((iType & 0x10) == 16) {
                return new DataSetIterator(new String[]{"Category1", "Category2", "Category3"});
            }
        }
        return this.getTypedDataSet(sea[iSeriesIndex], iType);
    }

    protected final DataSetIterator getTypedDataSet(Series se, int iType) throws ChartException, IllegalArgumentException {
        DataSetIterator dsi = PlotWithAxes.checkDataType(se, iType, this.rtc);
        dsi.reverse(this.getModel().isReverseCategory());
        return dsi;
    }

    public static DataSetIterator checkDataType(Series se, int iType, RunTimeContext rtc) throws ChartException {
        DataSetIterator dsi = new DataSetIterator(se.getDataSet());
        if ((dsi.getDataType() & 0x10) == 16 && ((iType & 2) == 2 || (iType & 4) == 4 || (iType & 8) == 8)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.text.data.numerical.datetime.axis", Messages.getResourceBundle(rtc.getULocale()));
        }
        if ((dsi.getDataType() & 1) == 1 && (iType & 8) == 8) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.numerical.data.datetime.axis", Messages.getResourceBundle(rtc.getULocale()));
        }
        if ((dsi.getDataType() & 8) == 8 && ((iType & 2) == 2 || (iType & 4) == 4)) {
            throw new ChartException("org.eclipse.birt.chart.engine", 1, "exception.datetime.data.numerical.axis", Messages.getResourceBundle(rtc.getULocale()));
        }
        return dsi;
    }

    protected final int getOrientation(int iBaseOrOrthogonal) {
        if (!this.getModel().isTransposed()) {
            return iBaseOrOrthogonal == 1 || iBaseOrOrthogonal == 3 ? 0 : 1;
        }
        return iBaseOrOrthogonal == 1 || iBaseOrOrthogonal == 3 ? 1 : 0;
    }

    public final double getTransposedAngle(double dOriginalAngle) throws IllegalArgumentException {
        if (dOriginalAngle >= 0.0 && dOriginalAngle <= 90.0) {
            return -(90.0 - dOriginalAngle);
        }
        if (dOriginalAngle < 0.0 && dOriginalAngle >= -90.0) {
            return dOriginalAngle + 90.0;
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.angle.range.transpose"), new Double(dOriginalAngle)));
    }

    public final int transposeLabelPosition(int iBaseOrOrthogonal, int iOriginalPosition) throws IllegalArgumentException {
        if (!this.getModel().isTransposed()) {
            return iOriginalPosition;
        }
        if (iBaseOrOrthogonal == 1) {
            switch (iOriginalPosition) {
                case 4: {
                    return 2;
                }
                case 8: {
                    return 1;
                }
                case 16: 
                case 32: {
                    return iOriginalPosition;
                }
            }
        } else if (iBaseOrOrthogonal == 2) {
            switch (iOriginalPosition) {
                case 4: {
                    return 2;
                }
                case 8: {
                    return 1;
                }
                case 1: {
                    return 8;
                }
                case 2: {
                    return 4;
                }
                case 16: 
                case 32: {
                    return iOriginalPosition;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.combination.axis.label.position"), iBaseOrOrthogonal, iOriginalPosition));
    }

    protected final int transposeTickStyle(int iBaseOrOrthogonal, int iOriginalStyle) throws IllegalArgumentException {
        if (!this.getModel().isTransposed() || iOriginalStyle == 3 || iOriginalStyle == 0) {
            return iOriginalStyle;
        }
        if (iBaseOrOrthogonal == 1) {
            switch (iOriginalStyle) {
                case 2: {
                    return 1;
                }
                case 1: {
                    return 2;
                }
            }
        } else if (iBaseOrOrthogonal == 2) {
            switch (iOriginalStyle) {
                case 1: {
                    return 2;
                }
                case 2: {
                    return 1;
                }
            }
        }
        throw new IllegalArgumentException(MessageFormat.format(Messages.getResourceBundle(this.rtc.getULocale()).getString("exception.combination.axis.tick.style"), iBaseOrOrthogonal, iOriginalStyle));
    }

    protected final double adjustHorizontal(double dBlockX, double dBlockWidth, AllAxes aax, OneAxis orthogonalAxis) throws ChartException, IllegalArgumentException {
        double dFixedLabelThickness;
        double rightTickSize;
        double leftTickSize;
        double v;
        double dX;
        OneAxis axPH = aax.areAxesSwapped() ? orthogonalAxis : aax.getPrimaryBase();
        OneAxis axPV = aax.areAxesSwapped() ? aax.getPrimaryBase() : orthogonalAxis;
        AutoScale scX = axPH.getScale();
        AutoScale scY = axPV.getScale();
        int iXLabelLocation = axPH.getLabelPosition();
        int iYLabelLocation = axPV.getLabelPosition();
        int iYTitleLocation = axPV.getTitlePosition();
        Label laXAxisLabels = axPH.getLabel();
        Label laYAxisLabels = axPV.getLabel();
        Label laYAxisTitle = axPV.getTitle();
        int iYTickStyle = axPV.getCombinedTickStyle();
        IntersectionValue iv = axPV.getIntersectionValue();
        boolean bTicksLeft = (iYTickStyle & 1) == 1;
        boolean bTicksRight = (iYTickStyle & 2) == 2;
        double dAppliedYAxisPlotSpacing = (iv.iType == 1 || iv.iType == 2) && !aax.getPrimaryOrthogonal().getModelAxis().isLabelWithinAxes() ? this.dYAxisPlotSpacing : 0.0;
        double dStart = scY.getStart();
        double dEnd = scY.getEnd();
        scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
        if (!scY.isStepFixed()) {
            Object[] oaMinMax = scY.getMinMax();
            while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                if (!scY.zoomOut()) break;
                scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                if (scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
            }
        }
        double dYAxisLabelsThickness = scY.computeAxisLabelThickness(this.ids, axPV.getLabel(), 1);
        double[] dDecorationThickness = new double[]{0.0, 0.0};
        Series[] sea = this.getModel().getSeries(2);
        Map<Series, LegendItemRenderingHints> seriesRenderingHints = this.rtc.getSeriesRenderers();
        int i = 0;
        while (i < sea.length) {
            IAxesDecorator iad;
            LegendItemRenderingHints lirh = seriesRenderingHints.get(sea[i]);
            if (lirh != null && lirh.getRenderer() instanceof AxesRenderer && (iad = ((AxesRenderer)lirh.getRenderer()).getAxesDecorator(axPV)) != null) {
                double[] thickness = iad.computeDecorationThickness(this.ids, axPV);
                if (thickness[0] > dDecorationThickness[0]) {
                    dDecorationThickness[0] = thickness[0];
                }
                if (thickness[1] > dDecorationThickness[1]) {
                    dDecorationThickness[1] = thickness[1];
                }
            }
            ++i;
        }
        double dYAxisTitleThickness = 0.0;
        if (laYAxisTitle.isVisible()) {
            String sPreviousValue = laYAxisTitle.getCaption().getValue();
            laYAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
            double maxWidth = 0.3 * this.boPlot.getWidth();
            double maxHeight = this.boPlot.getHeight();
            if (ChartUtil.isStudyLayout(this.getModel())) {
                maxHeight = Math.abs(axPV.getScale().getEndPoints()[1] - axPV.getScale().getEndPoints()[0]);
            }
            LabelLimiter lblLimit = new LabelLimiter(maxWidth, maxHeight, 0.0);
            lblLimit.computeWrapping(this.ids, laYAxisTitle);
            lblLimit = lblLimit.limitLabelSize(this.cComp, this.ids, laYAxisTitle, EnumSet.of(LabelLimiter.Option.FIX_HEIGHT));
            this.putLabelLimiter(axPV.getModelAxis().getTitle(), lblLimit);
            dYAxisTitleThickness = lblLimit.getMaxWidth();
            laYAxisTitle.getCaption().setValue(sPreviousValue);
        }
        double dX1 = dX = PlotWithAxes.getLocation(scX, iv);
        double dX2 = dX;
        double dWTotal = Math.abs(scX.getStart() - scX.getEnd());
        if (axPV.isShowLabels() && axPV.getScale().isCategoryScale() && dYAxisLabelsThickness > (v = (dWTotal - dYAxisTitleThickness - (leftTickSize = bTicksLeft ? this.getTickSize() : 0.0) - (rightTickSize = bTicksRight ? this.getTickSize() : 0.0)) / 2.0)) {
            axPV.getScale().getAxisLabelInfo().dActualSize = dYAxisLabelsThickness;
            dYAxisLabelsThickness = v;
        }
        if (axPV.getModelAxis().isSetLabelSpan() && (dFixedLabelThickness = axPV.getModelAxis().getLabelSpan() * this.dPointToPixel) < dWTotal - 2.0 * this.getTickSize()) {
            if (dYAxisLabelsThickness + dYAxisTitleThickness > dFixedLabelThickness) {
                axPV.setShowLabels(false);
            }
            if (dYAxisTitleThickness > dFixedLabelThickness) {
                laYAxisTitle.setVisible(false);
                dYAxisTitleThickness = 0.0;
            }
            dYAxisLabelsThickness = dFixedLabelThickness;
        }
        dX = iv.iType == 2 ? this.adjustHorizontalWithOrigin(dBlockX, aax, axPV, scX, iXLabelLocation, iYLabelLocation, iYTitleLocation, laXAxisLabels, bTicksLeft, bTicksRight, dAppliedYAxisPlotSpacing, dYAxisLabelsThickness, dDecorationThickness, dYAxisTitleThickness, dX, dWTotal) : (iv.iType == 1 ? this.adjustHorizontalWithMaxOrigin(dBlockX, dBlockWidth, aax, axPV, scX, iXLabelLocation, iYLabelLocation, iYTitleLocation, laXAxisLabels, bTicksLeft, bTicksRight, dAppliedYAxisPlotSpacing, dYAxisLabelsThickness, dDecorationThickness, dYAxisTitleThickness, dX, dWTotal) : this.adjustHorizontalWithValueOrigin(dBlockX, dBlockWidth, aax, axPV, scX, iXLabelLocation, iYLabelLocation, iYTitleLocation, laXAxisLabels, iv, bTicksLeft, bTicksRight, dYAxisLabelsThickness, dDecorationThickness, dYAxisTitleThickness, dX, dX1, dX2, dWTotal));
        return dX;
    }

    private double adjustHorizontalWithValueOrigin(double dBlockX, double dBlockWidth, AllAxes aax, OneAxis axPV, AutoScale scX, int iXLabelLocation, int iYLabelLocation, int iYTitleLocation, Label laXAxisLabels, IntersectionValue iv, boolean bTicksLeft, boolean bTicksRight, double dYAxisLabelsThickness, double[] dDecorationThickness, double dYAxisTitleThickness, double dX, double dX1, double dX2, double dWTotal) throws ChartException {
        double dDeltaX1 = 0.0;
        double dDeltaX2 = 0.0;
        if (iYTitleLocation == 2) {
            dX2 += dYAxisTitleThickness;
        } else if (iYTitleLocation == 1) {
            dX1 -= dYAxisTitleThickness;
        }
        double dW1 = 0.0;
        double dW2 = 0.0;
        if (iYLabelLocation == 1) {
            dW1 = (bTicksLeft ? this.getTickSize() : 0.0) + Math.max(dYAxisLabelsThickness, dDecorationThickness[0]);
            double d = dW2 = bTicksRight ? this.getTickSize() : 0.0;
            if (dW1 + dW2 <= dWTotal) {
                dX1 -= dW1;
                dX2 += dW2;
            } else {
                axPV.setShowLabels(false);
            }
            dDeltaX1 = dX - dX1;
            dDeltaX2 = dX2 - dX;
            if (dX1 < dBlockX) {
                Object[] oaMinMax = scX.getMinMax();
                boolean bForceBreak = false;
                block0: do {
                    double dStart;
                    double dEnd;
                    double dDelta;
                    double dAMax_RI;
                    double dAMin_AMax;
                    scX.setEndPoints(scX.getStart() - scX.getStartShift(), scX.getEnd() + scX.getEndShift());
                    scX.resetShifts();
                    double[] da = scX.getEndPoints();
                    double dT_RI = dBlockX - dX1;
                    if (scX.getDirection() == -1) {
                        dAMin_AMax = da[0] - da[1];
                        dAMax_RI = Math.abs(da[0] - dX);
                        dDelta = dT_RI / dAMax_RI * dAMin_AMax;
                        dEnd = da[1] + dDelta;
                        dStart = da[0];
                        if (dEnd < dBlockX) {
                            dEnd = dBlockX;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[1] - da[0];
                        dAMax_RI = Math.abs(da[1] - dX);
                        dDelta = dT_RI / dAMax_RI * dAMin_AMax;
                        dStart = da[0] + dDelta;
                        dEnd = da[1];
                        if (dStart < dBlockX) {
                            dStart = dBlockX;
                            bForceBreak = true;
                        }
                    }
                    scX.setEndPoints(dStart, dEnd);
                    scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                    while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                        if (!scX.zoomOut()) {
                            bForceBreak = true;
                            continue block0;
                        }
                        scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                        if ((scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) && !this.isSharedScale()) continue;
                        bForceBreak = true;
                        continue block0;
                    }
                } while (Math.abs((dX1 = (dX = PlotWithAxes.getLocation(scX, iv)) - dDeltaX1) - dBlockX) > 1.0 && !bForceBreak);
            } else {
                double dStart = scX.getStart();
                double dEnd = scX.getEnd();
                scX.setEndPoints(dStart, dEnd);
                scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                if (!scX.isStepFixed()) {
                    Object[] oaMinMax = scX.getMinMax();
                    while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                        if (!scX.zoomOut()) break;
                        scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                        if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
                    }
                }
                dX = PlotWithAxes.getLocation(scX, iv);
            }
            dX1 = dX - dDeltaX1;
            dX2 = dX + dDeltaX2;
        } else if (iYLabelLocation == 2) {
            dW1 = bTicksLeft ? this.getTickSize() : 0.0;
            if (dW1 + (dW2 = (bTicksRight ? this.getTickSize() : 0.0) + Math.max(dYAxisLabelsThickness, dDecorationThickness[1])) <= dWTotal) {
                dX1 -= dW1;
                dX2 += dW2;
            }
            dDeltaX1 = dX - dX1;
            dDeltaX2 = dX2 - dX;
            if (dX2 > dBlockX + dBlockWidth) {
                Object[] oaMinMax = scX.getMinMax();
                boolean bForceBreak = false;
                block3: do {
                    double dEnd;
                    double dStart;
                    double dDelta;
                    double dAMin_RI;
                    double dAMin_AMax;
                    scX.setEndPoints(scX.getStart() - scX.getStartShift(), scX.getEnd() + scX.getEndShift());
                    scX.resetShifts();
                    double[] da = scX.getEndPoints();
                    double dT_RI = dX2 - (dBlockX + dBlockWidth);
                    if (scX.getDirection() == -1) {
                        dAMin_AMax = da[0] - da[1];
                        dAMin_RI = Math.abs(dX - da[1]);
                        dDelta = Math.abs(dT_RI / dAMin_RI) * dAMin_AMax;
                        dStart = da[0] - dDelta;
                        dEnd = da[1];
                        if (dStart > dBlockX + dBlockWidth) {
                            dStart = dBlockX + dBlockWidth;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[1] - da[0];
                        dAMin_RI = Math.abs(dX - da[0]);
                        dDelta = dT_RI / dAMin_RI * dAMin_AMax;
                        dEnd = da[1] - dDelta;
                        dStart = da[0];
                        if (dEnd > dBlockX + dBlockWidth) {
                            dEnd = dBlockX + dBlockWidth;
                            bForceBreak = true;
                        }
                    }
                    scX.setEndPoints(dStart, dEnd);
                    scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                    if (scX.isStepFixed()) continue;
                    while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                        if (!scX.zoomOut()) {
                            bForceBreak = true;
                            continue block3;
                        }
                        scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                        if ((scX.getUnit() == null || PlotWithAxes.asInteger(scX.getUnit()) != 1 || tickCount > 3) && !this.isSharedScale()) continue;
                        bForceBreak = true;
                        continue block3;
                    }
                } while (Math.abs((dX2 = (dX = PlotWithAxes.getLocation(scX, iv)) + dDeltaX2) - (dBlockX + dBlockWidth)) > 1.0 && !bForceBreak);
            } else {
                double dStart = scX.getStart();
                double dEnd = scX.getEnd();
                scX.setEndPoints(dStart, dEnd);
                scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                if (!scX.isStepFixed()) {
                    Object[] oaMinMax = scX.getMinMax();
                    while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                        if (!scX.zoomOut()) break;
                        scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                        int tickCount = scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, aax);
                        if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
                    }
                }
                dX = PlotWithAxes.getLocation(scX, iv);
            }
            dX2 = dX + dDeltaX2;
            dX1 = dX - dDeltaX1;
        }
        this.updateAxisTitleLocationNLabelSize(axPV, iYTitleLocation, dYAxisTitleThickness, dWTotal, dX, dX1, dX2);
        return dX;
    }

    private void updateAxisTitleLocationNLabelSize(OneAxis axPV, int iYTitleLocation, double dYAxisTitleThickness, double dWTotal, double dX, double dX1, double dX2) {
        if (axPV.isShowLabels() && axPV.getScale().isCategoryScale()) {
            AutoScale.AxisLabelInfo ali = axPV.getScale().getAxisLabelInfo();
            if (axPV.getLabelPosition() == 1) {
                double tickSize = (axPV.getCombinedTickStyle() & 1) == 1 ? this.getTickSize() : 0.0;
                double labelThickness = dX - dX1 - tickSize - (iYTitleLocation == 1 ? dYAxisTitleThickness : 0.0);
                ali.dMaxSize = labelThickness = ali.getValidSize(labelThickness);
                axPV.setTitleCoordinate(iYTitleLocation == 1 ? dX - 1.0 - tickSize - labelThickness - dYAxisTitleThickness : dX2 + 1.0 - dYAxisTitleThickness);
            } else if (axPV.getLabelPosition() == 2) {
                double tickSize = (axPV.getCombinedTickStyle() & 2) == 2 ? this.getTickSize() : 0.0;
                double labelThickness = dX2 - dX - tickSize - (iYTitleLocation == 2 ? dYAxisTitleThickness : 0.0);
                ali.dMaxSize = labelThickness = ali.getValidSize(labelThickness);
                axPV.setTitleCoordinate(iYTitleLocation == 1 ? dX1 - 1.0 : dX + 1.0 + tickSize + labelThickness);
            }
        } else {
            axPV.setTitleCoordinate(iYTitleLocation == 1 ? dX1 - 1.0 : dX2 + 1.0 - dYAxisTitleThickness);
        }
    }

    private double adjustHorizontalWithMaxOrigin(double dBlockX, double dBlockWidth, AllAxes aax, OneAxis axPV, AutoScale scX, int iXLabelLocation, int iYLabelLocation, int iYTitleLocation, Label laXAxisLabels, boolean bTicksLeft, boolean bTicksRight, double dAppliedYAxisPlotSpacing, double dYAxisLabelsThickness, double[] dDecorationThickness, double dYAxisTitleThickness, double dX, double dWTotal) throws ChartException {
        double dEnd;
        double dStart;
        if (scX.getDirection() == -1) {
            dX = PlotWithAxes.getLocation(scX, IntersectionValue.MIN_VALUE);
        }
        dWTotal -= dAppliedYAxisPlotSpacing;
        double dX1 = dX += dAppliedYAxisPlotSpacing;
        double dX2 = dX;
        if (bTicksRight && this.getTickSize() <= dWTotal) {
            dX2 += this.getTickSize();
            dWTotal -= this.getTickSize();
        }
        double dW1 = 0.0;
        double dW2 = 0.0;
        if (iYLabelLocation == 2) {
            dW1 = Math.max((bTicksLeft ? this.getTickSize() : 0.0) + dDecorationThickness[0], dAppliedYAxisPlotSpacing);
            dW2 = Math.max(dYAxisLabelsThickness, dDecorationThickness[1]);
        } else if (iYLabelLocation == 1) {
            dW1 = Math.max((bTicksLeft ? this.getTickSize() : 0.0) + Math.max(dYAxisLabelsThickness, dDecorationThickness[0]), dAppliedYAxisPlotSpacing);
            dW2 = dDecorationThickness[1];
        }
        if (dW1 + dW2 <= dWTotal) {
            dX1 -= dW1;
            dX2 += dW2;
        } else {
            axPV.setShowLabels(false);
        }
        if (iYTitleLocation == 2) {
            dX2 += dYAxisTitleThickness;
        } else if (iYTitleLocation == 1) {
            dX1 -= dYAxisTitleThickness;
        }
        if (dX2 > dBlockX + dBlockWidth) {
            double dDelta = dX2 - (dBlockX + dBlockWidth);
            dX2 = dBlockX + dBlockWidth;
            dX -= dDelta;
            dX1 -= dDelta;
        }
        double dDeltaX1 = dX - dX1;
        double dDeltaX2 = dX2 - dX;
        if (iYLabelLocation == 1) {
            dX1 = dX - dAppliedYAxisPlotSpacing;
        }
        double dYAxisThickness = dX2 - dX1;
        scX.computeAxisStartEndShifts(this.ids, laXAxisLabels, 0, iXLabelLocation, aax);
        boolean startEndChanged = false;
        if (scX.getDirection() == -1) {
            if (dYAxisThickness > scX.getStartShift()) {
                dStart = dX1;
                startEndChanged = true;
            } else {
                dStart = scX.getStart();
            }
            dEnd = scX.getEnd();
        } else {
            if (dYAxisThickness > scX.getEndShift()) {
                dEnd = dX1;
                startEndChanged = true;
            } else {
                dEnd = scX.getEnd();
            }
            dStart = scX.getStart();
        }
        scX.resetShifts();
        scX.setEndPoints(dStart, dEnd);
        if (scX.getDirection() == -1) {
            scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax);
        } else {
            scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax);
        }
        if (!scX.isStepFixed()) {
            Object[] oaMinMax = scX.getMinMax();
            while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                if (!scX.zoomOut()) break;
                scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                int tickCount = scX.getDirection() == -1 ? scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax) : scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax);
                if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
            }
        }
        if (scX.getDirection() == -1) {
            if (dYAxisThickness < scX.getStartShift()) {
                dX = scX.getStart() - (dX1 - dX);
            }
        } else if (dYAxisThickness < scX.getEndShift()) {
            dX = scX.getEnd() - (dX1 - dX);
        }
        dX2 = (dX += this.insCA.getRight()) + dDeltaX2;
        dX1 = dX - dDeltaX1;
        this.updateAxisTitleLocationNLabelSize(axPV, iYTitleLocation, dYAxisTitleThickness, dWTotal, dX, dX1, dX2);
        return dX;
    }

    private double adjustHorizontalWithOrigin(double dBlockX, AllAxes aax, OneAxis axPV, AutoScale scX, int iXLabelLocation, int iYLabelLocation, int iYTitleLocation, Label laXAxisLabels, boolean bTicksLeft, boolean bTicksRight, double dAppliedYAxisPlotSpacing, double dYAxisLabelsThickness, double[] dDecorationThickness, double dYAxisTitleThickness, double dX, double dWTotal) throws ChartException {
        double dStart;
        double dEnd;
        if (scX.getDirection() == -1) {
            dX = PlotWithAxes.getLocation(scX, IntersectionValue.MAX_VALUE);
        }
        double dX1 = dX -= dAppliedYAxisPlotSpacing;
        double dX2 = dX;
        double dTickSize = this.getTickSize();
        if (bTicksLeft && dTickSize <= dWTotal) {
            dX1 -= this.getTickSize();
            dWTotal -= dTickSize;
        } else {
            dTickSize = 0.0;
        }
        double dW1 = 0.0;
        double dW2 = 0.0;
        if (iYLabelLocation == 1) {
            dW1 = Math.max(dYAxisLabelsThickness, dDecorationThickness[0]);
            dW2 = Math.max(bTicksRight ? this.getTickSize() : 0.0, dAppliedYAxisPlotSpacing);
        } else if (iYLabelLocation == 2) {
            dW1 = dDecorationThickness[0];
            dW2 = Math.max((bTicksRight ? this.getTickSize() : 0.0) + dYAxisLabelsThickness, dAppliedYAxisPlotSpacing);
        }
        if (dW1 + dW2 <= dWTotal) {
            dX1 -= dW1;
            dX2 += dW2;
        } else {
            axPV.setShowLabels(false);
        }
        if (iYTitleLocation == 1) {
            dX1 -= dYAxisTitleThickness;
        } else if (iYTitleLocation == 2) {
            dX2 += dYAxisTitleThickness;
        }
        if (dX1 < dBlockX) {
            double dDelta = dBlockX - dX1;
            dX1 = dBlockX;
            dX += dDelta;
            dX2 += dDelta;
        }
        double dDeltaX1 = dX - dX1;
        double dDeltaX2 = dX2 - dX;
        if (iYLabelLocation == 2) {
            dX2 = dX + dAppliedYAxisPlotSpacing;
        }
        double dYAxisThickness = dX2 - dX1;
        scX.computeAxisStartEndShifts(this.ids, laXAxisLabels, 0, iXLabelLocation, aax);
        boolean startEndChanged = false;
        if (scX.getDirection() == -1) {
            if (dYAxisThickness > scX.getEndShift()) {
                dEnd = dX2;
                startEndChanged = true;
            } else {
                dEnd = scX.getEnd();
            }
            dStart = scX.getStart();
        } else {
            if (dYAxisThickness > scX.getStartShift()) {
                dStart = dX2;
                startEndChanged = true;
            } else {
                dStart = scX.getStart();
            }
            dEnd = scX.getEnd();
        }
        scX.resetShifts();
        scX.setEndPoints(dStart, dEnd);
        if (scX.getDirection() == -1) {
            scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax);
        } else {
            scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax);
        }
        if (!scX.isStepFixed()) {
            Object[] oaMinMax = scX.getMinMax();
            while (!scX.checkFit(this.ids, laXAxisLabels, iXLabelLocation)) {
                if (!scX.zoomOut()) break;
                scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                int tickCount = scX.getDirection() == -1 ? scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, true, !startEndChanged, aax) : scX.computeTicks(this.ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, !startEndChanged, true, aax);
                if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
            }
        }
        if (scX.getDirection() == -1) {
            if (dYAxisThickness < scX.getEndShift()) {
                dX = scX.getEnd() - (dX2 - dX);
            }
        } else if (dYAxisThickness < scX.getStartShift()) {
            dX = scX.getStart() - (dX2 - dX);
        }
        dX2 = (dX -= this.insCA.getLeft()) + dDeltaX2;
        dX1 = dX - dDeltaX1;
        this.updateAxisTitleLocationNLabelSize(axPV, iYTitleLocation, dYAxisTitleThickness, dWTotal, dX, dX1, dX2);
        return dX;
    }

    protected final double adjustVerticalDueToHorizontal(double dBlockY, double dBlockHeight, AllAxes aax, OneAxis orthogonalAxis) throws ChartException, IllegalArgumentException {
        boolean bForwardScale;
        double dY;
        double dFixedLabelThickness;
        OneAxis axPH = aax.areAxesSwapped() ? orthogonalAxis : aax.getPrimaryBase();
        OneAxis axPV = aax.areAxesSwapped() ? aax.getPrimaryBase() : orthogonalAxis;
        AutoScale scX = axPH.getScale();
        AutoScale scY = axPV.getScale();
        int iXLabelLocation = axPH.getLabelPosition();
        int iYLabelLocation = axPV.getLabelPosition();
        int iXTitleLocation = axPH.getTitlePosition();
        Label laXAxisTitle = axPH.getTitle();
        Label laYAxisLabels = axPV.getLabel();
        int iXTickStyle = axPH.getCombinedTickStyle();
        IntersectionValue iv = axPH.getIntersectionValue();
        double dXAxisLabelsThickness = scX.computeAxisLabelThickness(this.ids, axPH.getLabel(), 0);
        double[] dDecorationThickness = new double[]{0.0, 0.0};
        Series[] sea = this.getModel().getSeries(2);
        Map<Series, LegendItemRenderingHints> seriesRenderingHints = this.rtc.getSeriesRenderers();
        int i = 0;
        while (i < sea.length) {
            IAxesDecorator iad;
            LegendItemRenderingHints lirh = seriesRenderingHints.get(sea[i]);
            if (lirh != null && lirh.getRenderer() instanceof AxesRenderer && (iad = ((AxesRenderer)lirh.getRenderer()).getAxesDecorator(axPH)) != null) {
                double[] thickness = iad.computeDecorationThickness(this.ids, axPH);
                if (thickness[0] > dDecorationThickness[0]) {
                    dDecorationThickness[0] = thickness[0];
                }
                if (thickness[1] > dDecorationThickness[1]) {
                    dDecorationThickness[1] = thickness[1];
                }
            }
            ++i;
        }
        double dXAxisTitleThickness = 0.0;
        if (laXAxisTitle.isVisible()) {
            String sPreviousValue = laXAxisTitle.getCaption().getValue();
            laXAxisTitle.getCaption().setValue(this.rtc.externalizedMessage(sPreviousValue));
            double maxWidth = Math.abs(scX.getEnd() - scX.getStart());
            double maxHeight = 0.3 * this.boPlot.getHeight();
            LabelLimiter lblLimit = new LabelLimiter(maxWidth, maxHeight, 0.0);
            lblLimit.computeWrapping(this.ids, laXAxisTitle);
            lblLimit = lblLimit.limitLabelSize(this.cComp, this.ids, laXAxisTitle, EnumSet.of(LabelLimiter.Option.FIX_WIDTH));
            this.putLabelLimiter(axPH.getModelAxis().getTitle(), lblLimit);
            dXAxisTitleThickness = lblLimit.getMaxHeight();
            laXAxisTitle.getCaption().setValue(sPreviousValue);
        }
        double dHTotal = Math.abs(scY.getStart() - scY.getEnd());
        if (axPH.getModelAxis().isSetLabelSpan() && (dFixedLabelThickness = axPH.getModelAxis().getLabelSpan() * this.dPointToPixel) < dHTotal - 2.0 * this.getTickSize()) {
            if (dXAxisTitleThickness + dXAxisLabelsThickness > dFixedLabelThickness) {
                axPH.setShowLabels(false);
            }
            if (dXAxisTitleThickness > dFixedLabelThickness) {
                laXAxisTitle.setVisible(false);
                dXAxisLabelsThickness = 0.0;
            }
            dXAxisLabelsThickness = dFixedLabelThickness;
        }
        double dY1 = dY = PlotWithAxes.getLocation(scY, iv);
        double dY2 = dY;
        boolean bTicksAbove = (iXTickStyle & 1) == 1;
        boolean bTicksBelow = (iXTickStyle & 2) == 2;
        double dAppliedXAxisPlotSpacing = iv.iType == 1 || iv.iType == 2 ? this.dXAxisPlotSpacing : 0.0;
        boolean bl = bForwardScale = scY.getDirection() == 1;
        dY = bForwardScale && iv.iType == 2 || !bForwardScale && iv.iType == 1 ? this.adjustVerticalWithMinOrigin(dBlockY, aax, axPH, scY, iXLabelLocation, iYLabelLocation, iXTitleLocation, laYAxisLabels, dXAxisLabelsThickness, dDecorationThickness, dXAxisTitleThickness, dHTotal, dY, bTicksAbove, bTicksBelow, dAppliedXAxisPlotSpacing, bForwardScale) : (bForwardScale && iv.iType == 1 || !bForwardScale && iv.iType == 2 ? this.adjustVerticalWithMaxOrigin(dBlockY, dBlockHeight, aax, axPH, scY, iXLabelLocation, iYLabelLocation, iXTitleLocation, laYAxisLabels, dXAxisLabelsThickness, dDecorationThickness, dXAxisTitleThickness, dHTotal, dY, bTicksAbove, bTicksBelow, dAppliedXAxisPlotSpacing, bForwardScale) : this.adjustVerticalWithValueOrigin(dBlockY, dBlockHeight, aax, axPH, scY, iXLabelLocation, iYLabelLocation, iXTitleLocation, laYAxisLabels, iv, dXAxisLabelsThickness, dDecorationThickness, dXAxisTitleThickness, dHTotal, dY, dY1, dY2, bTicksAbove, bTicksBelow, bForwardScale));
        return dY;
    }

    private double adjustVerticalWithValueOrigin(double dBlockY, double dBlockHeight, AllAxes aax, OneAxis axPH, AutoScale scY, int iXLabelLocation, int iYLabelLocation, int iXTitleLocation, Label laYAxisLabels, IntersectionValue iv, double dXAxisLabelsThickness, double[] dDecorationThickness, double dXAxisTitleThickness, double dHTotal, double dY, double dY1, double dY2, boolean bTicksAbove, boolean bTicksBelow, boolean bForwardScale) throws ChartException {
        double dDeltaY1 = 0.0;
        double dDeltaY2 = 0.0;
        if (iXLabelLocation == 4) {
            double dH2;
            double dH1 = (bTicksAbove ? this.getTickSize() : 0.0) + Math.max(dXAxisLabelsThickness, dDecorationThickness[0]);
            double d = dH2 = bTicksBelow ? this.getTickSize() : 0.0;
            if (dH1 + dH2 <= dHTotal) {
                dY1 -= dH1;
                dY2 += dH2;
            } else {
                axPH.setShowLabels(false);
            }
            if (iXTitleLocation == 4) {
                dY1 -= dXAxisTitleThickness;
            } else if (iXTitleLocation == 8) {
                dY2 += dXAxisTitleThickness;
            }
            dDeltaY1 = dY - dY1;
            dDeltaY2 = dY2 - dY;
            if (dY1 < dBlockY) {
                Object[] oaMinMax = scY.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dStart;
                    double dEnd;
                    double dAMin_RI;
                    double dAMin_AMax;
                    scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                    scY.resetShifts();
                    double[] da = scY.getEndPoints();
                    double dT_RI = dBlockY - dY1;
                    if (bForwardScale) {
                        dAMin_AMax = da[1] - da[0];
                        dAMin_RI = da[1] - dY;
                        dEnd = da[1];
                        dStart = dT_RI / dAMin_RI * dAMin_AMax + da[0];
                        if (dStart < dBlockY) {
                            dStart = dBlockY;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[0] - da[1];
                        dAMin_RI = da[0] - dY;
                        dStart = da[0];
                        dEnd = dT_RI / dAMin_RI * dAMin_AMax + da[1];
                        if (dEnd < dBlockY) {
                            dEnd = dBlockY;
                            bForceBreak = true;
                        }
                    }
                    scY.setEndPoints(dStart, dEnd);
                    scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                    if (!scY.isStepFixed()) {
                        while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                            if (!scY.zoomOut()) {
                                bForceBreak = true;
                                break;
                            }
                            scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                            if ((scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) && !this.isSharedScale()) continue;
                            bForceBreak = true;
                            break;
                        }
                    }
                    dY = PlotWithAxes.getLocation(scY, iv);
                    dY1 = dY - dDeltaY1;
                    dY2 = dY + dDeltaY2;
                } while (Math.abs(dY1 - dBlockY) > 1.0 && !bForceBreak);
            } else if (dY2 > dBlockY + dBlockHeight) {
                Object[] oaMinMax = scY.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dStart;
                    double dEnd;
                    double dX2_AMax;
                    double dAMin_AMax;
                    scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                    scY.resetShifts();
                    double[] da = scY.getEndPoints();
                    double dX2_X1 = dY2 - (dBlockY + dBlockHeight);
                    if (bForwardScale) {
                        dAMin_AMax = da[1] - da[0];
                        dX2_AMax = dY - da[0];
                        dEnd = da[1] - dX2_X1 / dX2_AMax * dAMin_AMax;
                        dStart = da[0];
                        if (dEnd > dBlockY + dBlockHeight) {
                            dEnd = dBlockY + dBlockHeight;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[0] - da[1];
                        dX2_AMax = dY - da[1];
                        dStart = da[0] - dX2_X1 / dX2_AMax * dAMin_AMax;
                        dEnd = da[1];
                        if (dStart > dBlockY + dBlockHeight) {
                            dStart = dBlockY + dBlockHeight;
                            bForceBreak = true;
                        }
                    }
                    if (ChartUtil.mathEqual(Math.abs(dEnd - dStart), 0.0)) {
                        bForceBreak = true;
                    }
                    scY.setEndPoints(dStart, dEnd);
                    scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                    if (!scY.isStepFixed()) {
                        while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                            if (!scY.zoomOut()) {
                                bForceBreak = true;
                                break;
                            }
                            scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                            if ((scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) && !this.isSharedScale()) continue;
                            bForceBreak = true;
                            break;
                        }
                    }
                    dY = PlotWithAxes.getLocation(scY, iv);
                    dY2 = dY + dDeltaY2;
                    dY1 = dY - dDeltaY1;
                } while (Math.abs(dY2 - (dBlockY + dBlockHeight)) > 1.0 && !bForceBreak);
            }
        } else if (iXLabelLocation == 8) {
            double dH2;
            double dH1 = bTicksAbove ? this.getTickSize() : 0.0;
            if (dH1 + (dH2 = (bTicksBelow ? this.getTickSize() : 0.0) + Math.max(dXAxisLabelsThickness, dDecorationThickness[1])) <= dHTotal) {
                dY1 -= dH1;
                dY2 += dH2;
            }
            if (iXTitleLocation == 4) {
                dY1 -= dXAxisTitleThickness;
            } else if (iXTitleLocation == 8) {
                dY2 += dXAxisTitleThickness;
            }
            dDeltaY1 = dY - dY1;
            dDeltaY2 = dY2 - dY;
            if (dY2 > dBlockY + dBlockHeight) {
                Object[] oaMinMax = scY.getMinMax();
                boolean bForceBreak = false;
                do {
                    double dStart;
                    double dEnd;
                    double dX2_AMax;
                    double dAMin_AMax;
                    scY.setEndPoints(scY.getStart() + scY.getStartShift(), scY.getEnd() - scY.getEndShift());
                    scY.resetShifts();
                    double[] da = scY.getEndPoints();
                    double dX2_X1 = dY2 - (dBlockY + dBlockHeight);
                    if (bForwardScale) {
                        dAMin_AMax = da[1] - da[0];
                        dX2_AMax = dY - da[0];
                        dEnd = da[1] - dX2_X1 / dX2_AMax * dAMin_AMax;
                        dStart = da[0];
                        if (dEnd > dBlockY + dBlockHeight) {
                            dEnd = dBlockY + dBlockHeight;
                            bForceBreak = true;
                        }
                    } else {
                        dAMin_AMax = da[0] - da[1];
                        dX2_AMax = dY - da[1];
                        dStart = da[0] - dX2_X1 / dX2_AMax * dAMin_AMax;
                        dEnd = da[1];
                        if (dStart > dBlockY + dBlockHeight) {
                            dStart = dBlockY + dBlockHeight;
                            bForceBreak = true;
                        }
                    }
                    if (ChartUtil.mathEqual(Math.abs(dEnd - dStart), 0.0)) {
                        bForceBreak = true;
                    }
                    scY.setEndPoints(dStart, dEnd);
                    scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                    if (!scY.isStepFixed()) {
                        while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                            if (!scY.zoomOut()) {
                                bForceBreak = true;
                                break;
                            }
                            scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                            int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                            if ((scY.getUnit() == null || PlotWithAxes.asInteger(scY.getUnit()) != 1 || tickCount > 3) && !this.isSharedScale()) continue;
                            bForceBreak = true;
                            break;
                        }
                    }
                    dY = PlotWithAxes.getLocation(scY, iv);
                    dY2 = dY + dDeltaY2;
                    dY1 = dY - dDeltaY1;
                } while (Math.abs(dY2 - (dBlockY + dBlockHeight)) > 1.0 && !bForceBreak);
            }
        }
        axPH.setTitleCoordinate(iXTitleLocation == 4 ? dY1 - 1.0 : dY2 + 1.0 - dXAxisTitleThickness);
        return dY;
    }

    private double adjustVerticalWithMaxOrigin(double dBlockY, double dBlockHeight, AllAxes aax, OneAxis axPH, AutoScale scY, int iXLabelLocation, int iYLabelLocation, int iXTitleLocation, Label laYAxisLabels, double dXAxisLabelsThickness, double[] dDecorationThickness, double dXAxisTitleThickness, double dHTotal, double dY, boolean bTicksAbove, boolean bTicksBelow, double dAppliedXAxisPlotSpacing, boolean bForwardScale) throws ChartException {
        double dXLabelHeight;
        dHTotal -= dAppliedXAxisPlotSpacing;
        double dY1 = dY += dAppliedXAxisPlotSpacing;
        double dY2 = dY;
        double dTickSize = this.getTickSize();
        if (bTicksBelow && dTickSize < dHTotal) {
            dY2 += dTickSize;
            dHTotal -= dTickSize;
        } else {
            dTickSize = 0.0;
        }
        if (iXLabelLocation == 4) {
            dXLabelHeight = Math.max((bTicksAbove ? dTickSize : 0.0) + dXAxisLabelsThickness, dAppliedXAxisPlotSpacing);
            if (dXLabelHeight + dDecorationThickness[1] < dHTotal) {
                dY1 -= dXLabelHeight;
                dY2 += dDecorationThickness[1];
            } else {
                dXLabelHeight = 0.0;
                axPH.setShowLabels(false);
            }
        } else if (iXLabelLocation == 8) {
            double dHt1;
            dXLabelHeight = Math.max(dXAxisLabelsThickness, dDecorationThickness[1]);
            if (dXLabelHeight + (dHt1 = Math.max(bTicksAbove ? dTickSize : 0.0, dAppliedXAxisPlotSpacing)) <= dHTotal) {
                dY2 += dXLabelHeight;
                dY1 -= dHt1;
            } else {
                dXLabelHeight = 0.0;
                axPH.setShowLabels(false);
            }
        }
        if (iXTitleLocation == 4) {
            dY1 -= dXAxisTitleThickness;
        } else if (iXTitleLocation == 8) {
            dY2 += dXAxisTitleThickness;
        }
        if (dY2 > dBlockY + dBlockHeight) {
            double dDelta = dY2 - (dBlockY + dBlockHeight);
            dY2 = dBlockY + dBlockHeight;
            dY -= dDelta;
            dY1 -= dDelta;
        }
        double dDeltaY1 = dY - dY1;
        double dDeltaY2 = dY2 - dY;
        double dXAxisThickness = 0.0;
        if (iXLabelLocation == 4) {
            dY1 = dY - dAppliedXAxisPlotSpacing;
            dXAxisThickness = dY2 - dY1;
        } else if (iXLabelLocation == 8) {
            dXAxisThickness = dY2 - dY1;
        }
        if (bForwardScale && dXAxisThickness > scY.getEndShift() || !bForwardScale && dXAxisThickness > scY.getStartShift()) {
            double dStart = dY1 + scY.getStartShift();
            double dEnd = scY.getEnd();
            if (bForwardScale) {
                dStart = scY.getStart();
                dEnd = dY1 + scY.getEndShift();
            }
            scY.resetShifts();
            if (dStart < dEnd + 1.0) {
                dStart = dEnd + 1.0;
            }
            scY.setEndPoints(dStart, dEnd);
            scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
            if (!scY.isStepFixed()) {
                Object[] oaMinMax = scY.getMinMax();
                while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                    if (!scY.zoomOut()) break;
                    double dOldStep = ((Number)scY.getStep()).doubleValue();
                    scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                    double dNewStep = ((Number)scY.getStep()).doubleValue();
                    if (dNewStep < dOldStep || scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
                }
            }
        }
        dY1 = (dY += this.insCA.getBottom()) - dDeltaY1;
        dY2 = dY + dDeltaY2;
        axPH.setTitleCoordinate(iXTitleLocation == 4 ? dY1 - 1.0 : dY2 + 1.0 - dXAxisTitleThickness);
        return dY;
    }

    private double adjustVerticalWithMinOrigin(double dBlockY, AllAxes aax, OneAxis axPH, AutoScale scY, int iXLabelLocation, int iYLabelLocation, int iXTitleLocation, Label laYAxisLabels, double dXAxisLabelsThickness, double[] dDecorationThickness, double dXAxisTitleThickness, double dHTotal, double dY, boolean bTicksAbove, boolean bTicksBelow, double dAppliedXAxisPlotSpacing, boolean bForwardScale) throws ChartException {
        dHTotal -= dAppliedXAxisPlotSpacing;
        double dY1 = dY -= dAppliedXAxisPlotSpacing;
        double dY2 = dY;
        double dTickSize = this.getTickSize();
        if (bTicksAbove && dTickSize <= dHTotal) {
            dY1 -= dTickSize;
            dHTotal -= dTickSize;
        } else {
            dTickSize = 0.0;
        }
        double dH1 = 0.0;
        double dH2 = 0.0;
        if (iXLabelLocation == 4) {
            dH1 = Math.max(dXAxisLabelsThickness, dDecorationThickness[0]);
            dH2 = Math.max(bTicksBelow ? this.getTickSize() : 0.0, dAppliedXAxisPlotSpacing);
        } else if (iXLabelLocation == 8) {
            dH1 = dDecorationThickness[0];
            dH2 += Math.max((bTicksBelow ? this.getTickSize() : 0.0) + dXAxisLabelsThickness, dAppliedXAxisPlotSpacing);
        }
        if (dH1 + dH2 <= dHTotal) {
            dY1 -= dH1;
            dY2 += dH2;
        } else {
            axPH.setShowLabels(false);
        }
        if (iXTitleLocation == 4) {
            dY1 -= dXAxisTitleThickness;
        } else if (iXTitleLocation == 8) {
            dY2 += dXAxisTitleThickness;
        }
        if (dY1 < dBlockY) {
            double dDelta = dBlockY - dY1;
            dY1 = dBlockY;
            dY += dDelta;
            dY2 += dDelta;
        }
        double dDeltaY1 = dY - dY1;
        double dDeltaY2 = dY2 - dY;
        double dXAxisThickness = 0.0;
        if (iXLabelLocation == 4) {
            dXAxisThickness = dY2 - dY1;
        } else if (iXLabelLocation == 8) {
            dY2 = dY + dAppliedXAxisPlotSpacing;
            dXAxisThickness = dY2 - dY1;
        }
        if (bForwardScale && dXAxisThickness > scY.getStartShift() || !bForwardScale && dXAxisThickness > scY.getEndShift()) {
            double dStart = scY.getStart();
            double dEnd = dY2 - scY.getEndShift();
            if (bForwardScale) {
                dStart = dY2 - scY.getStartShift();
                dEnd = scY.getEnd();
            }
            scY.resetShifts();
            scY.setEndPoints(dStart, dEnd);
            scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
            if (!scY.isStepFixed()) {
                Object[] oaMinMax = scY.getMinMax();
                while (!scY.checkFit(this.ids, laYAxisLabels, iYLabelLocation)) {
                    if (!scY.zoomOut()) break;
                    scY.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scY.computeTicks(this.ids, laYAxisLabels, iYLabelLocation, 1, dStart, dEnd, true, aax);
                    if (scY.getUnit() != null && PlotWithAxes.asInteger(scY.getUnit()) == 1 && tickCount <= 3 || this.isSharedScale()) break;
                }
            }
        }
        dY1 = (dY -= this.insCA.getTop()) - dDeltaY1;
        dY2 = dY + dDeltaY2;
        axPH.setTitleCoordinate(iXTitleLocation == 4 ? dY1 - 1.0 : dY2 + 1.0 - dXAxisTitleThickness);
        return dY;
    }

    public double getTickSize() {
        return 0.052083333333333336 * (double)this.ids.getDpiResolution();
    }

    boolean isSharedScale() {
        return this.rtc.getSharedScale() != null && this.rtc.getSharedScale().isShared();
    }

    protected abstract Object getMinMax(Axis var1, int var2) throws ChartException, IllegalArgumentException;

    protected void initAlignZeroHelper() {
        this.azHelper = null;
        this.azHelper = AlignZeroHelper.getInstance(this);
    }

    public ChartWithAxes getModel() {
        return (ChartWithAxes)this.cm;
    }

    static final Double asDouble(Object o) {
        return Methods.asDouble(o);
    }

    static final CDateTime asDateTime(Object o) {
        return Methods.asDateTime(o);
    }

    static final int asInteger(Object o) {
        return ((Number)o).intValue();
    }

    static final int getLabelPosition(Position lp) {
        return Methods.getLabelPosition(lp);
    }

    static final double getLocation(AutoScale sc, double dValue) throws IllegalArgumentException {
        return Methods.getLocation(sc, dValue);
    }

    static final double getLocation(AutoScale sc, Object oValue) throws ChartException, IllegalArgumentException {
        return Methods.getLocation(sc, oValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AlignZeroHelper {
        private final Map<Axis, double[]> minMaxLookup;

        private AlignZeroHelper(Map<Axis, double[]> minMaxLookup) {
            this.minMaxLookup = minMaxLookup;
        }

        public static AlignZeroHelper getInstance(PlotWithAxes pwa) {
            HashMap<Axis, double[]> minMaxLookup = new HashMap<Axis, double[]>(2);
            Axis[] axList = pwa.getModel().getOrthogonalAxes(pwa.getModel().getPrimaryBaseAxes()[0], true);
            boolean bAnyPositive = false;
            boolean bAnyNegative = false;
            Axis[] axisArray = axList;
            int n = axList.length;
            int n2 = 0;
            while (n2 < n) {
                Axis ax = axisArray[n2];
                if (ax.getType().getValue() == 0 && ax.isAligned()) {
                    try {
                        double[] minmax = (double[])pwa.getMinMax(ax, 3);
                        if (minmax[0] > 0.0) {
                            minmax[0] = 0.0;
                        }
                        if (minmax[1] < 0.0) {
                            minmax[1] = 0.0;
                        }
                        minMaxLookup.put(ax, minmax);
                        bAnyPositive |= minmax[1] > 0.0;
                        bAnyNegative |= minmax[0] < 0.0;
                    }
                    catch (Exception exception) {}
                }
                ++n2;
            }
            if (bAnyPositive && bAnyNegative && minMaxLookup.values().size() > 1) {
                for (double[] minmax : minMaxLookup.values()) {
                    AlignZeroHelper.applyRateToMinmax(minmax);
                }
                return new AlignZeroHelper(minMaxLookup);
            }
            return null;
        }

        private static void applyRateToMinmax(double[] minmax) {
            if (minmax[0] >= 0.0) {
                minmax[0] = -minmax[1];
            } else if (minmax[1] <= 0.0) {
                minmax[1] = -minmax[0];
            } else if (minmax[1] < -minmax[0]) {
                minmax[1] = -minmax[0];
            } else if (minmax[1] > -minmax[0]) {
                minmax[0] = -minmax[1];
            }
        }

        public double[] getCachedMinMax(Axis ax) {
            return this.minMaxLookup.get(ax);
        }
    }
}

