/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.outline;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.util.StringMatcher;

public class QuickOutlineNamePatternFilter
extends ViewerFilter {
    private StringMatcher fStringMatcher = null;

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fStringMatcher == null || !(viewer instanceof TreeViewer)) {
            return true;
        }
        TreeViewer treeViewer = (TreeViewer)viewer;
        String matchName = ((ILabelProvider)treeViewer.getLabelProvider()).getText(element);
        if (matchName != null && this.fStringMatcher.match(matchName)) {
            return true;
        }
        return this.hasUnfilteredChild(treeViewer, element);
    }

    private boolean hasUnfilteredChild(TreeViewer viewer, Object element) {
        Object[] children = ((ITreeContentProvider)viewer.getContentProvider()).getChildren(element);
        int i = 0;
        while (i < children.length) {
            if (this.select((Viewer)viewer, element, children[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setStringMatcher(StringMatcher stringMatcher) {
        this.fStringMatcher = stringMatcher;
    }
}

