/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dialogs;

import java.net.URI;
import java.util.HashSet;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.core.target.LoadTargetDefinitionJob;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.search.dialogs.FilteredIUSelectionDialog;
import org.eclipse.pde.internal.ui.search.dialogs.IUPackage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public class TargetRepositorySearchHandler
extends AbstractHandler
implements IHandler {
    static /* synthetic */ Class class$0;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] result;
        int status;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        IQuery query = QueryUtil.createMatchQuery((String)"properties[$0] == true || providedCapabilities.exists(p | p.namespace == 'osgi.bundle')", (Object[])new Object[]{"org.eclipse.equinox.p2.type.group"});
        FilteredIUSelectionDialog dialog = new FilteredIUSelectionDialog(window.getShell(), query);
        String pattern = event.getParameter("org.eclipse.pde.ui.searchTargetRepositories.term");
        if (pattern != null) {
            dialog.setInitialPattern(pattern);
        }
        if ((status = dialog.open()) == 0 && (result = dialog.getResult()) != null) {
            HashSet<Object> set = new HashSet<Object>();
            int i = 0;
            while (i < result.length) {
                if (result[i] instanceof IUPackage) {
                    set.add(((IUPackage)result[i]).getIU());
                } else if (result[i] instanceof IInstallableUnit) {
                    set.add(result[i]);
                }
                ++i;
            }
            IInstallableUnit[] units = set.toArray(new IInstallableUnit[set.size()]);
            try {
                TargetRepositorySearchHandler.installIntoActiveTarget(units, null);
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        }
        return null;
    }

    private static void installIntoActiveTarget(IInstallableUnit[] units, URI[] repositories) throws CoreException {
        PDECore pDECore = PDECore.getDefault();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.pde.core.target.ITargetPlatformService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITargetPlatformService service = (ITargetPlatformService)pDECore.acquireService(clazz.getName());
        ITargetHandle currentTarget = service.getWorkspaceTargetHandle();
        ITargetDefinition definition = currentTarget.getTargetDefinition();
        int flags = 6;
        IUBundleContainer container = (IUBundleContainer)service.newIULocation(units, repositories, flags);
        ITargetLocation[] oldContainers = definition.getTargetLocations();
        if (oldContainers == null) {
            definition.setTargetLocations(new ITargetLocation[]{container});
        } else {
            ITargetLocation[] newContainers = new ITargetLocation[oldContainers.length + 1];
            System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
            newContainers[newContainers.length - 1] = container;
            definition.setTargetLocations(newContainers);
            service.saveTargetDefinition(definition);
            LoadTargetDefinitionJob.load((ITargetDefinition)definition);
        }
    }
}

