/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.handlers;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.NLS;
import org.eclipse.stem.ui.handlers.Messages;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;

public class SwitchLocaleAction
extends Action
implements ActionFactory.IWorkbenchAction {
    public static final ActionFactory SWITCH_LOCALE_ACTION = new ActionFactory("switchLocale"){

        public ActionFactory.IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            SwitchLocaleAction action = new SwitchLocaleAction(window);
            action.setId(this.getId());
            return action;
        }
    };
    private static final String PROP_VM = "eclipse.vm";
    private static final String PROP_VMARGS = "eclipse.vmargs";
    private static final String PROP_COMMANDS = "eclipse.commands";
    private static final String PROP_EXIT_CODE = "eclipse.exitcode";
    private static final String PROP_EXIT_DATA = "eclipse.exitdata";
    private static final String CMD_NL = "-nl";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String NEW_LINE = "\n";
    private IWorkbenchWindow window;

    private IContributionItem[] getContributionItems() {
        ArrayList<ActionContributionItem> list = new ArrayList<ActionContributionItem>();
        for (String locale : NLS.getAvailableLocales()) {
            list.add(new ActionContributionItem((IAction)new ChangeLanguageAction(locale)));
        }
        return list.toArray(new IContributionItem[list.size()]);
    }

    public SwitchLocaleAction(IWorkbenchWindow window) {
        super(Messages.SwitchLocaleAction_SwitchLangaugeMenu, 4);
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.window = window;
        this.setToolTipText(Messages.SwitchLocaleAction_SwitchLangaugeMenuTT);
        this.setActionDefinitionId("org.eclipse.stem.ui.switchLanguage");
        this.setMenuCreator(new MenuCreator());
    }

    public void run() {
    }

    private void changeLocaleAndRestart(String locale) {
        try {
            NLS.persistNewLocale(locale);
        }
        catch (Throwable t) {
            Activator.logWarning("Unable to persist new locale in system properties. Setting is transient only.", t);
        }
        String command_line = this.buildCommandLine(locale);
        if (command_line == null) {
            return;
        }
        System.setProperty(PROP_EXIT_CODE, Integer.toString(24));
        System.setProperty(PROP_EXIT_DATA, command_line);
        this.window.getWorkbench().restart();
    }

    private String buildCommandLine(String newLocale) {
        String property = System.getProperty(PROP_VM);
        if (property == null) {
            MessageDialog.openError((Shell)this.window.getShell(), (String)Messages.SwitchLocaleAction_CommandLineError, (String)org.eclipse.osgi.util.NLS.bind((String)Messages.SwitchLocaleAction_CommandLineErrorMessage, (Object)PROP_VM));
            return null;
        }
        StringBuffer result = new StringBuffer(512);
        result.append(property);
        result.append(NEW_LINE);
        String vmargs = System.getProperty(PROP_VMARGS);
        StringBuffer vmargsBuf = new StringBuffer();
        if (!vmargs.contains("stem.system.nl")) {
            vmargsBuf.append("-D");
            vmargsBuf.append("stem.system.nl");
            vmargsBuf.append("=");
            vmargsBuf.append(NLS.getSystemLocale());
            vmargsBuf.append(NEW_LINE);
        }
        vmargsBuf.append(vmargs);
        result.append(vmargsBuf.toString());
        property = System.getProperty(PROP_COMMANDS);
        if (property == null) {
            result.append(CMD_NL);
            result.append(NEW_LINE);
            result.append(newLocale);
            result.append(NEW_LINE);
        } else {
            int cmd_data_pos = property.lastIndexOf(CMD_NL);
            if (cmd_data_pos != -1) {
                result.append(property.substring(0, cmd_data_pos += CMD_NL.length() + 1));
                result.append(newLocale);
                result.append(property.substring(property.indexOf(10, cmd_data_pos)));
            } else {
                result.append(CMD_NL);
                result.append(NEW_LINE);
                result.append(newLocale);
                result.append(NEW_LINE);
                result.append(property);
            }
        }
        result.append(CMD_VMARGS);
        result.append(NEW_LINE);
        result.append(vmargsBuf.toString());
        return result.toString();
    }

    public void dispose() {
        this.window = null;
    }

    class ChangeLanguageAction
    extends Action {
        String locale;
        boolean selected = false;

        ChangeLanguageAction(String locale) {
            this.locale = locale;
            String displayName = NLS.getLocaleDisplayName(locale);
            if (NLS.isDefaultLocale(locale)) {
                displayName = String.valueOf(displayName) + Messages.SwitchLocaleAction_DefaultSetting;
            }
            this.setText(displayName);
            this.setToolTipText(displayName);
            if (NLS.isCurrentLocale(locale)) {
                this.selected = true;
                this.setChecked(true);
            }
        }

        public void run() {
            if (this.selected) {
                return;
            }
            boolean b = MessageDialog.openConfirm((Shell)SwitchLocaleAction.this.window.getShell(), (String)Messages.SwitchLocaleAction_ConfirmRestart, (String)Messages.SwitchLocaleAction_ConfirmRestartMessage);
            if (b) {
                SwitchLocaleAction.this.changeLocaleAndRestart(this.locale);
            }
        }
    }

    class MenuCreator
    implements IMenuCreator {
        private MenuManager dropDownMenuMgr;

        MenuCreator() {
        }

        private void createDropDownMenuMgr() {
            if (this.dropDownMenuMgr == null) {
                this.dropDownMenuMgr = new MenuManager();
                this.dropDownMenuMgr.setRemoveAllWhenShown(true);
            }
        }

        public Menu getMenu(Control parent) {
            this.createDropDownMenuMgr();
            this.dropDownMenuMgr.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    IContributionItem[] items = SwitchLocaleAction.this.getContributionItems();
                    int i = 0;
                    while (i < items.length) {
                        manager.add(items[i]);
                        ++i;
                    }
                }
            });
            return this.dropDownMenuMgr.createContextMenu(parent);
        }

        public Menu getMenu(Menu parent) {
            this.createDropDownMenuMgr();
            final Menu menu = new Menu(parent);
            menu.addListener(22, new Listener(){

                public void handleEvent(Event event) {
                    if (menu.isDisposed()) {
                        return;
                    }
                    MenuItem[] items = menu.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    IContributionItem[] contributions = SwitchLocaleAction.this.getContributionItems();
                    int i2 = 0;
                    while (i2 < contributions.length) {
                        contributions[i2].fill(menu, -1);
                        ++i2;
                    }
                }
            });
            return menu;
        }

        public void dispose() {
            if (this.dropDownMenuMgr != null) {
                this.dropDownMenuMgr.dispose();
                this.dropDownMenuMgr = null;
            }
        }
    }
}

