/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.migration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.stem.core.CorePlugin;
import org.eclipse.stem.ui.migration.MigrationTasksScheduler;
import org.eclipse.stem.ui.versioning.VersioningUtil;
import org.osgi.framework.Version;

public class MigrationUtil {
    public static boolean checkMigrationNeeded(IProject project) {
        if (!MigrationUtil.isValidProject(project)) {
            return false;
        }
        Version projectVersion = VersioningUtil.getSTEMProjectVersion(project);
        Version stemVersion = VersioningUtil.getSTEMVersion();
        return MigrationTasksScheduler.getInstance().getTasks(projectVersion, stemVersion).size() > 0;
    }

    private static boolean isValidProject(IProject project) {
        if (!project.isOpen()) {
            return false;
        }
        try {
            return project.hasNature("org.eclipse.stem.stemnature");
        }
        catch (CoreException ce) {
            CorePlugin.logError((String)ce.getMessage(), (Throwable)ce);
            return false;
        }
    }
}

