/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.stem.jobs.DisplaySafeExecutor;
import org.eclipse.stem.ui.migration.MigrationTask;
import org.eclipse.stem.ui.migration.MigrationTasksScheduler;
import org.eclipse.stem.ui.migration.MigrationUtil;
import org.eclipse.stem.ui.versioning.VersioningUtil;
import org.eclipse.stem.ui.wizards.Messages;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.framework.Version;

public class MigrationWizard
extends Wizard
implements INewWizard {
    IWorkbench workbench;
    WizardPage introPage;
    ProjectsPage foundProjectsPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.setWindowTitle(Messages.getString("migration.wizard.title"));
    }

    public void addPages() {
        super.addPages();
        this.setForcePreviousAndNextButtons(false);
        this.introPage = this.createIntroPage();
        this.foundProjectsPage = this.createProjectsPage();
        this.addPage((IWizardPage)this.introPage);
        this.addPage((IWizardPage)this.foundProjectsPage);
    }

    private WizardPage createIntroPage() {
        return new IntroPage();
    }

    private ProjectsPage createProjectsPage() {
        return new ProjectsPage();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = super.getNextPage(page);
        if (nextPage instanceof ProjectsPage) {
            List<IProject> projsToMigrate = this.getWorkspaceSTEMProjectsToMigrate();
            for (IProject p : projsToMigrate) {
                ((ProjectsPage)nextPage).addProjectToMigrate(p);
            }
        }
        return nextPage;
    }

    private List<IProject> getWorkspaceSTEMProjectsToMigrate() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = ws.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (MigrationUtil.checkMigrationNeeded(project)) {
                result.add(project);
            }
            ++n2;
        }
        return result;
    }

    public boolean performFinish() {
        final List<IProject> projectsToMigrate = this.foundProjectsPage.getSelectedProjects();
        DisplaySafeExecutor.executeSync((Runnable)new Runnable(){

            @Override
            public void run() {
                Version stemVersion = VersioningUtil.getSTEMVersion();
                MigrationTasksScheduler scheduler = MigrationTasksScheduler.getInstance();
                for (IProject p : projectsToMigrate) {
                    Version projVersion = VersioningUtil.getSTEMProjectVersion(p);
                    List<MigrationTask> tasks = scheduler.getTasks(projVersion, stemVersion);
                    for (MigrationTask task : tasks) {
                        task.executeTask(p);
                    }
                }
            }
        });
        return true;
    }

    public class IntroPage
    extends WizardPage {
        protected IntroPage() {
            super(Messages.getString("migration.wizard.intropage.title"));
            this.setTitle(Messages.getString("migration.wizard.intropage.title"));
            this.setDescription(Messages.getString("migration.wizard.intropage.description"));
        }

        public void createControl(Composite parent) {
            Composite pageComposite = new Composite(parent, 0);
            GridLayout pageCompositeLayout = new GridLayout();
            pageCompositeLayout.verticalSpacing = 12;
            pageCompositeLayout.numColumns = 2;
            pageCompositeLayout.marginHeight = 0;
            pageCompositeLayout.marginWidth = 0;
            pageComposite.setLayout((Layout)pageCompositeLayout);
            GridData pageCompositeLayoutData = new GridData();
            pageCompositeLayoutData.grabExcessVerticalSpace = true;
            pageCompositeLayoutData.verticalAlignment = 4;
            pageCompositeLayoutData.horizontalAlignment = 4;
            pageCompositeLayoutData.horizontalSpan = 1;
            pageComposite.setLayoutData((Object)pageCompositeLayoutData);
            Label introLabelField = new Label(pageComposite, 0);
            introLabelField.setText(Messages.getString("migration.wizard.intropage.instructions"));
            this.setPageComplete(true);
            this.setControl((Control)pageComposite);
        }
    }

    public static class MigrationWizardCommandHandler
    extends AbstractHandler
    implements IHandler {
        public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
            IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)executionEvent);
            MigrationWizard wizard = new MigrationWizard();
            wizard.init(window.getWorkbench(), (IStructuredSelection)StructuredSelection.EMPTY);
            WizardDialog wizardDialog = new WizardDialog(window.getShell(), (IWizard)wizard);
            wizardDialog.open();
            return null;
        }
    }

    public class ProjectsPage
    extends WizardPage {
        ArrayList<Button> migrateProjectsButtons;
        ArrayList<IProject> migrateProjects;
        Composite pageComposite;

        protected ProjectsPage() {
            super(Messages.getString("migration.wizard.projectspage.title"));
            this.migrateProjectsButtons = new ArrayList();
            this.migrateProjects = new ArrayList();
            this.setTitle(Messages.getString("migration.wizard.projectspage.title"));
            this.setDescription(Messages.getString("migration.wizard.projectspage.description"));
        }

        public void createControl(Composite parent) {
            ScrolledComposite scrollComposite = new ScrolledComposite(parent, 768);
            this.pageComposite = new Composite((Composite)scrollComposite, 0);
            GridLayout pageCompositeLayout = new GridLayout();
            pageCompositeLayout.verticalSpacing = 12;
            pageCompositeLayout.numColumns = 1;
            pageCompositeLayout.marginHeight = 0;
            pageCompositeLayout.marginWidth = 0;
            this.pageComposite.setLayout((Layout)pageCompositeLayout);
            scrollComposite.setContent((Control)this.pageComposite);
            scrollComposite.setExpandHorizontal(true);
            scrollComposite.setExpandVertical(true);
            GridData pageCompositeLayoutData = new GridData();
            pageCompositeLayoutData.grabExcessVerticalSpace = true;
            pageCompositeLayoutData.verticalAlignment = 4;
            pageCompositeLayoutData.horizontalAlignment = 4;
            pageCompositeLayoutData.horizontalSpan = 1;
            this.pageComposite.setLayoutData((Object)pageCompositeLayoutData);
            pageCompositeLayout.verticalSpacing = 12;
            pageCompositeLayout.numColumns = 1;
            pageCompositeLayout.marginHeight = 0;
            pageCompositeLayout.marginWidth = 0;
            this.pageComposite.setLayout((Layout)pageCompositeLayout);
            pageCompositeLayoutData.grabExcessVerticalSpace = true;
            pageCompositeLayoutData.verticalAlignment = 4;
            pageCompositeLayoutData.horizontalAlignment = 4;
            pageCompositeLayoutData.horizontalSpan = 1;
            this.pageComposite.setLayoutData((Object)pageCompositeLayoutData);
            this.setPageComplete(this.isCompleted());
            this.setControl((Control)this.pageComposite);
        }

        public boolean isCompleted() {
            for (Button b : this.migrateProjectsButtons) {
                if (!b.getSelection()) continue;
                return true;
            }
            return false;
        }

        public void addProjectToMigrate(IProject project) {
            if (this.migrateProjects.contains(project)) {
                return;
            }
            this.migrateProjects.add(project);
            Button newButton = new Button(this.pageComposite, 32);
            newButton.setText(project.getName());
            newButton.setSelection(true);
            GridData buttonLayoutData = new GridData();
            buttonLayoutData.horizontalSpan = 1;
            newButton.setLayoutData((Object)buttonLayoutData);
            this.migrateProjectsButtons.add(newButton);
            newButton.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ProjectsPage.this.setPageComplete(ProjectsPage.this.isCompleted());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ProjectsPage.this.setPageComplete(ProjectsPage.this.isCompleted());
                }
            });
            this.setPageComplete(this.isCompleted());
        }

        public List<IProject> getSelectedProjects() {
            ArrayList<IProject> result = new ArrayList<IProject>();
            int i = 0;
            while (i < this.migrateProjectsButtons.size()) {
                if (this.migrateProjectsButtons.get(i).getSelection()) {
                    result.add(this.migrateProjects.get(i));
                }
                ++i;
            }
            return result;
        }
    }
}

