/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.definitions.labels.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.stem.core.STEMURI;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.graph.impl.StaticNodeLabelImpl;
import org.eclipse.stem.definitions.labels.LabelsFactory;
import org.eclipse.stem.definitions.labels.LabelsPackage;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.PopulationLabelValue;

public class PopulationLabelImpl
extends StaticNodeLabelImpl
implements PopulationLabel {
    protected static final String POPULATION_IDENTIFIER_EDEFAULT = null;
    protected String populationIdentifier = POPULATION_IDENTIFIER_EDEFAULT;
    protected static final double POPULATED_AREA_EDEFAULT = 0.0;
    protected double populatedArea = 0.0;
    protected static final int VALID_YEAR_EDEFAULT = 2006;
    protected int validYear = 2006;

    protected PopulationLabelImpl() {
        this.setTypeURI(PopulationLabel.URI_TYPE_POPULATION_LABEL);
        this.setPopulationIdentifier("human");
        this.setCurrentValue(LabelsFactory.eINSTANCE.createPopulationLabelValue());
    }

    public static URI createPopulationLabelURI(int adminLevel, String countryCode, String populationIdentifier, String year, String nodeCode) {
        URI retValue = STEMURI.createURI((String)("label/population/" + countryCode + "/" + adminLevel + "/" + populationIdentifier + "/" + year + "/" + nodeCode));
        return retValue;
    }

    public static PopulationLabel getPopulationLabel(String populationIdentifier, Node node) {
        PopulationLabel retValue = null;
        for (NodeLabel nodeLabel : node.getLabels()) {
            PopulationLabel populationLabel;
            if (!(nodeLabel instanceof PopulationLabel) || !(populationLabel = (PopulationLabel)nodeLabel).getPopulationIdentifier().equalsIgnoreCase(populationIdentifier)) continue;
            retValue = populationLabel;
            break;
        }
        return retValue;
    }

    protected EClass eStaticClass() {
        return LabelsPackage.Literals.POPULATION_LABEL;
    }

    @Override
    public String getPopulationIdentifier() {
        return this.populationIdentifier;
    }

    @Override
    public void setPopulationIdentifier(String newPopulationIdentifier) {
        String oldPopulationIdentifier = this.populationIdentifier;
        this.populationIdentifier = newPopulationIdentifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldPopulationIdentifier, (Object)this.populationIdentifier));
        }
    }

    @Override
    public PopulationLabelValue getCurrentPopulationValue() {
        return (PopulationLabelValue)this.getCurrentValue();
    }

    @Override
    public double getPopulatedArea() {
        return this.populatedArea;
    }

    @Override
    public void setPopulatedArea(double newPopulatedArea) {
        double oldPopulatedArea = this.populatedArea;
        this.populatedArea = newPopulatedArea;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, oldPopulatedArea, this.populatedArea));
        }
    }

    @Override
    public int getValidYear() {
        return this.validYear;
    }

    @Override
    public void setValidYear(int newValidYear) {
        int oldValidYear = this.validYear;
        this.validYear = newValidYear;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldValidYear, this.validYear));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getPopulationIdentifier();
            }
            case 8: {
                return this.getCurrentPopulationValue();
            }
            case 9: {
                return this.getPopulatedArea();
            }
            case 10: {
                return this.getValidYear();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setPopulationIdentifier((String)newValue);
                return;
            }
            case 9: {
                this.setPopulatedArea((Double)newValue);
                return;
            }
            case 10: {
                this.setValidYear((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setPopulationIdentifier(POPULATION_IDENTIFIER_EDEFAULT);
                return;
            }
            case 9: {
                this.setPopulatedArea(0.0);
                return;
            }
            case 10: {
                this.setValidYear(2006);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return POPULATION_IDENTIFIER_EDEFAULT == null ? this.populationIdentifier != null : !POPULATION_IDENTIFIER_EDEFAULT.equals(this.populationIdentifier);
            }
            case 8: {
                return this.getCurrentPopulationValue() != null;
            }
            case 9: {
                return this.populatedArea != 0.0;
            }
            case 10: {
                return this.validYear != 2006;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(this.getPopulationIdentifier());
        result.append(" [");
        result.append(this.getCurrentPopulationValue().getCount());
        result.append(this.eIsSet(9) ? "/" + Double.toString(this.getPopulatedArea()) + "km^2" : "");
        result.append("]");
        return result.toString();
    }
}

