/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.execution;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.core.common.impl.DublinCoreImpl;
import org.eclipse.stem.jobs.execution.IExecutable;

public abstract class Executable
extends Job
implements IExecutable {
    private int sequenceNumber = 0;
    private final Date creationTime;

    public Executable(String name, int sequenceNumber) {
        super(name);
        this.sequenceNumber = sequenceNumber;
        this.creationTime = Calendar.getInstance().getTime();
    }

    @Override
    public int getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(int sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    @Override
    public String getNameWithSequenceNumber() {
        StringBuilder retValue = new StringBuilder("[");
        retValue.append(this.getSequenceNumber());
        retValue.append("] ");
        retValue.append(this.getName());
        return retValue.toString();
    }

    @Override
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getUniqueIDString() {
        StringBuilder sb = new StringBuilder(URI.encodeSegment((String)this.getName(), (boolean)false).replace("%", "-"));
        sb.append("-");
        sb.append(this.getSequenceNumber());
        sb.append("-");
        sb.append(DublinCoreImpl.createISO8601DateString((Date)this.getCreationTime()));
        return sb.toString();
    }

    @Override
    public boolean isStoppable() {
        return true;
    }
}

