/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.jobs.simulation;

import java.util.EventObject;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.SimulationManager;

public class SimulationManagerEvent
extends EventObject {
    private static final transient long serialVersionUID = 6533682842547235809L;
    private final transient ISimulation[] simulationsAdded;
    private final transient ISimulation[] simulationsRemoved;

    public SimulationManagerEvent(SimulationManager source, ISimulation[] simulationsAdded, ISimulation[] simulationsRemoved) {
        super(source);
        this.simulationsAdded = (ISimulation[])simulationsAdded.clone();
        this.simulationsRemoved = (ISimulation[])simulationsRemoved.clone();
    }

    public final ISimulation[] getSimulationsAdded() {
        return (ISimulation[])this.simulationsAdded.clone();
    }

    public final ISimulation[] getSimulationsRemoved() {
        return (ISimulation[])this.simulationsRemoved.clone();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Added:[");
        int i = 0;
        while (i < this.simulationsAdded.length) {
            sb.append("\"");
            sb.append(this.simulationsAdded[i].toString());
            sb.append("\"");
            if (i + 1 < this.simulationsAdded.length) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("], Removed:[");
        i = 0;
        while (i < this.simulationsRemoved.length) {
            sb.append("\"");
            sb.append(this.simulationsRemoved[i].toString());
            sb.append("\"");
            if (i + 1 < this.simulationsRemoved.length) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }
}

