/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.jdt;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractJvmTypeProvider;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.jdt.IJdtTypeProvider;
import org.eclipse.xtext.common.types.access.jdt.JdtBasedTypeFactory;
import org.eclipse.xtext.common.types.access.jdt.JdtTypeMirror;
import org.eclipse.xtext.common.types.access.jdt.TypeURIHelper;
import org.eclipse.xtext.util.Strings;

public class JdtTypeProvider
extends AbstractJvmTypeProvider
implements IJdtTypeProvider {
    private final IJavaProject javaProject;
    private final TypeURIHelper typeUriHelper;
    private final JdtBasedTypeFactory typeFactory;

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet) {
        this(javaProject, resourceSet, null);
    }

    public JdtTypeProvider(IJavaProject javaProject, ResourceSet resourceSet, IndexedJvmTypeAccess indexedJvmTypeAccess) {
        super(resourceSet, indexedJvmTypeAccess);
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject may not be null");
        }
        this.javaProject = javaProject;
        this.typeUriHelper = this.createTypeURIHelper();
        this.typeFactory = this.createTypeFactory();
    }

    protected JdtBasedTypeFactory createTypeFactory() {
        return new JdtBasedTypeFactory(this.typeUriHelper);
    }

    protected TypeURIHelper createTypeURIHelper() {
        return new TypeURIHelper();
    }

    public JvmType findTypeByName(String name) {
        URI proxyURI;
        EObject candidate;
        if (Strings.isEmpty((String)name)) {
            throw new IllegalArgumentException("null");
        }
        String signature = null;
        try {
            signature = name.startsWith("[") ? name : Signature.createTypeSignature((String)name, (boolean)true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        URI resourceURI = this.typeUriHelper.createResourceURI(signature);
        String resourcePath = resourceURI.path();
        if (resourcePath.startsWith("/Primitives")) {
            TypeResource resource = (TypeResource)this.getResourceForJavaURI(resourceURI, true);
            JvmType result = this.findTypeBySignature(signature, resource);
            return result;
        }
        TypeResource resource = (TypeResource)this.getResourceForJavaURI(resourceURI, false);
        if (resource != null) {
            JvmType result = this.findTypeBySignature(signature, resource);
            return result;
        }
        IndexedJvmTypeAccess indexedJvmTypeAccess = this.getIndexedJvmTypeAccess();
        if (indexedJvmTypeAccess != null && (candidate = indexedJvmTypeAccess.getIndexedJvmType(proxyURI = resourceURI.appendFragment(this.typeUriHelper.getFragment(signature)), this.getResourceSet())) instanceof JvmType) {
            return (JvmType)candidate;
        }
        String topLevelType = resourceURI.segment(resourceURI.segmentCount() - 1);
        try {
            int lastDot = topLevelType.lastIndexOf(46);
            String packageName = null;
            String typeName = topLevelType;
            if (lastDot != -1) {
                typeName = typeName.substring(lastDot + 1);
                packageName = topLevelType.substring(0, lastDot);
            }
            if (this.javaProject.findType(packageName, typeName) != null) {
                resource = (TypeResource)this.getResourceForJavaURI(resourceURI, true);
                JvmType result = this.findTypeBySignature(signature, resource);
                return result;
            }
            return null;
        }
        catch (JavaModelException e) {
            return null;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    protected Resource getResourceForJavaURI(URI resourceURI, boolean loadOnDemand) {
        return this.getResourceSet().getResource(resourceURI, loadOnDemand);
    }

    public JvmType findTypeBySignature(String signature, TypeResource resource) {
        String fragment = this.typeUriHelper.getFragment(signature);
        return (JvmType)resource.getEObject(fragment);
    }

    protected IMirror createMirrorForFQN(String name) {
        IType type;
        block5: {
            block4: {
                try {
                    type = this.javaProject.findType(name);
                    if (type != null && type.exists()) break block4;
                    return null;
                }
                catch (JavaModelException e) {
                    return null;
                }
            }
            String elementName = type.getElementName();
            if (elementName.equals(type.getTypeQualifiedName())) break block5;
            return null;
        }
        return new JdtTypeMirror(type, this.typeFactory);
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public TypeURIHelper getTypeUriHelper() {
        return this.typeUriHelper;
    }

    public JdtBasedTypeFactory getJdtBasedTypeFactory() {
        return this.typeFactory;
    }
}

