/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.navigation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.ui.text.JavaWordFinder;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.xtext.common.types.ui.navigation.LinkToOrigin;
import org.eclipse.xtext.generator.trace.ILocationInResource;
import org.eclipse.xtext.generator.trace.ITrace;
import org.eclipse.xtext.generator.trace.ITraceInformation;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class LinkToOriginDetector
extends AbstractHyperlinkDetector {
    @Inject
    private Provider<LinkToOrigin> hyperlinkProvider;
    @Inject
    private ITraceInformation traceInformation;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        try {
            IJavaElement[] javaElements;
            ITextEditor textEditor = (ITextEditor)this.getAdapter(ITextEditor.class);
            if (textEditor == null) {
            }
            IEditorInput editorInput = textEditor.getEditorInput();
            if (editorInput == null) {
            }
            IJavaElement adaptedJavaElement = (IJavaElement)Platform.getAdapterManager().getAdapter((Object)editorInput, IJavaElement.class);
            if (adaptedJavaElement == null) {
            }
            ICompilationUnit compilationUnit = (ICompilationUnit)adaptedJavaElement.getAncestor(5);
            if (compilationUnit == null) {
            }
            IRegion selectedWord = JavaWordFinder.findWord((IDocument)textViewer.getDocument(), (int)region.getOffset());
            IJavaElement[] iJavaElementArray = javaElements = compilationUnit.codeSelect(selectedWord.getOffset(), selectedWord.getLength());
            int n = javaElements.length;
            int n2 = 0;
            while (n2 < n) {
                IMember selectedMember;
                IResource resource;
                IJavaElement javaElement = iJavaElementArray[n2];
                if (javaElement instanceof IMember && (resource = (selectedMember = (IMember)javaElement).getResource()) instanceof IFile) {
                    ITrace traceToSource = this.traceInformation.getTraceToSource((IStorage)resource);
                    if (traceToSource == null) {
                    }
                    Iterable sourceInformation = traceToSource.getAllAssociatedLocations((ITextRegion)new TextRegion(selectedWord.getOffset(), selectedWord.getLength()));
                    ArrayList sourceInformationAsList = Lists.newArrayList((Iterable)sourceInformation);
                    if (!canShowMultipleHyperlinks && sourceInformationAsList.size() > 1) {
                    }
                    ArrayList result = Lists.newArrayListWithCapacity((int)sourceInformationAsList.size());
                    for (ILocationInResource source : sourceInformationAsList) {
                        try {
                            URI resourceURI = source.getResourceURI();
                            if (resourceURI == null) continue;
                            LinkToOrigin hyperlink = (LinkToOrigin)((Object)this.hyperlinkProvider.get());
                            hyperlink.setHyperlinkRegion(new Region(selectedWord.getOffset(), selectedWord.getLength()));
                            hyperlink.setURI(resourceURI);
                            hyperlink.setHyperlinkText("Go to " + resourceURI.lastSegment());
                            hyperlink.setTypeLabel("Navigate to source artifact");
                            hyperlink.setMember(selectedMember);
                            result.add(hyperlink);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (result.isEmpty()) {
                    }
                    return result.toArray(new IHyperlink[result.size()]);
                }
                ++n2;
            }
        }
        finally {
            return null;
        }
    }
}

