/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.wizards;

import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.metamodel.MetamodelFactory;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelParam;
import org.eclipse.stem.model.metamodel.ModelParamConstraint;
import org.eclipse.stem.model.ui.wizards.ModelParamConstraintEditorDialog;
import org.eclipse.stem.model.ui.wizards.WizardHelper;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ModelParamEditorDialog
extends TitleAreaDialog {
    protected static final String[] CONSTRAINT_TABLE_COLUMNS = new String[]{"Constraint Name", "Constraint Value"};
    protected Text nameText;
    protected Text displayNameText;
    protected Text defaultValueText;
    protected Text helpMessageText;
    protected Text unitText;
    protected Text missingMessageText;
    protected Text invalidMessageText;
    protected ComboViewer dataTypeComboViewer;
    protected Table constraintTable;
    protected TableViewer constraintTableViewer;
    protected Button addConstraintButton;
    protected Button editConstraintButton;
    protected Button removeConstraintButton;
    protected Model model;
    protected ModelParam param;
    protected ModelParam originalParam;
    protected boolean nameModified = false;
    protected boolean displayNameModified = true;
    protected String errorMessage = null;

    public ModelParamEditorDialog(Shell parentShell, int style, Model model, ModelParam param, ModelParam originalParam) {
        super(parentShell);
        this.param = param;
        this.originalParam = originalParam;
        this.model = model;
    }

    public void create() {
        super.create();
        this.setTitle("Edit Param");
        this.setMessage("Edit the Model Parameter");
        this.nameText.setText(WizardHelper.safeGet(this.param.getName()));
        this.displayNameText.setText(WizardHelper.safeGet(this.param.getDisplayName()));
        this.defaultValueText.setText(WizardHelper.safeGet(this.param.getDefaultValue()));
        this.unitText.setText(WizardHelper.safeGet(this.param.getUnit()));
        this.helpMessageText.setText(WizardHelper.safeGet(this.param.getHelpMessage()));
        this.missingMessageText.setText(WizardHelper.safeGet(this.param.getMissingMessage()));
        this.invalidMessageText.setText(WizardHelper.safeGet(this.param.getInvalidMessage()));
        EClassifier selectedType = this.param.getDataType();
        if (selectedType == null) {
            selectedType = WizardHelper.getDefaultModelParamDataTypes()[0];
        }
        this.dataTypeComboViewer.setSelection((ISelection)new StructuredSelection((Object)selectedType));
        this.setDefaultValueIfNeeded();
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite container = new Composite(parent, 0);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = 2;
        container.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Name");
        this.nameText = new Text(container, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ModelParamEditorDialog.this.nameModified = true;
                ModelParamEditorDialog.this.displayNameModified = false;
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.nameText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ModelParamEditorDialog.this.formatTextFields();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Label displayNameLabel = new Label(container, 0);
        displayNameLabel.setText("Display Name");
        this.displayNameText = new Text(container, 2048);
        this.displayNameText.setLayoutData((Object)new GridData(768));
        this.displayNameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                ModelParamEditorDialog.this.displayNameModified = true;
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        this.createDataTypeList(container);
        Label defaultValueLabel = new Label(container, 0);
        defaultValueLabel.setText("Default Value");
        this.defaultValueText = new Text(container, 2048);
        this.defaultValueText.setLayoutData((Object)new GridData(768));
        this.createConstraintTable(container);
        Label unitLabel = new Label(container, 0);
        unitLabel.setText("Units");
        this.unitText = new Text(container, 2048);
        this.unitText.setLayoutData((Object)new GridData(768));
        Label helpMessageLabel = new Label(container, 0);
        helpMessageLabel.setText("Help Message");
        this.helpMessageText = new Text(container, 2048);
        this.helpMessageText.setLayoutData((Object)new GridData(768));
        Label missingMessageLabel = new Label(container, 0);
        missingMessageLabel.setText("Missing Message");
        this.missingMessageText = new Text(container, 2048);
        this.missingMessageText.setLayoutData((Object)new GridData(768));
        Label invalidMessageLabel = new Label(container, 0);
        invalidMessageLabel.setText("Invalid Message");
        this.invalidMessageText = new Text(container, 2048);
        this.invalidMessageText.setLayoutData((Object)new GridData(768));
        return parent;
    }

    private void formatTextFields() {
        this.nameText.setText(WizardHelper.formatToCamelCase(this.nameText.getText()));
        if (!this.displayNameModified) {
            this.displayNameText.setText(WizardHelper.formatToCapWords(this.nameText.getText()));
        }
        this.setDefaultValueIfNeeded();
    }

    private EClassifier getDataType() {
        return (EClassifier)((StructuredSelection)this.dataTypeComboViewer.getSelection()).getFirstElement();
    }

    private void setDefaultValueIfNeeded() {
        if (GeneratorUtils.isNullOrEmpty((String)this.defaultValueText.getText())) {
            this.defaultValueText.setText(WizardHelper.getDefaultValueForDataType(this.getDataType()));
        }
    }

    private void createDataTypeList(Composite container) {
        Label dataTypeLabel = new Label(container, 0);
        dataTypeLabel.setText("Data Type");
        this.dataTypeComboViewer = new ComboViewer(container, 8);
        this.dataTypeComboViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.dataTypeComboViewer.setLabelProvider((IBaseLabelProvider)new DataTypeViewerLabelProvider());
        this.dataTypeComboViewer.setInput((Object)WizardHelper.getDefaultModelParamDataTypes());
    }

    private void createConstraintTable(Composite container) {
        Label unitLabel = new Label(container, 0);
        unitLabel.setText("Constraints");
        GridData labelGridData = new GridData(16384, 128, false, false);
        labelGridData.verticalIndent = 5;
        unitLabel.setLayoutData((Object)labelGridData);
        Group constraintComposite = new Group(container, 0);
        constraintComposite.setText("");
        GridData compositeGridData = new GridData(1808);
        compositeGridData.minimumHeight = 115;
        constraintComposite.setLayoutData((Object)compositeGridData);
        constraintComposite.setLayout((Layout)new GridLayout(3, false));
        this.constraintTable = new Table((Composite)constraintComposite, 101124);
        this.constraintTable.setLinesVisible(true);
        this.constraintTable.setHeaderVisible(true);
        GridData tableGridData = new GridData(1808);
        tableGridData.horizontalSpan = 3;
        this.constraintTable.setLayoutData((Object)tableGridData);
        String[] stringArray = CONSTRAINT_TABLE_COLUMNS;
        int n = CONSTRAINT_TABLE_COLUMNS.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            TableColumn constraintNameColumn = new TableColumn(this.constraintTable, 0);
            constraintNameColumn.setText(column);
            constraintNameColumn.setResizable(true);
            constraintNameColumn.setWidth(200);
            ++n2;
        }
        this.constraintTableViewer = new TableViewer(this.constraintTable);
        this.constraintTableViewer.setUseHashlookup(true);
        this.constraintTableViewer.setColumnProperties(CONSTRAINT_TABLE_COLUMNS);
        this.constraintTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.constraintTableViewer.setLabelProvider((IBaseLabelProvider)new ConstraintTableLabelProvider());
        this.constraintTableViewer.setInput((Object)this.param.getConstraints());
        this.constraintTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ModelParamEditorDialog.this.editConstraint();
            }
        });
        this.constraintTableViewer.getTable().addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                ModelParamEditorDialog.this.toggleConstraintButtons(true);
            }

            public void focusGained(FocusEvent e) {
                ModelParamEditorDialog.this.toggleConstraintButtons(false);
            }
        });
        this.constraintTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelParamEditorDialog.this.toggleConstraintButtons(false);
            }
        });
        this.addConstraintButton = new Button((Composite)constraintComposite, 8);
        this.addConstraintButton.setText("Add");
        this.addConstraintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelParamEditorDialog.this.addConstraint();
            }
        });
        this.editConstraintButton = new Button((Composite)constraintComposite, 8);
        this.editConstraintButton.setText("Edit");
        this.editConstraintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelParamEditorDialog.this.editConstraint();
            }
        });
        this.removeConstraintButton = new Button((Composite)constraintComposite, 8);
        this.removeConstraintButton.setText("Remove");
        this.removeConstraintButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModelParamEditorDialog.this.removeConstraint();
            }
        });
        this.toggleConstraintButtons(false);
    }

    private void toggleConstraintButtons(boolean forceDisable) {
        boolean toggle = false;
        if (!forceDisable) {
            toggle = this.getSelectedConstraint() != null;
        }
        this.editConstraintButton.setEnabled(toggle);
        this.removeConstraintButton.setEnabled(toggle);
    }

    private ModelParamConstraint openConstraintEditorDialog(ModelParamConstraint constraint) {
        ModelParamConstraint constraintToUse = null;
        constraintToUse = constraint == null ? MetamodelFactory.eINSTANCE.createModelParamConstraint() : (ModelParamConstraint)EcoreUtil.copy((EObject)constraint);
        ModelParamConstraintEditorDialog editorDialog = new ModelParamConstraintEditorDialog(this.getShell(), 0, this.param, constraintToUse);
        if (editorDialog.open() == 0) {
            return constraintToUse;
        }
        return null;
    }

    private void addConstraint() {
        ModelParamConstraint constraint = this.openConstraintEditorDialog(null);
        if (constraint != null) {
            this.param.getConstraints().add((Object)constraint);
            this.constraintTableViewer.refresh();
        }
    }

    private void editConstraint() {
        ModelParamConstraint constraint;
        ModelParamConstraint previousConstraint = this.getSelectedConstraint();
        if (previousConstraint != null && (constraint = this.openConstraintEditorDialog(previousConstraint)) != null) {
            this.param.getConstraints().remove((Object)previousConstraint);
            this.param.getConstraints().add((Object)constraint);
            this.constraintTableViewer.refresh();
        }
    }

    private void removeConstraint() {
        ModelParamConstraint selected = this.getSelectedConstraint();
        if (selected != null) {
            this.param.getConstraints().remove((Object)selected);
            this.constraintTableViewer.refresh();
        }
    }

    private ModelParamConstraint getSelectedConstraint() {
        return (ModelParamConstraint)((StructuredSelection)this.constraintTableViewer.getSelection()).getFirstElement();
    }

    protected boolean hasNameConflict() {
        for (ModelParam param : WizardHelper.getAllParametersForModel(this.model)) {
            if (param == this.originalParam || !param.getName().equals(this.nameText.getText())) continue;
            return true;
        }
        return false;
    }

    protected boolean validate() {
        if (GeneratorUtils.isNullOrEmpty((String)this.nameText.getText())) {
            this.errorMessage = "Enter a name for this parameter";
            return false;
        }
        if (GeneratorUtils.isNullOrEmpty((String)this.displayNameText.getText())) {
            this.errorMessage = "Enter a display name for this parameter";
            return false;
        }
        if (this.hasNameConflict()) {
            this.errorMessage = "This model already contains a parameter named \"" + this.nameText.getText() + "\"";
            return false;
        }
        this.errorMessage = null;
        return true;
    }

    protected void okPressed() {
        this.formatTextFields();
        if (this.validate()) {
            this.param.setName(this.nameText.getText());
            this.param.setDisplayName(this.displayNameText.getText());
            this.param.setDefaultValue(this.defaultValueText.getText());
            this.param.setUnit(this.unitText.getText());
            this.param.setHelpMessage(this.helpMessageText.getText());
            this.param.setMissingMessage(this.missingMessageText.getText());
            this.param.setInvalidMessage(this.invalidMessageText.getText());
            this.param.setDataType(this.getDataType());
            super.okPressed();
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)this.errorMessage);
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private class ConstraintTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ConstraintTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ModelParamConstraint constraint = (ModelParamConstraint)element;
            switch (columnIndex) {
                case 0: {
                    return constraint.getName();
                }
                case 1: {
                    return constraint.getConstraint();
                }
            }
            return "";
        }
    }

    private static class DataTypeViewerLabelProvider
    extends LabelProvider {
        private DataTypeViewerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EClassifier) {
                String name = ((EClassifier)element).getInstanceClassName();
                int lastIdx = name.lastIndexOf(46);
                if (lastIdx >= 0) {
                    name = name.substring(lastIdx + 1);
                }
                return name;
            }
            return "";
        }
    }
}

