/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.Modifier;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import com.sun.mirror.util.SourcePosition;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.apt.core.internal.declaration.DeclarationImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.ExecutableDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryParameterDeclarationImpl
extends DeclarationImpl
implements ParameterDeclaration {
    static final String ARG = "arg";
    private final ITypeBinding _type;
    private final ExecutableDeclarationImpl _executable;
    private final int _paramIndex;

    public BinaryParameterDeclarationImpl(ExecutableDeclarationImpl executable, ITypeBinding typeBinding, int index, BaseProcessorEnv env) {
        super((IBinding)typeBinding, env);
        assert (typeBinding != null) : "missing type binding";
        assert (index >= 0) : "invalid index " + index;
        assert (executable != null) : "missing executable";
        this._type = typeBinding;
        this._paramIndex = index;
        this._executable = executable;
    }

    @Override
    public void accept(DeclarationVisitor visitor) {
        visitor.visitParameterDeclaration(this);
    }

    @Override
    public Collection<Modifier> getModifiers() {
        return Collections.emptyList();
    }

    @Override
    public String getDocComment() {
        return null;
    }

    @Override
    public String getSimpleName() {
        SingleVariableDeclaration decl = (SingleVariableDeclaration)this.getAstNode();
        if (decl == null) {
            return ARG + this._paramIndex;
        }
        SimpleName name = decl.getName();
        return name == null ? ARG : name.toString();
    }

    @Override
    public SourcePosition getPosition() {
        return null;
    }

    @Override
    public TypeMirror getType() {
        EclipseMirrorType mirrorType = Factory.createTypeMirror(this.getTypeBinding(), this._env);
        if (mirrorType == null) {
            return Factory.createErrorClassType(this.getTypeBinding());
        }
        return mirrorType;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        IMethodBinding methodBinding = this._executable.getDeclarationBinding();
        IAnnotationBinding[] paramAnnos = methodBinding.getParameterAnnotations(this._paramIndex);
        return this._getAnnotation(annotationClass, paramAnnos);
    }

    @Override
    public Collection<AnnotationMirror> getAnnotationMirrors() {
        IMethodBinding methodBinding = this._executable.getDeclarationBinding();
        IAnnotationBinding[] paramAnnos = methodBinding.getParameterAnnotations(this._paramIndex);
        return this._getAnnotationMirrors(paramAnnos);
    }

    @Override
    public boolean isBindingBased() {
        return true;
    }

    @Override
    public boolean isFromSource() {
        return false;
    }

    @Override
    ASTNode getAstNode() {
        return null;
    }

    @Override
    public IFile getResource() {
        return null;
    }

    private ITypeBinding getTypeBinding() {
        return this._type;
    }

    @Override
    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.FORMAL_PARAMETER;
    }

    @Override
    public IBinding getDeclarationBinding() {
        throw new UnsupportedOperationException("should never be invoked on a BinaryParameterDeclaration");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BinaryParameterDeclarationImpl) {
            BinaryParameterDeclarationImpl otherParam = (BinaryParameterDeclarationImpl)obj;
            return otherParam._paramIndex == this._paramIndex && otherParam._executable.getDeclarationBinding().isEqualTo((IBinding)this._executable.getDeclarationBinding());
        }
        return false;
    }

    @Override
    public int hashCode() {
        String methodKey = this._executable.getDeclarationBinding().getKey();
        int hashcode = 0;
        if (methodKey != null) {
            hashcode = methodKey.hashCode();
        }
        return hashcode + this._paramIndex;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getTypeBinding().getName());
        builder.append(' ');
        builder.append(this.getSimpleName());
        return builder.toString();
    }
}

