/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ui.editor.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gef.editpolicies.ConnectionEditPolicy;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.stem.model.metamodel.MetamodelPackage;
import org.eclipse.stem.model.ui.editor.commands.TransitionDeleteCommand;
import org.eclipse.stem.model.ui.editor.figures.TransitionFigure;
import org.eclipse.stem.model.ui.editor.vismodel.TransitionElement;

public class TransitionElementEditPart
extends AbstractConnectionEditPart {
    private Adapter transitionElementListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            TransitionElementEditPart.this.refreshSourceConnections();
            TransitionElementEditPart.this.refreshTargetConnections();
            TransitionElementEditPart.this.refresh();
        }
    };
    private Adapter transitionListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getFeature() == MetamodelPackage.Literals.TRANSITION__EXPRESSION || msg.getFeature() == MetamodelPackage.Literals.TRANSITION__EXPRESSION_RESOURCE) {
                TransitionElementEditPart.this.getCastedFigure().updateFlags();
                TransitionElementEditPart.this.refresh();
            }
        }
    };

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().eAdapters().add((Object)this.transitionElementListener);
            this.getCastedModel().getTransition().eAdapters().add((Object)this.transitionListener);
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            this.getCastedModel().eAdapters().remove((Object)this.transitionElementListener);
            this.getCastedModel().getTransition().eAdapters().remove((Object)this.transitionListener);
            super.deactivate();
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("ConnectionEditPolicy", (EditPolicy)new ConnectionEditPolicy(){

            protected Command getDeleteCommand(GroupRequest request) {
                return new TransitionDeleteCommand(TransitionElementEditPart.this.getCastedModel());
            }
        });
    }

    protected IFigure createFigure() {
        return new TransitionFigure(this.getCastedModel());
    }

    private TransitionElement getCastedModel() {
        return (TransitionElement)this.getModel();
    }

    private TransitionFigure getCastedFigure() {
        return (TransitionFigure)this.getFigure();
    }
}

