/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclarationStatement;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.Selection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NameCollector
extends GenericVisitor {
    private List<String> names = new ArrayList<String>();
    private Selection fSelection;

    public NameCollector(ASTNode node) {
        this.fSelection = Selection.createFromStartLength(node.getStartPosition(), node.getLength());
    }

    @Override
    protected boolean visitNode(ASTNode node) {
        if (node.getStartPosition() > this.fSelection.getInclusiveEnd()) {
            return true;
        }
        return this.fSelection.coveredBy(node);
    }

    @Override
    public boolean visit(SimpleName node) {
        this.names.add(node.getIdentifier());
        return super.visit(node);
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        return true;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        boolean result = super.visit(node);
        if (!result) {
            this.names.add(node.getName().getIdentifier());
        }
        return result;
    }

    @Override
    public boolean visit(SingleVariableDeclaration node) {
        boolean result = super.visit(node);
        if (!result) {
            this.names.add(node.getName().getIdentifier());
        }
        return result;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        this.names.add(node.getDeclaration().getName().getIdentifier());
        return false;
    }

    List<String> getNames() {
        return this.names;
    }
}

