/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.data;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.ColumnBinding;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

public class ExpressionParserUtility {
    private final String pluginId = "org.eclipse.birt.core";
    private static final String ROWS_0_INDICATOR = "rows";
    private static final String TOTAL = "Total";
    private String ROW_INDICATOR = "row";
    private boolean hasAggregation = false;
    private boolean isDirectColumnRef = false;

    public static List compileColumnExpression(String expression) throws BirtException {
        return ExpressionParserUtility.compileColumnExpression(new ExpressionParserUtility(), expression, "row");
    }

    public static List compileColumnExpression(ExpressionParserUtility util, String expression, String indicator) throws BirtException {
        if (expression == null || expression.trim().length() == 0) {
            return new ArrayList();
        }
        util.ROW_INDICATOR = indicator;
        ArrayList columnExprList = new ArrayList();
        columnExprList.clear();
        Context context = Context.enter();
        try {
            try {
                ScriptOrFnNode tree = util.parse(expression, context);
                util.CompiledExprFromTree(expression, context, tree, columnExprList);
            }
            catch (Exception ex) {
                throw new CoreException("INVALID_EXPRSSION", (Object)expression, (Throwable)ex);
            }
        }
        finally {
            Context.exit();
        }
        return columnExprList;
    }

    public static boolean hasAggregation(String expression) throws BirtException {
        return ExpressionParserUtility.hasAggregation(expression, "row");
    }

    static boolean hasAggregation(String expression, String indicator) throws BirtException {
        ExpressionParserUtility util = new ExpressionParserUtility();
        util.hasAggregation = false;
        ExpressionParserUtility.compileColumnExpression(util, expression, indicator);
        return util.hasAggregation;
    }

    static boolean isDirectColumnRef(String expression, String indicator) throws BirtException {
        ExpressionParserUtility util = new ExpressionParserUtility();
        util.isDirectColumnRef = false;
        ExpressionParserUtility.compileColumnExpression(util, expression, indicator);
        return util.isDirectColumnRef;
    }

    private void CompiledExprFromTree(String expression, Context context, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        if (tree.getFirstChild() == tree.getLastChild()) {
            if (tree.getFirstChild().getType() == 108) {
                int index = this.getFunctionIndex(tree.getFirstChild().getString(), tree);
                this.compileFunctionNode(tree.getFunctionNode(index), tree, columnExprList);
            } else {
                if (tree.getFirstChild().getType() != 133 && tree.getFirstChild().getType() != 132 && tree.getFirstChild().getType() != 128 && tree.getFirstChild().getType() != 135) {
                    throw new CoreException("org.eclipse.birt.core", "INVALID_EXPRSSION");
                }
                Node exprNode = tree.getFirstChild();
                this.processChild(exprNode, tree, columnExprList);
            }
        } else {
            this.compileComplexExpr((Node)tree, tree, columnExprList);
        }
    }

    private ScriptOrFnNode parse(String expression, Context cx) {
        CompilerEnvirons compilerEnv = new CompilerEnvirons();
        Parser p = new Parser(compilerEnv, cx.getErrorReporter());
        return p.parse(expression, null, 0);
    }

    private void processChild(Node child, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        switch (child.getType()) {
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                break;
            }
            case 33: 
            case 35: 
            case 36: 
            case 37: {
                this.compileDirectColRefExpr(child, tree, columnExprList);
                break;
            }
            case 38: {
                this.compileAggregateExpr(child, tree, columnExprList);
                break;
            }
            default: {
                this.compileComplexExpr(child, tree, columnExprList);
            }
        }
    }

    private void compileDirectColRefExpr(Node refNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        assert (refNode.getType() == 33 || refNode.getType() == 36 || refNode.getType() == 37 || refNode.getType() == 35);
        Node rowName = refNode.getFirstChild();
        assert (rowName != null);
        if (rowName.getType() != 39) {
            if (refNode.getType() == 33 || refNode.getType() == 36 || refNode.getType() == 37 || refNode.getType() == 35) {
                this.compileOuterColRef(refNode, tree, columnExprList);
                this.compileRowPositionRef(refNode, tree, columnExprList);
                return;
            }
            this.compileComplexExpr(refNode, tree, columnExprList);
            return;
        }
        this.compileSimpleColumnRefExpr(refNode, tree, columnExprList);
    }

    private void compileOuterColRef(Node refNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        int level = this.compileOuterColRefExpr(refNode);
        if (level == -1) {
            this.compileComplexExpr(refNode, tree, columnExprList);
        } else {
            Node nextNode = refNode.getLastChild();
            if (nextNode.getType() == 41) {
                ColumnBinding info = new ColumnBinding(nextNode.getString(), "", level);
                columnExprList.add(info);
            }
        }
    }

    private void compileRowPositionRef(Node refNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node rowColumn;
        Node rowNode;
        Node rowFirstNode = refNode.getFirstChild();
        if (!(rowFirstNode.getType() != 36 && rowFirstNode.getType() != 37 || (rowNode = rowFirstNode.getFirstChild()) == null || rowNode.getType() != 39 || !rowNode.getString().equals(ROWS_0_INDICATOR) || (rowColumn = rowNode.getNext()).getDouble() != 0.0 || (rowColumn = rowFirstNode.getNext()).getType() != 41 || refNode.getType() != 36 && refNode.getType() != 37)) {
            ColumnBinding binding = new ColumnBinding(rowColumn.getString(), ExpressionUtil.createJSDataSetRowExpression(rowColumn.getString()), 1);
            columnExprList.add(binding);
        }
    }

    private void compileSimpleColumnRefExpr(Node refNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node rowName = refNode.getFirstChild();
        String str = rowName.getString();
        assert (str != null);
        Node rowColumn = rowName.getNext();
        assert (rowColumn != null);
        if (!str.equals(this.ROW_INDICATOR)) {
            if (rowColumn != null && rowColumn.getNext() != null) {
                this.processChild(rowColumn.getNext(), tree, columnExprList);
            }
            return;
        }
        if ((refNode.getType() == 33 || refNode.getType() == 35) && rowColumn.getType() == 41) {
            int outer_count = 0;
            if ("__rownum".equals(rowColumn.getString()) || "0".equals(rowColumn.getString())) {
                return;
            }
            if ("_outer".equals(rowColumn.getString())) {
                Node outer_Node;
                ++outer_count;
                Node before_Node = outer_Node = refNode.getNext();
                while (outer_Node != null && outer_Node.getString() != null && "_outer".equals(outer_Node.getString())) {
                    ++outer_count;
                    before_Node = outer_Node;
                    outer_Node = outer_Node.getNext();
                }
                ColumnBinding info = new ColumnBinding(before_Node.getString(), "", outer_count);
                columnExprList.add(info);
                return;
            }
            if (tree.getFirstChild().getFirstChild() == refNode && refNode.getNext() == null) {
                this.isDirectColumnRef = true;
            }
            ColumnBinding binding = new ColumnBinding(rowColumn.getString(), ExpressionUtil.createDataSetRowExpression(rowColumn.getString()));
            columnExprList.add(binding);
        }
        if (refNode.getType() == 36 || refNode.getType() == 37) {
            if (rowColumn.getType() == 40) {
                if (0.0 == rowColumn.getDouble()) {
                    return;
                }
            } else if (rowColumn.getType() == 41) {
                if ("_rownum".equals(rowColumn.getString())) {
                    return;
                }
                if (tree.getFirstChild().getFirstChild() == refNode && refNode.getNext() == null) {
                    this.isDirectColumnRef = true;
                }
                ColumnBinding binding = new ColumnBinding(rowColumn.getString(), ExpressionUtil.createJSDataSetRowExpression(rowColumn.getString()));
                columnExprList.add(binding);
            }
        }
        if (rowColumn != null && rowColumn.getNext() != null) {
            this.processChild(rowColumn.getNext(), tree, columnExprList);
        }
    }

    private int compileOuterColRefExpr(Node refNode) {
        int count = 0;
        Node rowFirstNode = refNode.getFirstChild();
        if (refNode.getType() == 33 || refNode.getType() == 36 || refNode.getType() == 35 || refNode.getType() == 37) {
            if (rowFirstNode.getType() == 39 && rowFirstNode.getString().equals(this.ROW_INDICATOR)) {
                Node rowColumn = rowFirstNode.getNext();
                if (rowColumn.getType() == 41 && "_outer".equals(rowColumn.getString())) {
                    ++count;
                }
                return count;
            }
            if (rowFirstNode.getType() == 33 || rowFirstNode.getType() == 35) {
                if (this.compileOuterColRefExpr(rowFirstNode) == -1) {
                    return -1;
                }
                count += this.compileOuterColRefExpr(rowFirstNode);
                Node nextChild = rowFirstNode.getNext();
                if (nextChild.getType() == 41 && "_outer".equals(nextChild.getString())) {
                    ++count;
                }
            } else {
                return -1;
            }
            return count;
        }
        return -1;
    }

    private void compileAggregateExpr(Node callNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        assert (callNode.getType() == 38);
        this.compileAggregationFunction(callNode, tree, columnExprList);
        this.extractArguments(callNode, tree, columnExprList);
    }

    private void compileAggregationFunction(Node callNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node firstChild = callNode.getFirstChild();
        if (firstChild.getType() != 33) {
            return;
        }
        Node getPropLeftChild = firstChild.getFirstChild();
        if (getPropLeftChild.getType() == 39 && getPropLeftChild.getString().equals(TOTAL)) {
            this.hasAggregation = true;
        }
        this.compileComplexExpr(firstChild, tree, columnExprList);
    }

    private void extractArguments(Node callNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node arg = callNode.getFirstChild().getNext();
        while (arg != null) {
            Node nextArg = arg.getNext();
            this.processChild(arg, tree, columnExprList);
            arg = nextArg;
        }
    }

    private void compileComplexExpr(Node complexNode, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        Node child = complexNode.getFirstChild();
        while (child != null) {
            if (child.getType() == 108) {
                int index = this.getFunctionIndex(child.getString(), tree);
                this.compileFunctionNode(tree.getFunctionNode(index), tree, columnExprList);
            }
            Node nextChild = child.getNext();
            if (child.getType() == 40 || child.getType() == 41 || child.getType() == 45 || child.getType() == 44 || child.getType() == 42) {
                this.processChild(child, tree, columnExprList);
                child = nextChild;
                continue;
            }
            this.processChild(child, tree, columnExprList);
            child = nextChild;
        }
    }

    private void compileFunctionNode(FunctionNode node, ScriptOrFnNode tree, List columnExprList) throws BirtException {
        this.compileComplexExpr((Node)node, tree, columnExprList);
    }

    private int getFunctionIndex(String functionName, ScriptOrFnNode tree) {
        int index = -1;
        int i = 0;
        while (i < tree.getFunctionCount()) {
            if (tree.getFunctionNode(i).getFunctionName().equals(functionName)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public boolean hasAggregation() {
        return this.hasAggregation;
    }

    public boolean isDirectColumnRef() {
        return this.isDirectColumnRef;
    }

    public void reset() {
        this.hasAggregation = false;
        this.isDirectColumnRef = false;
    }
}

