/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.forcing.impl;

import java.io.FileWriter;
import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.diseasemodels.forcing.ForcingPackage;
import org.eclipse.stem.diseasemodels.forcing.Gaussian2ForcingDiseaseModel;
import org.eclipse.stem.diseasemodels.forcing.impl.GaussianForcingDiseaseModelImpl;
import org.eclipse.stem.diseasemodels.standard.SIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.SIRLabelValueImpl;

public class Gaussian2ForcingDiseaseModelImpl
extends GaussianForcingDiseaseModelImpl
implements Gaussian2ForcingDiseaseModel {
    protected static final double SIGMA2_2_EDEFAULT = 100.0;
    protected double sigma2_2 = 100.0;
    protected static final double ATT1_EDEFAULT = 1.0;
    protected double att1 = 1.0;
    protected static final double ATT2_EDEFAULT = 1.0;
    protected double att2 = 1.0;
    protected static final double ATT3_EDEFAULT = 1.0;
    protected double att3 = 1.0;
    protected static final double ATT4_EDEFAULT = 1.0;
    protected double att4 = 1.0;
    private ArrayList<Long> writtedTimes = new ArrayList();
    private FileWriter fw;

    @Override
    protected EClass eStaticClass() {
        return ForcingPackage.Literals.GAUSSIAN2_FORCING_DISEASE_MODEL;
    }

    @Override
    public double getSigma2_2() {
        return this.sigma2_2;
    }

    @Override
    public void setSigma2_2(double newSigma2_2) {
        this.sigma2_2 = newSigma2_2;
    }

    @Override
    public double getAtt1() {
        return this.att1;
    }

    @Override
    public void setAtt1(double newAtt1) {
        this.att1 = newAtt1;
    }

    @Override
    public double getAtt2() {
        return this.att2;
    }

    @Override
    public void setAtt2(double newAtt2) {
        this.att2 = newAtt2;
    }

    @Override
    public double getAtt3() {
        return this.att3;
    }

    @Override
    public void setAtt3(double newAtt3) {
        this.att3 = newAtt3;
    }

    @Override
    public double getAtt4() {
        return this.att4;
    }

    @Override
    public void setAtt4(double newAtt4) {
        this.att4 = newAtt4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void calculateDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        double adjustedTransmissionRate = this.getAdjustedTransmissionRate(timeDelta);
        double adjustedRecoveryRate = this.getAdjustedRecoveryRate(timeDelta);
        double adjustedImmunityLossRate = this.getAdjustedImmunityLossRate(timeDelta);
        int _i = 0;
        while (_i < labels.size()) {
            DynamicLabel label = (DynamicLabel)labels.get(_i);
            IntegrationLabel ilabel = (IntegrationLabel)label;
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)ilabel;
            StandardDiseaseModelLabelValue currentState = (StandardDiseaseModelLabelValue)ilabel.getProbeValue();
            StandardDiseaseModelLabelValue deltaValue = (StandardDiseaseModelLabelValue)ilabel.getDeltaValue();
            deltaValue.reset();
            SIRLabelValue currentSIR = (SIRLabelValue)currentState;
            double seasonalModulationFloor = this.getModulationFloor();
            double modulationPeriod = this.getModulationPeriod();
            double phase = this.getModulationPhaseShift();
            double sigma2 = this.getSigma2();
            double sigma2_2 = this.getSigma2_2();
            double mu1 = phase;
            double mu2 = phase + modulationPeriod;
            double modulation1 = 1.0 / Math.sqrt(Math.PI * 2 * sigma2) * Math.exp(-Math.pow(t - mu1, 2.0) / (2.0 * sigma2));
            double modulation2 = 1.0 / Math.sqrt(Math.PI * 2 * sigma2_2) * Math.exp(-Math.pow(t - mu2, 2.0) / (2.0 * sigma2_2));
            double transmissionRate = seasonalModulationFloor + adjustedTransmissionRate * (modulation1 + modulation2);
            if (t >= 116.0 && t <= 119.0) {
                transmissionRate *= this.getAtt1();
            } else if (t >= 120.0 && t <= 127.0) {
                transmissionRate *= this.getAtt2();
            } else if (t >= 128.0 && t <= 132.0) {
                transmissionRate *= this.getAtt3();
            }
            ArrayList<Long> arrayList = this.writtedTimes;
            synchronized (arrayList) {
                if (!this.writtedTimes.contains(time.getTime().getTime())) {
                    try {
                        if (this.fw == null) {
                            this.fw = new FileWriter("beta.csv");
                        }
                        this.fw.write(String.valueOf(time.getTime().getTime()) + "," + transmissionRate + "\n");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.writtedTimes.add(time.getTime().getTime());
                }
            }
            if (!this.isFrequencyDependent()) {
                transmissionRate *= this.getTransmissionRateScaleFactor(diseaseLabel);
            }
            double effectiveInfectious = this.getNormalizedEffectiveInfectious(diseaseLabel.getNode(), diseaseLabel, currentSIR.getI(), StandardPackage.Literals.SI_LABEL_VALUE__I, StandardPackage.Literals.STANDARD_DISEASE_MODEL__CHARACTERISTIC_MIXING_DISTANCE, StandardPackage.Literals.STANDARD_DISEASE_MODEL__ROAD_NETWORK_INFECTIOUS_PROPORTION);
            double numberOfInfectedToRecovered = adjustedRecoveryRate * currentSIR.getI();
            double numberOfRecoveredToSusceptible = adjustedImmunityLossRate * currentSIR.getR();
            double numberOfSusceptibleToInfected = 0.0;
            numberOfSusceptibleToInfected = this.getNonLinearityCoefficient() != 1.0 && effectiveInfectious >= 0.0 ? transmissionRate * currentSIR.getS() * Math.pow(effectiveInfectious, this.getNonLinearityCoefficient()) : transmissionRate * currentSIR.getS() * effectiveInfectious;
            double deltaS = numberOfRecoveredToSusceptible - numberOfSusceptibleToInfected;
            double deltaI = numberOfSusceptibleToInfected - numberOfInfectedToRecovered;
            double deltaR = numberOfInfectedToRecovered - numberOfRecoveredToSusceptible;
            SIRLabelValueImpl ret = (SIRLabelValueImpl)deltaValue;
            ret.setS(deltaS);
            ret.setI(deltaI);
            ret.setIncidence(numberOfSusceptibleToInfected);
            ret.setR(deltaR);
            ret.setDiseaseDeaths(0.0);
            this.computeAdditionalDeltasAndExchanges(ilabel, time, t, timeDelta);
            ++_i;
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 28: {
                return this.getSigma2_2();
            }
            case 29: {
                return this.getAtt1();
            }
            case 30: {
                return this.getAtt2();
            }
            case 31: {
                return this.getAtt3();
            }
            case 32: {
                return this.getAtt4();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 28: {
                this.setSigma2_2((Double)newValue);
                return;
            }
            case 29: {
                this.setAtt1((Double)newValue);
                return;
            }
            case 30: {
                this.setAtt2((Double)newValue);
                return;
            }
            case 31: {
                this.setAtt3((Double)newValue);
                return;
            }
            case 32: {
                this.setAtt4((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 28: {
                this.setSigma2_2(100.0);
                return;
            }
            case 29: {
                this.setAtt1(1.0);
                return;
            }
            case 30: {
                this.setAtt2(1.0);
                return;
            }
            case 31: {
                this.setAtt3(1.0);
                return;
            }
            case 32: {
                this.setAtt4(1.0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 28: {
                return this.sigma2_2 != 100.0;
            }
            case 29: {
                return this.att1 != 1.0;
            }
            case 30: {
                return this.att2 != 1.0;
            }
            case 31: {
                return this.att3 != 1.0;
            }
            case 32: {
                return this.att4 != 1.0;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (sigma2_2: ");
        result.append(this.sigma2_2);
        result.append(", att1: ");
        result.append(this.att1);
        result.append(", att2: ");
        result.append(this.att2);
        result.append(", att3: ");
        result.append(this.att3);
        result.append(", att4: ");
        result.append(this.att4);
        result.append(')');
        return result.toString();
    }
}

