/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.analysis.Activator;
import org.eclipse.stem.analysis.AnalysisFactory;
import org.eclipse.stem.analysis.DiseaseType;
import org.eclipse.stem.analysis.LogInitializationException;
import org.eclipse.stem.analysis.impl.AnalysisFactoryImpl;
import org.eclipse.stem.analysis.impl.ReferenceScenarioDataMapImpl;
import org.eclipse.stem.core.Utility;
import org.eclipse.stem.core.model.Decorator;

public class CSVscenarioLoader {
    private String directory = "";
    public static final String S_TYPE = "S";
    public static final String E_TYPE = "E";
    public static final String I_TYPE = "I";
    public static final String R_TYPE = "R";
    public static final String INCIDENCE_TYPE = "Incidence";
    public static final String COUNT_TYPE = "Count";
    public static final String BIRTHS_TYPE = "Births";
    public static final String DEATHS_TYPE = "Deaths";
    public static final Set<String> S_KEY_SET = new HashSet<String>();
    public static final Set<String> E_KEY_SET = new HashSet<String>();
    public static final Set<String> I_KEY_SET = new HashSet<String>();
    public static final Set<String> R_KEY_SET = new HashSet<String>();
    public static final Set<String> COUNT_KEY_SET = new HashSet<String>();
    public static final Set<String> BIRTHS_KEY_SET = new HashSet<String>();
    public static final Set<String> DEATHS_KEY_SET = new HashSet<String>();
    public static final String UNKNOWN_POP_IDENTIFIER_KEY = "";
    public static final Set<String> INCIDENCE_KEY_SET = new HashSet<String>();
    public static final String POP_COUNT_KEY = "Population Count";
    public static final String PLATFORM = "platform:";
    public static final String FILE = "file:";
    public static final String ID_DISEASE_MODEL_EXTENSION_POINT = "org.eclipse.stem.diseasemodels.diseasemodel";
    public static final String ID_POPULATION_MODEL_EXTENSION_POINT = "org.eclipse.stem.populationodels.populationmodel";
    public static final String ID_CLASS = "class";
    public static final String CLASSDEF_ELEMENT = "classdef";
    public static final String DECORATOR_RUNPARAM_COLUMN_HEADER = "decorator";
    public static final String IO_EXCEPTION_ERROR_MSG = "CVSscenarioLoader: IOException error!";
    public static final String NO_FILE_MSG = "CVSscenarioLoader: Cannot find FILE: ";
    public static final String NO_DIR_MSG = "CVSscenarioLoader: Cannot find DIRECTORY: ";
    public static final String UNKNOWN_DISEASE_MSG = "CVSscenarioLoader: Disease type not recognized in directory: ";
    public static final String FORMAT_ERR_MSG = "CVSscenarioLoader: Mismatch between columns and values in run parameter file: ";
    public static final String POPULATION_NOT_FOUND = "Population not found: ";
    private static final String CSV_EXTENSION = ".csv";
    protected Map<String, List<File>> csvDataFiles = new HashMap<String, List<File>>();
    private final Map<String, String> runParameters = new HashMap<String, String>();
    private Decorator decorator = null;
    private List<String> populationIdentifiers;
    public static final String RUN_PARAMETER_FILE_NAME = "runparameters.csv";
    public static final String RUN_PARAMETER_FILE_NAME_OLD = "runparamters.csv";
    public static final String DECORATOR_FILE_NAME = "decorator.XMI";
    private AnalysisFactory aFactory = new AnalysisFactoryImpl();

    public CSVscenarioLoader(String diseaseDirectory) throws LogInitializationException {
        CSVscenarioLoader.clear();
        this.directory = diseaseDirectory;
        this.csvDataFiles = this.getDataFiles();
    }

    public CSVscenarioLoader() {
        CSVscenarioLoader.clear();
    }

    public static void clear() {
        S_KEY_SET.clear();
        E_KEY_SET.clear();
        I_KEY_SET.clear();
        R_KEY_SET.clear();
        INCIDENCE_KEY_SET.clear();
        BIRTHS_KEY_SET.clear();
        DEATHS_KEY_SET.clear();
        COUNT_KEY_SET.clear();
    }

    private Map<String, List<File>> getDataFiles() throws LogInitializationException {
        HashMap<String, List<File>> dataFileMap = new HashMap<String, List<File>>();
        URL fURL = null;
        File dir = null;
        if (this.directory.startsWith(PLATFORM) || this.directory.startsWith(FILE)) {
            try {
                URL inURL = new URL(this.directory);
                fURL = FileLocator.toFileURL((URL)inURL);
            }
            catch (Exception mue) {
                mue.printStackTrace();
            }
            dir = new File(fURL.getFile());
        } else {
            dir = new File(this.directory);
        }
        if (!dir.exists() || !dir.isDirectory()) {
            throw new LogInitializationException(NO_FILE_MSG + dir);
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (!f.isHidden()) {
                if (this.isDataFile(f)) {
                    if (dataFileMap.get(UNKNOWN_POP_IDENTIFIER_KEY) == null) {
                        dataFileMap.put(UNKNOWN_POP_IDENTIFIER_KEY, new ArrayList());
                    }
                    ((List)dataFileMap.get(UNKNOWN_POP_IDENTIFIER_KEY)).add(f);
                } else if (this.isRunParameterFile(f)) {
                    this.readRunParameters(f);
                } else if (this.isDecoratorFile(f)) {
                    this.readDecoratorFile(f);
                } else if (f.isDirectory()) {
                    String pop_id = f.getName();
                    List<File> dataFiles = this.getDataFilesForPopulation(f);
                    if (this.populationIdentifiers == null) {
                        this.populationIdentifiers = new ArrayList<String>();
                    }
                    this.populationIdentifiers.add(pop_id);
                    dataFileMap.put(pop_id, dataFiles);
                }
            }
            ++i;
        }
        if (dataFileMap.size() == 0) {
            throw new LogInitializationException(NO_DIR_MSG + this.directory);
        }
        return dataFileMap;
    }

    private List<File> getDataFilesForPopulation(File dir) throws LogInitializationException {
        ArrayList<File> result = new ArrayList<File>();
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (this.isDataFile(f)) {
                result.add(f);
            }
            ++i;
        }
        if (result.size() == 0) {
            throw new LogInitializationException(NO_DIR_MSG + dir);
        }
        return result;
    }

    public static boolean validate(String directory) {
        File file = new File(directory);
        return file.exists();
    }

    private boolean isDataFile(File file) {
        boolean retVal = true;
        String name = file.getName();
        if (name.indexOf(RUN_PARAMETER_FILE_NAME) >= 0 || name.indexOf(RUN_PARAMETER_FILE_NAME_OLD) >= 0) {
            retVal = false;
        }
        if (name.indexOf(CSV_EXTENSION) < 0) {
            retVal = false;
        }
        return retVal;
    }

    private boolean isRunParameterFile(File file) {
        boolean retVal = false;
        String name = file.getName();
        if (name.indexOf(RUN_PARAMETER_FILE_NAME) >= 0 || name.indexOf(RUN_PARAMETER_FILE_NAME_OLD) >= 0) {
            retVal = true;
        }
        return retVal;
    }

    private boolean isDecoratorFile(File file) {
        boolean retVal = false;
        String name = file.getName();
        if (name.indexOf(DECORATOR_FILE_NAME) >= 0) {
            retVal = true;
        }
        return retVal;
    }

    private void readRunParameters(File file) {
        block23: {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(file));
                if (reader == null) break block23;
                String buffer = null;
                int line = 0;
                String[] headerTokens = null;
                String[] valueTokens = null;
                while (!CSVscenarioLoader.EOF(buffer = reader.readLine())) {
                    if (line == 0) {
                        headerTokens = buffer.split(",");
                    } else {
                        valueTokens = buffer.split(",");
                    }
                    ++line;
                }
                if (valueTokens.length != headerTokens.length) {
                    Activator.logError(FORMAT_ERR_MSG, new Exception());
                    return;
                }
                try {
                    int i = 0;
                    while (i < valueTokens.length) {
                        this.runParameters.put(headerTokens[i], valueTokens[i]);
                        ++i;
                    }
                }
                catch (FileNotFoundException fnfe) {
                    Activator.logError(NO_FILE_MSG, fnfe);
                }
                catch (IOException ioe) {
                    Activator.logError(IO_EXCEPTION_ERROR_MSG, ioe);
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void readDecoratorFile(File file) {
        URI readURI = URI.createFileURI((String)file.getAbsolutePath());
        this.setDecorator((Decorator)Utility.getIdentifiable((URI)readURI));
    }

    public Decorator getDecorator() {
        return this.decorator;
    }

    public void setDecorator(Decorator decorator) {
        this.decorator = decorator;
    }

    public List<String> getPopulationIdentifiers() {
        return this.populationIdentifiers;
    }

    public static DiseaseType getDiseaseType() {
        DiseaseType type = S_KEY_SET.size() >= 1 && E_KEY_SET.size() >= 1 && I_KEY_SET.size() >= 1 && R_KEY_SET.size() >= 1 ? DiseaseType.SEIR : (S_KEY_SET.size() >= 1 && I_KEY_SET.size() >= 1 && R_KEY_SET.size() >= 1 ? DiseaseType.SIR : (S_KEY_SET.size() >= 1 && I_KEY_SET.size() >= 1 ? DiseaseType.SI : (BIRTHS_KEY_SET.size() >= 1 && DEATHS_KEY_SET.size() >= 1 && COUNT_KEY_SET.size() >= 1 ? DiseaseType.STANDARD_POPULATION : DiseaseType.OTHER)));
        return type;
    }

    public static void registerKey(String state) {
        if (state.indexOf(INCIDENCE_TYPE) >= 0) {
            INCIDENCE_KEY_SET.add(state);
            return;
        }
        if (state.startsWith(BIRTHS_TYPE)) {
            BIRTHS_KEY_SET.add(state);
        } else if (state.startsWith(DEATHS_TYPE)) {
            DEATHS_KEY_SET.add(state);
        } else if (state.startsWith(COUNT_TYPE)) {
            COUNT_KEY_SET.add(state);
        } else if (state.startsWith(S_TYPE)) {
            S_KEY_SET.add(state);
        } else if (state.startsWith(E_TYPE)) {
            E_KEY_SET.add(state);
        } else if (state.startsWith(I_TYPE)) {
            I_KEY_SET.add(state);
        } else if (state.startsWith(R_TYPE)) {
            R_KEY_SET.add(state);
        }
    }

    public ReferenceScenarioDataMapImpl parseAllFiles(Set<String> filterSet, String populationId, int resolution) throws LogInitializationException {
        ReferenceScenarioDataMapImpl scenarioDataMap = (ReferenceScenarioDataMapImpl)this.aFactory.createReferenceScenarioDataMap();
        if (!this.csvDataFiles.containsKey(populationId)) {
            throw new LogInitializationException(POPULATION_NOT_FOUND + populationId);
        }
        List<File> fileList = this.csvDataFiles.get(populationId);
        int i = 0;
        while (i < fileList.size()) {
            File f = fileList.get(i);
            String name = f.getName();
            if (!f.getName().startsWith(".")) {
                int _idx = name.lastIndexOf(95);
                int dotidx = name.lastIndexOf(46);
                if (_idx >= 0 && dotidx >= 0 && dotidx >= _idx) {
                    String state = name.substring(0, _idx);
                    CSVscenarioLoader.registerKey(state);
                    int res = Integer.parseInt(name.substring(_idx + 1, dotidx));
                    if (resolution == -1 || res == resolution) {
                        this.processAndFilterFiles(filterSet, scenarioDataMap, state, f);
                    }
                }
            }
            ++i;
        }
        scenarioDataMap.setReferenceDirectory(this.directory);
        scenarioDataMap.setPopulationIdentifier(populationId);
        DiseaseType type = CSVscenarioLoader.getDiseaseType();
        scenarioDataMap.setType(type, S_KEY_SET, E_KEY_SET, I_KEY_SET, R_KEY_SET, INCIDENCE_KEY_SET);
        return scenarioDataMap;
    }

    public ReferenceScenarioDataMapImpl parseAllFiles(String populationId, int resolution) throws LogInitializationException {
        ReferenceScenarioDataMapImpl scenarioDataMap = (ReferenceScenarioDataMapImpl)this.aFactory.createReferenceScenarioDataMap();
        if (!this.csvDataFiles.containsKey(populationId)) {
            throw new LogInitializationException(POPULATION_NOT_FOUND + populationId);
        }
        ArrayList<String> states = new ArrayList<String>();
        List<File> fileList = this.csvDataFiles.get(populationId);
        int i = 0;
        while (i < fileList.size()) {
            File f = fileList.get(i);
            String name = f.getName();
            if (!name.startsWith(".")) {
                int _idx = name.lastIndexOf(95);
                int dotidx = name.lastIndexOf(46);
                if (_idx >= 0 && dotidx >= 0 && dotidx >= _idx) {
                    String state = name.substring(0, _idx);
                    if (!states.contains(state)) {
                        states.add(state);
                    }
                    CSVscenarioLoader.registerKey(state);
                    int res = Integer.parseInt(name.substring(_idx + 1, dotidx));
                    if (resolution == -1 || res == resolution) {
                        this.processFile(scenarioDataMap, state, f);
                    }
                }
            }
            ++i;
        }
        scenarioDataMap.setReferenceDirectory(this.directory);
        scenarioDataMap.setPopulationIdentifier(populationId);
        DiseaseType type = CSVscenarioLoader.getDiseaseType();
        scenarioDataMap.setType(type, S_KEY_SET, E_KEY_SET, I_KEY_SET, R_KEY_SET, INCIDENCE_KEY_SET);
        return scenarioDataMap;
    }

    public ReferenceScenarioDataMapImpl parseAllFiles() throws LogInitializationException {
        return this.parseAllFiles(UNKNOWN_POP_IDENTIFIER_KEY, -1);
    }

    public DiseaseType getType(String populationId) throws LogInitializationException {
        ArrayList<String> states = new ArrayList<String>();
        if (!this.csvDataFiles.containsKey(populationId)) {
            throw new LogInitializationException(POPULATION_NOT_FOUND + populationId);
        }
        List<File> fileList = this.csvDataFiles.get(populationId);
        int i = 0;
        while (i < fileList.size()) {
            File f = fileList.get(i);
            String name = f.getName();
            int _idx = name.lastIndexOf(95);
            int dotidx = name.lastIndexOf(46);
            if (_idx >= 0 && dotidx >= 0 && dotidx >= _idx) {
                String state = name.substring(0, _idx);
                if (!states.contains(state)) {
                    states.add(state);
                }
                CSVscenarioLoader.registerKey(state);
            }
            ++i;
        }
        DiseaseType type = CSVscenarioLoader.getDiseaseType();
        return type;
    }

    public int getMaxResolution(String populationId) {
        int result = -1;
        List<File> fileList = this.csvDataFiles.get(populationId);
        if (fileList == null) {
            return result;
        }
        int i = 0;
        while (i < fileList.size()) {
            int res;
            File f = fileList.get(i);
            String name = f.getName();
            int _idx = name.lastIndexOf(95);
            int dotidx = name.lastIndexOf(46);
            if (_idx >= 0 && dotidx >= 0 && dotidx >= _idx && result < (res = Integer.parseInt(name.substring(_idx + 1, dotidx)))) {
                result = res;
            }
            ++i;
        }
        return result;
    }

    public void processFile(ReferenceScenarioDataMapImpl dataMap, String state, File file) throws LogInitializationException {
        BufferedReader reader = null;
        try {
            try {
                String record;
                ArrayList<String> headerElements = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(file));
                String header = reader.readLine();
                if (header != null) {
                    StringTokenizer st = new StringTokenizer(header, ",");
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken().trim();
                        headerElements.add(val);
                    }
                }
                int numColumns = headerElements.size();
                int i = 0;
                while (i < numColumns) {
                    String key = (String)headerElements.get(i);
                    if (!key.equals("iteration") && !key.equals("time")) {
                        HashMap<String, List<String>> data;
                        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance result = null;
                        if (!dataMap.containsLocation(key)) {
                            data = new HashMap();
                            ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = dataMap;
                            referenceScenarioDataMapImpl.getClass();
                            result = referenceScenarioDataMapImpl.new ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance(data, dataMap);
                            dataMap.addInstance(key, result);
                        } else {
                            result = dataMap.getLocation(key);
                            data = result.getInstance();
                        }
                        data.put(state, new ArrayList());
                    }
                    ++i;
                }
                while ((record = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record, ",");
                    int tcount = 0;
                    while (st.hasMoreTokens() && tcount < headerElements.size()) {
                        String val = st.nextToken();
                        String key = (String)headerElements.get(tcount);
                        if (key.equals("iteration") || key.equals("time")) {
                            ++tcount;
                            continue;
                        }
                        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance result = dataMap.getLocation(key);
                        Map<String, List<String>> data = result.getInstance();
                        data.get(state).add(val.trim());
                        ++tcount;
                    }
                }
            }
            catch (IOException e) {
                Activator.logError(IO_EXCEPTION_ERROR_MSG, e);
                throw new LogInitializationException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public Set<String> getLocations(String populationId, int resolution) throws LogInitializationException {
        HashSet<String> locations = new HashSet<String>();
        ArrayList<String> states = new ArrayList<String>();
        if (!this.csvDataFiles.containsKey(populationId)) {
            throw new LogInitializationException(POPULATION_NOT_FOUND + populationId);
        }
        List<File> fileList = this.csvDataFiles.get(populationId);
        int i = 0;
        while (i < fileList.size()) {
            File file = fileList.get(i);
            String name = file.getName();
            int _idx = name.lastIndexOf(95);
            int dotidx = name.lastIndexOf(46);
            if (_idx >= 0 && dotidx >= 0 && dotidx >= _idx) {
                String state = name.substring(0, _idx);
                if (!states.contains(state)) {
                    states.add(state);
                }
                int res = Integer.parseInt(name.substring(_idx + 1, dotidx));
                if (resolution == -1 || res == resolution) {
                    BufferedReader reader = null;
                    try {
                        try {
                            ArrayList<String> headerElements = new ArrayList<String>();
                            reader = new BufferedReader(new FileReader(file));
                            String header = reader.readLine();
                            if (header != null) {
                                StringTokenizer st = new StringTokenizer(header, ",");
                                while (st.hasMoreTokens()) {
                                    String val = st.nextToken().trim();
                                    headerElements.add(val);
                                }
                            }
                            int numColumns = headerElements.size();
                            int ii = 0;
                            while (ii < numColumns) {
                                String key = (String)headerElements.get(ii);
                                if (!key.equals("iteration") && !key.equals("time")) {
                                    locations.add(key);
                                }
                                ++ii;
                            }
                        }
                        catch (IOException e) {
                            Activator.logError(IO_EXCEPTION_ERROR_MSG, e);
                            throw new LogInitializationException(e);
                        }
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            ++i;
        }
        return locations;
    }

    public void processAndFilterFiles(Set<String> locationFilter, ReferenceScenarioDataMapImpl dataMap, String state, File file) throws LogInitializationException {
        BufferedReader reader = null;
        try {
            try {
                String record;
                ArrayList<String> headerElements = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(file));
                String header = reader.readLine();
                if (header != null) {
                    StringTokenizer st = new StringTokenizer(header, ",");
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken().trim();
                        headerElements.add(val);
                    }
                }
                int numColumns = headerElements.size();
                int i = 0;
                while (i < numColumns) {
                    String key = (String)headerElements.get(i);
                    if (!(locationFilter != null && !locationFilter.contains(key) || key.equals("iteration") || key.equals("time"))) {
                        HashMap<String, List<String>> data;
                        ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance result = null;
                        if (!dataMap.containsLocation(key)) {
                            data = new HashMap();
                            ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = dataMap;
                            referenceScenarioDataMapImpl.getClass();
                            result = referenceScenarioDataMapImpl.new ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance(data, dataMap);
                            dataMap.addInstance(key, result);
                        } else {
                            result = dataMap.getLocation(key);
                            data = result.getInstance();
                        }
                        data.put(state, new ArrayList());
                    }
                    ++i;
                }
                while ((record = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record, ",");
                    int tcount = 0;
                    while (st.hasMoreTokens() && tcount < headerElements.size()) {
                        String val = st.nextToken();
                        String key = (String)headerElements.get(tcount);
                        if (locationFilter == null || locationFilter.contains(key)) {
                            if (key.equals("iteration") || key.equals("time")) {
                                ++tcount;
                                continue;
                            }
                            ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance result = dataMap.getLocation(key);
                            Map<String, List<String>> data = result.getInstance();
                            data.get(state).add(val.trim());
                        }
                        ++tcount;
                    }
                }
            }
            catch (IOException e) {
                Activator.logError(IO_EXCEPTION_ERROR_MSG, e);
                throw new LogInitializationException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
    }

    public ReferenceScenarioDataMapImpl parseAggregateFile(String file) throws LogInitializationException {
        ReferenceScenarioDataMapImpl scenarioDataMap = (ReferenceScenarioDataMapImpl)this.aFactory.createReferenceScenarioDataMap();
        File f = new File(file);
        String name = f.getName();
        int idx = name.indexOf(".");
        String id = name.substring(0, idx);
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        BufferedReader reader = null;
        try {
            try {
                String record;
                ArrayList<String> headerElements = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(file));
                String header = reader.readLine();
                if (header != null) {
                    StringTokenizer st = new StringTokenizer(header);
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        headerElements.add(val.trim());
                    }
                }
                int numColumns = headerElements.size();
                int i = 0;
                while (i < numColumns) {
                    String key = (String)headerElements.get(i);
                    data.put(key, new ArrayList());
                    ++i;
                }
                while ((record = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record);
                    int tcount = 0;
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        String key = (String)headerElements.get(tcount);
                        data.get(key).add(val.trim());
                        ++tcount;
                    }
                }
            }
            catch (IOException e) {
                Activator.logError(IO_EXCEPTION_ERROR_MSG, e);
                throw new LogInitializationException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        ReferenceScenarioDataMapImpl referenceScenarioDataMapImpl = scenarioDataMap;
        referenceScenarioDataMapImpl.getClass();
        scenarioDataMap.addInstance(id, referenceScenarioDataMapImpl.new ReferenceScenarioDataMapImpl.ReferenceScenarioDataInstance(data, scenarioDataMap));
        return scenarioDataMap;
    }

    public Map<String, List<String>> processIncidenceFile(String fileName) throws LogInitializationException {
        File file = new File(fileName);
        HashMap<String, List<String>> data = new HashMap<String, List<String>>();
        BufferedReader reader = null;
        try {
            try {
                String record;
                ArrayList<String> headerElements = new ArrayList<String>();
                reader = new BufferedReader(new FileReader(file));
                String header = reader.readLine();
                if (header != null) {
                    StringTokenizer st = new StringTokenizer(header);
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        headerElements.add(val.trim());
                    }
                }
                int numColumns = headerElements.size();
                int i = 0;
                while (i < numColumns) {
                    String key = (String)headerElements.get(i);
                    data.put(key, new ArrayList());
                    ++i;
                }
                while ((record = reader.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record);
                    int tcount = 0;
                    while (st.hasMoreTokens()) {
                        String val = st.nextToken(",");
                        String key = (String)headerElements.get(tcount);
                        data.get(key).add(val.trim());
                        ++tcount;
                    }
                }
            }
            catch (IOException e) {
                Activator.logError(IO_EXCEPTION_ERROR_MSG, e);
                throw new LogInitializationException(e);
            }
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return data;
    }

    protected static boolean EOF(String buffer) {
        return buffer == null || buffer.length() == 0;
    }

    public Map<String, String> getRunParameters() {
        return this.runParameters;
    }

    public static Set<String> getsKeySet() {
        return S_KEY_SET;
    }

    public static Set<String> geteKeySet() {
        return E_KEY_SET;
    }

    public static Set<String> getiKeySet() {
        return I_KEY_SET;
    }

    public static Set<String> getrKeySet() {
        return R_KEY_SET;
    }

    public static Set<String> getIncidenceKeySet() {
        return INCIDENCE_KEY_SET;
    }
}

