/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;

public class TracingOptionsManager {
    private Properties template;

    private Properties createTemplate() {
        IPluginModelBase[] models;
        Properties temp = new Properties();
        IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getAllModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            this.addToTemplate(temp, model);
            ++n2;
        }
        return temp;
    }

    private void addToTemplate(Properties temp, IPluginModelBase model) {
        Properties modelOptions = this.getOptions(model);
        if (modelOptions != null) {
            temp.putAll((Map<?, ?>)modelOptions);
        }
    }

    public synchronized Hashtable<String, Object> getTemplateTable(String pluginId) {
        if (this.template == null) {
            this.template = this.createTemplate();
        }
        Hashtable<String, Object> defaults = new Hashtable<String, Object>();
        Enumeration<Object> keys = this.template.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            if (!this.belongsTo(key, pluginId)) continue;
            defaults.put(key, this.template.get(key));
        }
        return defaults;
    }

    private boolean belongsTo(String option, String pluginId) {
        Path path = new Path(option);
        String firstSegment = path.segment(0);
        return pluginId.equalsIgnoreCase(firstSegment);
    }

    public Properties getTracingOptions(Map<String, String> storedOptions) {
        Properties defaults = this.getTracingTemplateCopy();
        if (storedOptions != null) {
            Iterator<String> iter = storedOptions.keySet().iterator();
            while (iter.hasNext()) {
                String key = iter.next().toString();
                if (!defaults.containsKey(key)) continue;
                defaults.setProperty(key, storedOptions.get(key));
            }
        }
        return defaults;
    }

    public synchronized Properties getTracingTemplateCopy() {
        if (this.template == null) {
            this.template = this.createTemplate();
        }
        return (Properties)this.createTemplate().clone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isTraceable(IPluginModelBase model) {
        ZipFile jarFile;
        InputStream stream;
        block24: {
            File pluginLocation;
            block23: {
                String location = model.getInstallLocation();
                if (location == null) {
                    return false;
                }
                pluginLocation = new File(location);
                stream = null;
                jarFile = null;
                if (!pluginLocation.isDirectory()) break block23;
                boolean bl = new File(pluginLocation, ".options").exists();
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (jarFile == null) return bl;
                    jarFile.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
            try {
                jarFile = new ZipFile(pluginLocation, 1);
                ZipEntry manifestEntry = jarFile.getEntry(".options");
                if (manifestEntry == null) break block24;
                stream = jarFile.getInputStream(manifestEntry);
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (jarFile == null) return stream != null;
                    jarFile.close();
                    return stream != null;
                }
                catch (IOException iOException) {}
                return stream != null;
            }
            catch (IOException iOException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                        if (jarFile == null) throw throwable;
                        jarFile.close();
                        throw throwable;
                    }
                    catch (IOException iOException2) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    if (jarFile == null) return stream != null;
                    jarFile.close();
                    return stream != null;
                }
                catch (IOException iOException3) {}
                return stream != null;
            }
        }
        try {
            if (stream != null) {
                stream.close();
            }
            if (jarFile == null) return stream != null;
            jarFile.close();
            return stream != null;
        }
        catch (IOException iOException) {}
        return stream != null;
    }

    public synchronized void reset() {
        this.template = null;
    }

    private void save(String fileName, Properties properties) {
        FileOutputStream stream = null;
        try {
            try {
                stream = new FileOutputStream(fileName);
                properties.store(stream, "Master Tracing Options");
                stream.flush();
            }
            catch (IOException e) {
                PDECore.logException(e);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    PDECore.logException(e2);
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        }
    }

    public void save(String filename, Map<String, String> map, HashSet<?> selected) {
        Properties properties = this.getTracingOptions(map);
        Enumeration<Object> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement().toString();
            Path path = new Path(key);
            if (path.segmentCount() >= 1 && selected.contains(path.segment(0).toString())) continue;
            properties.remove(key);
        }
        this.save(filename, properties);
    }

    public void save(String filename, Map<String, String> map) {
        this.save(filename, this.getTracingOptions(map));
    }

    private Properties getOptions(IPluginModelBase model) {
        block49: {
            String location = model.getInstallLocation();
            if (location == null) {
                return null;
            }
            try {
                File pluginLocation = new File(location);
                Properties modelOptions = new Properties();
                if (pluginLocation.isDirectory()) {
                    FileInputStream stream;
                    File file = new File(pluginLocation, ".options");
                    if (!file.exists()) break block49;
                    Throwable throwable = null;
                    Object var7_14 = null;
                    try {
                        stream = new FileInputStream(file);
                        try {
                            modelOptions.load(stream);
                        }
                        finally {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    throwable = null;
                    var7_14 = null;
                    try {
                        stream = new FileInputStream(file);
                        try {
                            this.loadComments(stream, modelOptions);
                        }
                        finally {
                            if (stream != null) {
                                ((InputStream)stream).close();
                            }
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    return modelOptions;
                }
                Throwable throwable = null;
                Object var6_12 = null;
                try (ZipFile jarFile = new ZipFile(pluginLocation, 1);){
                    InputStream stream;
                    ZipEntry manifestEntry = jarFile.getEntry(".options");
                    if (manifestEntry == null) break block49;
                    Throwable throwable4 = null;
                    Object var10_23 = null;
                    try {
                        stream = jarFile.getInputStream(manifestEntry);
                        try {
                            modelOptions.load(stream);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable4 == null) {
                            throwable4 = throwable5;
                        } else if (throwable4 != throwable5) {
                            throwable4.addSuppressed(throwable5);
                        }
                        throw throwable4;
                    }
                    throwable4 = null;
                    var10_23 = null;
                    try {
                        stream = jarFile.getInputStream(manifestEntry);
                        try {
                            this.loadComments(stream, modelOptions);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        if (throwable4 == null) {
                            throwable4 = throwable6;
                        } else if (throwable4 != throwable6) {
                            throwable4.addSuppressed(throwable6);
                        }
                        throw throwable4;
                    }
                    return modelOptions;
                }
                catch (Throwable throwable7) {
                    if (throwable == null) {
                        throwable = throwable7;
                    } else if (throwable != throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                PDECore.logException(e);
            }
        }
        return null;
    }

    private void loadComments(InputStream stream, Properties modelOptions) throws IOException {
        String prevComment = "";
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("#") || line.trim().isEmpty()) {
                    prevComment = String.valueOf(prevComment) + "\n" + line.trim();
                    continue;
                }
                if (prevComment.trim().isEmpty()) continue;
                int eq = line.indexOf(61);
                if (eq >= 0) {
                    String key = line.substring(0, eq).trim();
                    modelOptions.put("#" + key, prevComment);
                }
                prevComment = "";
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

