/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.repository.simple;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepository;
import org.eclipse.equinox.internal.p2.artifact.repository.simple.SimpleArtifactRepositoryIO;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactRepositoryFactory;
import org.eclipse.osgi.util.NLS;
import org.tukaani.xz.XZInputStream;

public class XZedSimpleArtifactRepositoryFactory
extends ArtifactRepositoryFactory {
    private static final String REPOSITORY_FILENAME = "artifacts.xml.xz";
    private static final String PROTOCOL_FILE = "file";

    public IArtifactRepository create(URI location, String name, String type, Map<String, String> properties) {
        return new SimpleArtifactRepository(this.getAgent(), name, location, properties);
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor) throws ProvisionException {
        return this.load(location, flags, monitor, true);
    }

    private File getLocalFile(URI location, IProgressMonitor monitor) throws IOException, ProvisionException {
        File localFile = null;
        URI xzLocation = URIUtil.append((URI)location, (String)REPOSITORY_FILENAME);
        if (PROTOCOL_FILE.equals(xzLocation.getScheme())) {
            localFile = URIUtil.toFile((URI)xzLocation);
            if (localFile.exists()) {
                return localFile;
            }
            String msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, msg, null));
        }
        CacheManager cache = (CacheManager)this.getAgent().getService(CacheManager.SERVICE_NAME);
        if (cache == null) {
            throw new IllegalArgumentException("Cache manager service not available");
        }
        localFile = cache.createCacheFromFile(URIUtil.append((URI)location, (String)REPOSITORY_FILENAME), monitor);
        if (localFile == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, Messages.repoMan_internalError, null));
        }
        return localFile;
    }

    public IArtifactRepository load(URI location, int flags, IProgressMonitor monitor, boolean acquireLock) throws ProvisionException {
        long time = 0L;
        if (Tracing.DEBUG_METADATA_PARSING) {
            Tracing.debug((String)("Restoring artifact repository " + location));
            time = -System.currentTimeMillis();
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)400);
        try {
            SimpleArtifactRepository result;
            XZInputStream descriptorStream;
            BufferedInputStream stream;
            block14: {
                File localFile = this.getLocalFile(location, (IProgressMonitor)sub.newChild(300));
                stream = new BufferedInputStream(new FileInputStream(localFile));
                descriptorStream = new XZInputStream((InputStream)stream);
                try {
                    sub.setWorkRemaining(100);
                    result = (SimpleArtifactRepository)new SimpleArtifactRepositoryIO(this.getAgent()).read(localFile.toURI(), (InputStream)descriptorStream, (IProgressMonitor)sub.newChild(100), acquireLock);
                    if (result == null || (flags & 1) <= 0 || result.isModifiable()) break block14;
                    this.safeClose((InputStream)descriptorStream);
                    this.safeClose(stream);
                    return null;
                }
                catch (Throwable throwable) {
                    String msg;
                    try {
                        this.safeClose((InputStream)descriptorStream);
                        this.safeClose(stream);
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1000, msg, (Throwable)e));
                    }
                    catch (IOException e) {
                        msg = NLS.bind((String)Messages.io_failedRead, (Object)location);
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", 1002, msg, (Throwable)e));
                    }
                }
            }
            result.initializeAfterLoad(location);
            if (Tracing.DEBUG_METADATA_PARSING) {
                Tracing.debug((String)("Restoring artifact repository time (ms): " + (time += System.currentTimeMillis())));
            }
            SimpleArtifactRepository simpleArtifactRepository = result;
            this.safeClose((InputStream)descriptorStream);
            this.safeClose(stream);
            return simpleArtifactRepository;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void safeClose(InputStream stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
    }
}

