/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.stem.model.codegen.CodeGenConstants;
import org.eclipse.stem.model.codegen.GeneratorUtils;
import org.eclipse.stem.model.codegen.ModelGeneratorDescriptors;
import org.eclipse.stem.model.codegen.STEMGenFeature;
import org.eclipse.stem.model.codegen.STEMGenPackage;
import org.eclipse.stem.model.codegen.descriptor.ModelGeneratorDescriptor;

public class STEMGenClass {
    private ModelGeneratorDescriptor descriptor;
    private GenClass genClass;

    public STEMGenClass(GenClass genClass) {
        this.genClass = genClass;
        this.descriptor = ModelGeneratorDescriptors.getInstance().getDescriptorForGenClass(genClass);
    }

    public static STEMGenClass get(GenClass genClass) {
        return new STEMGenClass(genClass);
    }

    public ModelGeneratorDescriptor getDescriptor() {
        return this.descriptor;
    }

    public STEMGenPackage getSTEMGenPackage() {
        return STEMGenPackage.get(this.genClass.getGenPackage());
    }

    public GenClass getGenClass() {
        return this.genClass;
    }

    public URI getIcon() {
        return this.descriptor.getIconURI();
    }

    public boolean isComputationalModel() {
        return GeneratorUtils.classExtends(this.genClass, CodeGenConstants.INTEGRATION_DECORATOR_DESCRIPTOR);
    }

    public boolean isIntegrationLabel() {
        return GeneratorUtils.classExtends(this.genClass, CodeGenConstants.INTEGRATION_LABEL_DESCRIPTOR);
    }

    public boolean isIntegrationLabelValue() {
        return GeneratorUtils.classExtends(this.genClass, CodeGenConstants.INTEGRATION_LABEL_VALUE_DESCRIPTOR);
    }

    public String getLabelValueClassName() {
        if (this.isIntegrationLabel()) {
            return String.valueOf(this.genClass.getName()) + "Value";
        }
        return null;
    }

    public String getLabelTypeURI() {
        if ("PopulationModel".equals(this.getComputationalModelType())) {
            return "URI_TYPE_DYNAMIC_POPULATION_LABEL";
        }
        return "URI_TYPE_DYNAMIC_DISEASE_LABEL";
    }

    public String getModelTypeClassName() {
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.genClass.getGenPackage(), this.descriptor.getBaseModel());
    }

    public String getComputationalModelType() {
        return this.getDescriptor().getModelType();
    }

    public String getExtensionPointName() {
        return this.getDescriptor().getExtensionPointId();
    }

    public List<STEMGenFeature> getSTEMGenFeatures() {
        ArrayList<STEMGenFeature> features = new ArrayList<STEMGenFeature>();
        for (GenFeature genFeature : this.genClass.getDeclaredGenFeatures()) {
            features.add(STEMGenFeature.get(genFeature, this.genClass));
        }
        return features;
    }

    public List<String> getPrimitiveAccessorTypes() {
        return STEMGenFeature.getPrimitiveAccessorTypes();
    }

    public String getPrimitiveGetterName(String primitive) {
        return STEMGenFeature.getPrimitiveAccessorName("eGet", primitive);
    }

    public String getPrimitiveSetterName(String primitive) {
        return STEMGenFeature.getPrimitiveAccessorName("eSet", primitive);
    }

    public boolean shouldGeneratePrimitiveAccessors(String primitiveType) {
        if (GeneratorUtils.classExtends(this.genClass, CodeGenConstants.PRIMITIVE_TYPE_OPERATIONS_DESCRIPTOR)) {
            for (GenFeature genFeature : this.genClass.getEGetGenFeatures()) {
                if (!genFeature.getImportedType(this.genClass).equals(primitiveType)) continue;
                return true;
            }
        }
        return false;
    }

    public static String getPrimitiveObjectName(String primitiveName) {
        if ("long".equals(primitiveName)) {
            return "Long";
        }
        if ("short".equals(primitiveName)) {
            return "Short";
        }
        if ("double".equals(primitiveName)) {
            return "Double";
        }
        if ("int".equals(primitiveName)) {
            return "Integer";
        }
        if ("byte".equals(primitiveName)) {
            return "Byte";
        }
        if ("float".equals(primitiveName)) {
            return "Float";
        }
        if ("boolean".equals(primitiveName)) {
            return "Boolean";
        }
        return primitiveName;
    }

    public String getDefaultStringProviderClassName() {
        return String.valueOf(this.getDefaultPropertyEditorClassName()) + "." + this.genClass.getName() + "PropertyStringProviderAdapter";
    }

    public String getDefaultPropertyEditorClassName() {
        return String.valueOf(this.getAdaptersPackageName()) + "." + this.genClass.getName() + "PropertyEditor";
    }

    public String getAdaptersPackageName() {
        return this.genClass.getGenPackage().getPresentationPackageName();
    }

    public String getDefaultStringProviderSuperClassName() {
        GenClass superClass = this.genClass.getBaseGenClass();
        GenPackage superGenPkg = superClass.getGenPackage();
        STEMGenPackage pkg = STEMGenPackage.get(superGenPkg);
        if (pkg.usesSTEMGenerator()) {
            STEMGenClass superGenClass = STEMGenClass.get(superClass);
            return superGenClass.getStringProviderClassName();
        }
        return pkg.getDefaultStringProviderClassName();
    }

    public String getDefaultPropertyEditorSuperClassName() {
        GenClass superClass = this.genClass.getBaseGenClass();
        GenPackage superGenPkg = superClass.getGenPackage();
        STEMGenPackage pkg = STEMGenPackage.get(superGenPkg);
        if (pkg.usesSTEMGenerator()) {
            STEMGenClass superGenClass = STEMGenClass.get(superClass);
            return superGenClass.getPropertyEditorClassName();
        }
        return pkg.getDefaultPropertyEditorClassName();
    }

    public String getStringProviderClassName() {
        String editorClass;
        EAnnotation annotation = this.getAdaptersAnnotation();
        if (annotation != null && !GeneratorUtils.isNullOrEmpty(editorClass = (String)annotation.getDetails().get((Object)"stringProviderClass"))) {
            if (editorClass.indexOf(46) > -1) {
                return editorClass;
            }
            return String.valueOf(this.genClass.getGenPackage().getPresentationPackageName()) + "." + editorClass;
        }
        return this.getDefaultStringProviderClassName();
    }

    public String getStringProviderSuperClassName() {
        String editorClass;
        EAnnotation annotation = this.getAdaptersAnnotation();
        if (annotation != null && !GeneratorUtils.isNullOrEmpty(editorClass = (String)annotation.getDetails().get((Object)"stringProviderSuperClass"))) {
            if (editorClass.indexOf(46) > -1) {
                return editorClass;
            }
            return String.valueOf(this.genClass.getGenPackage().getPresentationPackageName()) + "." + editorClass;
        }
        return this.getDefaultStringProviderSuperClassName();
    }

    public String getPropertyEditorClassName() {
        String editorClass;
        EAnnotation annotation = this.getAdaptersAnnotation();
        if (annotation != null && !GeneratorUtils.isNullOrEmpty(editorClass = (String)annotation.getDetails().get((Object)"propertyEditorClass"))) {
            if (editorClass.indexOf(46) > -1) {
                return editorClass;
            }
            return String.valueOf(this.genClass.getGenPackage().getPresentationPackageName()) + "." + editorClass;
        }
        return this.getDefaultPropertyEditorClassName();
    }

    public String getPropertyEditorSuperClassName() {
        String editorClass;
        String className = null;
        EAnnotation annotation = this.getAdaptersAnnotation();
        if (annotation != null && !GeneratorUtils.isNullOrEmpty(editorClass = (String)annotation.getDetails().get((Object)"propertyEditorSuperClass"))) {
            className = editorClass.indexOf(46) > -1 ? editorClass : String.valueOf(this.genClass.getGenPackage().getPresentationPackageName()) + "." + editorClass;
        }
        if (className == null) {
            className = this.getDefaultPropertyEditorSuperClassName();
        }
        return className;
    }

    private EAnnotation getAdaptersAnnotation() {
        return this.genClass.getEcoreClass().getEAnnotation("http:///org/eclipse/stem/modelgen/model/adapters");
    }

    private EAnnotation getLabelAnnotation() {
        return this.genClass.getEcoreClass().getEAnnotation("http:///org/eclipse/stem/modelgen/model/label");
    }

    private EAnnotation getLabelValueAnnotation() {
        return this.genClass.getEcoreClass().getEAnnotation("http:///org/eclipse/stem/modelgen/model/labelvalue");
    }

    public String getDefaultModelLabelType() {
        GenClass gc = this.getDefaultLabelGenClass();
        return String.valueOf(gc.getGenPackage().getInterfacePackageName()) + "." + gc.getName();
    }

    public String getDefaultModelLabelValueType() {
        GenClass gc = this.getDefaultLabelValueGenClass();
        return String.valueOf(gc.getGenPackage().getInterfacePackageName()) + "." + gc.getName();
    }

    public GenClass getDefaultLabelGenClass() {
        return GeneratorUtils.getDefaultEntryFromMap(this.getLabelGenClasses(), "*");
    }

    public GenClass getDefaultLabelValueGenClass() {
        return GeneratorUtils.getDefaultEntryFromMap(this.getLabelValueGenClasses(), "*");
    }

    public Map<String, GenClass> getLabelGenClasses() {
        EAnnotation annotation = this.getLabelAnnotation();
        if (annotation == null) {
            return null;
        }
        return GeneratorUtils.getGenClassesForAnnotations(this.genClass, annotation);
    }

    public Map<String, GenClass> getLabelValueGenClasses() {
        EAnnotation annotation = this.getLabelValueAnnotation();
        if (annotation == null) {
            return null;
        }
        return GeneratorUtils.getGenClassesForAnnotations(this.genClass, annotation);
    }

    public String getLabelBaseType() {
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.genClass.getGenPackage(), this.getDescriptor().getBaseLabel());
    }

    public String getLabelValueBaseType() {
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.genClass.getGenPackage(), this.getDescriptor().getBaseLabelValue());
    }

    public String getPropertyEditorAdapterBaseType() {
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.getDescriptor().getPropertyEditorAdapter());
    }

    public String getPropertyEditorBaseType() {
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.getDescriptor().getPropertyEditor());
    }

    public String getPropertyEditorCompositeBaseType() {
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.getDescriptor().getPropertyEditorComposite());
    }

    public String getLabelRelativeValueProviderSuperClassName() {
        String labelRVPClass;
        EAnnotation annotation = this.getAdaptersAnnotation();
        if (annotation != null && !GeneratorUtils.isNullOrEmpty(labelRVPClass = (String)annotation.getDetails().get((Object)"labelRelativeValueProviderSuperClass"))) {
            if (labelRVPClass.indexOf(46) > -1) {
                return labelRVPClass;
            }
            return String.valueOf(this.genClass.getGenPackage().getPresentationPackageName()) + "." + labelRVPClass;
        }
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.getDescriptor().getLabelRelativeValueProvider());
    }

    public String getLabelValueRelativeValueProviderSuperClassName() {
        String labelRVPClass;
        EAnnotation annotation = this.getAdaptersAnnotation();
        if (annotation != null && !GeneratorUtils.isNullOrEmpty(labelRVPClass = (String)annotation.getDetails().get((Object)"labelValueRelativeValueProviderSuperClass"))) {
            if (labelRVPClass.indexOf(46) > -1) {
                return labelRVPClass;
            }
            return String.valueOf(this.genClass.getGenPackage().getPresentationPackageName()) + "." + labelRVPClass;
        }
        return GeneratorUtils.getQualifiedJavaNameForDescriptor(this.getDescriptor().getLabelValueRelativeValueProvider());
    }

    public String getFormattedModelName() {
        return GeneratorUtils.formatToCapWords(this.genClass.getName());
    }
}

