/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.dialogs;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.about.ISystemSummarySection;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ConfigurationLogUpdateSection
implements ISystemSummarySection {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private void writeInstalledIUs(PrintWriter writer) {
        ServiceReference reference;
        BundleContext context = IDEWorkbenchPlugin.getDefault().getBundle().getBundleContext();
        if (context == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.engine.IProfileRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        try {
            IProfileRegistry registry = (IProfileRegistry)context.getService(reference);
            if (registry == null) {
                return;
            }
            IProfile profile = registry.getProfile("_SELF_");
            if (profile == null) {
                return;
            }
            writer.println(IDEWorkbenchMessages.ConfigurationLogUpdateSection_installConfiguration);
            writer.println(" " + NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_lastChangedOn, (Object)DateFormat.getDateInstance().format(new Date(profile.getTimestamp()))));
            writer.println(" " + NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_location, (Object)profile.getProperty("org.eclipse.equinox.p2.installFolder")));
            writer.println(" " + NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_timestamp, (Object)Long.toString(profile.getTimestamp())));
            writer.println();
            IQueryResult result = profile.available(QueryUtil.createIUAnyQuery(), null);
            TreeSet<String> sorted = new TreeSet<String>();
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                IInstallableUnit unit = (IInstallableUnit)iter.next();
                sorted.add(NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_IU, (Object)unit.getId(), (Object)unit.getVersion()));
            }
            if (!sorted.isEmpty()) {
                writer.println(IDEWorkbenchMessages.ConfigurationLogUpdateSection_IUHeader);
                writer.println();
                iter = sorted.iterator();
                while (iter.hasNext()) {
                    writer.println(iter.next());
                }
            }
        }
        finally {
            context.ungetService(reference);
        }
    }

    private void writeBundles(PrintWriter writer) {
        ServiceReference reference;
        BundleContext context = IDEWorkbenchPlugin.getDefault().getBundle().getBundleContext();
        if (context == null) {
            return;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.osgi.service.resolver.PlatformAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reference = context.getServiceReference(clazz.getName())) == null) {
            return;
        }
        PlatformAdmin admin = (PlatformAdmin)context.getService(reference);
        try {
            State state = admin.getState(false);
            BundleDescription[] bundles = state.getBundles();
            TreeSet<String> sorted = new TreeSet<String>();
            int i = 0;
            while (i < bundles.length) {
                BundleDescription bundle = bundles[i];
                String name = bundle.getName();
                if (name == null) {
                    name = bundle.getLocation();
                }
                String message = NLS.bind((String)IDEWorkbenchMessages.ConfigurationLogUpdateSection_bundle, (Object[])new Object[]{name, bundle.getVersion(), bundle.getLocation()});
                sorted.add(message);
                ++i;
            }
            if (!sorted.isEmpty()) {
                writer.println(IDEWorkbenchMessages.ConfigurationLogUpdateSection_bundleHeader);
                writer.println();
                Iterator iter = sorted.iterator();
                while (iter.hasNext()) {
                    writer.println(iter.next());
                }
            }
        }
        finally {
            context.ungetService(reference);
        }
    }

    public void write(PrintWriter writer) {
        this.writeInstalledIUs(writer);
        writer.println();
        this.writeBundles(writer);
    }
}

