/*******************************************************************************
 * Copyright (c) 2006, 2008 Wind River Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 *  
 * Contributors:
 *     Wind River Systems - initial API and implementation
 *******************************************************************************/

/*
 * This module implements low-level functions for reading DWARF debug information.
 *
 * Functions in this module use exceptions to report errors, see exceptions.h
 */
#ifndef D_dwarfio
#define D_dwarfio

#include "elf.h"

extern U4_T dio_gVersion;
extern U1_T dio_g64bit;
extern U1_T dio_gAddressSize;
extern U8_T dio_gUnitPos;
extern U4_T dio_gUnitSize;
extern U8_T dio_gEntryPos;

extern U8_T dio_gFormRef;
extern U8_T dio_gFormData;
extern U1_T dio_gFormDataSize;
extern U1_T * dio_gFormBlockBuf;
extern U4_T dio_gFormBlockSize;

extern void dio_EnterSection(ELF_Section * Section, U8_T Offset);
extern void dio_ExitSection(void);

extern void dio_Skip(U8_T Bytes);
extern void dio_Read(U1_T * Buf, U4_T Size);
extern U8_T dio_GetPos(void);

extern U1_T dio_ReadU1(void);
extern U2_T dio_ReadU2(void);
extern U4_T dio_ReadU4(void);
extern U8_T dio_ReadU8(void);

extern U4_T dio_ReadLEB128(void);
extern U8_T dio_ReadU8LEB128(void);
extern I8_T dio_ReadI8LEB128(void);

extern U8_T dio_ReadUX(int Size);
extern U8_T dio_ReadAddress(void);

extern char * dio_ReadString(void);

extern U8_T dio_ReadAddrBuf(U1_T * Buf);

typedef void (*DIO_EntryCallBack)(U2_T /* Tag */, U2_T /* Attr */, U2_T /* Form */);
/*
 * CallBack is called berore each DWARF entry with Atrr = 0 and Form = 1,
 * then is is called for each entry attribute with appropriate Attr and Form values,
 * and then called after the entry with Attr = 0 and Form = 0.
 * This sequence is repeated for each entry in the debug info unit.
 */
extern void dio_ReadUnit(DIO_EntryCallBack CallBack);

extern void dio_LoadAbbrevTable(ELF_File * File);

extern void dio_ChkFlag(U2_T Form);
extern void dio_ChkRef(U2_T Form);
extern void dio_ChkAddr(U2_T Form);
extern void dio_ChkData(U2_T Form);
extern void dio_ChkBlock(U2_T Form, U1_T ** Buf, U4_T * Size);
extern void dio_ChkString(U2_T Form);

#endif

