/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.core.builder;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.dltk.mod.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.mod.ast.parser.ISourceParser;
import org.eclipse.dltk.mod.compiler.problem.ProblemCollector;
import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ISourceModuleInfoCache;
import org.eclipse.dltk.mod.core.SourceParserUtil;
import org.eclipse.dltk.mod.core.builder.AbstractBuildParticipantType;
import org.eclipse.dltk.mod.core.builder.IBuildContext;
import org.eclipse.dltk.mod.core.builder.IBuildParticipant;
import org.eclipse.dltk.mod.internal.core.ModelManager;

public class ParserBuildParticipantFactory
extends AbstractBuildParticipantType
implements IExecutableExtension {
    private String natureId = null;

    @Override
    public IBuildParticipant createBuildParticipant(IScriptProject project) throws CoreException {
        ISourceParser parser;
        if (this.natureId != null && (parser = DLTKLanguageManager.getSourceParser(this.natureId)) != null) {
            return new ParserBuildParticipant(parser);
        }
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.natureId = config.getAttribute("nature");
    }

    private static class ParserBuildParticipant
    implements IBuildParticipant {
        private final ISourceParser parser;

        public ParserBuildParticipant(ISourceParser parser) {
            this.parser = parser;
        }

        @Override
        public void build(IBuildContext context) throws CoreException {
            ModuleDeclaration moduleDeclaration = (ModuleDeclaration)context.get(IBuildContext.ATTR_MODULE_DECLARATION);
            if (moduleDeclaration != null) {
                return;
            }
            ISourceModuleInfoCache.ISourceModuleInfo cacheEntry = ModelManager.getModelManager().getSourceModuleInfoCache().get(context.getSourceModule());
            moduleDeclaration = SourceParserUtil.getModuleFromCache(cacheEntry, 0, context.getProblemReporter());
            if (moduleDeclaration != null) {
                context.set(IBuildContext.ATTR_MODULE_DECLARATION, moduleDeclaration);
            }
            ProblemCollector problemCollector = new ProblemCollector();
            moduleDeclaration = this.parser.parse(context.getSourceModule().getPath().toString().toCharArray(), context.getContents(), context.getProblemReporter());
            SourceParserUtil.putModuleToCache(cacheEntry, moduleDeclaration, 0, problemCollector);
            problemCollector.copyTo(context.getProblemReporter());
        }
    }
}

