/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IScriptProject;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElementDelta;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.ModelOperation;
import org.eclipse.dltk.mod.internal.core.ScriptProject;
import org.eclipse.dltk.mod.internal.core.SourceModule;

public class DiscardWorkingCopyOperation
extends ModelOperation {
    public DiscardWorkingCopyOperation(IModelElement workingCopy) {
        super(new IModelElement[]{workingCopy});
    }

    @Override
    protected void executeOperation() throws ModelException {
        SourceModule workingCopy = this.getWorkingCopy();
        ModelManager manager = ModelManager.getModelManager();
        int useCount = manager.discardPerWorkingCopyInfo(workingCopy);
        if (useCount == 0) {
            IScriptProject scriptProject = workingCopy.getScriptProject();
            if (" ".equals(scriptProject.getElementName())) {
                manager.removePerProjectInfo((ScriptProject)scriptProject);
                manager.containerRemove(scriptProject);
            }
            if (!workingCopy.isPrimary()) {
                ModelElementDelta delta = new ModelElementDelta(this.getModel());
                delta.removed(workingCopy);
                this.addDelta(delta);
                this.removeReconcileDelta(workingCopy);
            } else if (workingCopy.getResource().isAccessible()) {
                ModelElementDelta delta = new ModelElementDelta(this.getModel());
                delta.changed(workingCopy, 65536);
                this.addDelta(delta);
            } else {
                ModelElementDelta delta = new ModelElementDelta(this.getModel());
                delta.removed(workingCopy, 65536);
                this.addDelta(delta);
            }
        }
    }

    protected SourceModule getWorkingCopy() {
        return (SourceModule)this.getElementToProcess();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

