/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.mod.core.IElementCacheListener;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ArchiveFolder;
import org.eclipse.dltk.mod.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.mod.internal.core.Openable;
import org.eclipse.dltk.mod.internal.core.OverflowingLRUCache;
import org.eclipse.dltk.mod.internal.core.ProjectFragment;
import org.eclipse.dltk.mod.internal.core.ScriptFolder;
import org.eclipse.dltk.mod.internal.core.util.LRUCache;

public class ElementCache
extends OverflowingLRUCache {
    IModelElement spaceLimitParent = null;
    private ListenerList listeners;

    public ElementCache(int size) {
        super(size);
    }

    public ElementCache(int size, int overflow) {
        super(size, overflow);
    }

    @Override
    protected boolean close(LRUCache.LRUCacheEntry entry) {
        Openable element;
        block5: {
            element = (Openable)entry._fKey;
            this.notifyListenersClose(element);
            try {
                if (element.canBeRemovedFromCache()) break block5;
                return false;
            }
            catch (ModelException modelException) {
                return false;
            }
        }
        if (element instanceof ArchiveFolder || element instanceof ExternalScriptFolder) {
            ScriptFolder archiveFolder = (ScriptFolder)element;
            ProjectFragment root = (ProjectFragment)archiveFolder.getParent();
            root.close();
        } else {
            element.close();
        }
        return true;
    }

    protected void ensureSpaceLimit(int childrenSize, IModelElement parent) {
        int spaceNeeded = 1 + (int)((1.0 + this.fLoadFactor) * (double)(childrenSize + this.fOverflow));
        if (this.fSpaceLimit < spaceNeeded) {
            this.shrink();
            this.setSpaceLimit(spaceNeeded);
            this.spaceLimitParent = parent;
        }
    }

    @Override
    protected LRUCache newInstance(int size, int overflow) {
        return new ElementCache(size, overflow);
    }

    protected void resetSpaceLimit(int defaultLimit, IModelElement parent) {
        if (parent.equals(this.spaceLimitParent)) {
            this.setSpaceLimit(defaultLimit);
            this.spaceLimitParent = null;
        }
    }

    protected ListenerList getListenerList() {
        if (this.listeners == null) {
            this.listeners = new ListenerList();
        }
        return this.listeners;
    }

    public void addListener(IElementCacheListener listener) {
        this.getListenerList().add((Object)listener);
    }

    public void removeListener(IElementCacheListener listener) {
        this.getListenerList().remove((Object)listener);
    }

    protected void notifyListenersClose(Object element) {
        Object[] listeners2 = this.getListenerList().getListeners();
        int i = 0;
        while (i < listeners2.length) {
            IElementCacheListener listener = (IElementCacheListener)listeners2[i];
            if (listener != null) {
                listener.close(element);
            }
            ++i;
        }
    }
}

