/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ImportContainer;
import org.eclipse.dltk.mod.internal.core.ImportDeclarationElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.SourceModule;
import org.eclipse.dltk.mod.internal.core.SourceRefElement;
import org.eclipse.dltk.mod.utils.CorePrinter;
import org.eclipse.vjet.eclipse.core.IImportDeclaration;

public class ImportDeclaration
extends SourceRefElement
implements IImportDeclaration {
    protected boolean m_isOnDemand;
    protected String m_name;

    public ImportDeclaration(ImportContainer parent, String name, boolean isOnDemand) {
        super(parent);
        this.m_name = name;
        this.m_isOnDemand = isOnDemand;
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public void copy(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws ModelException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ImportDeclaration)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String getElementName() {
        if (this.m_isOnDemand) {
            return String.valueOf(this.m_name) + ".*";
        }
        return this.m_name;
    }

    @Override
    public int getElementType() {
        return 13;
    }

    @Override
    public int getFlags() throws ModelException {
        ImportDeclarationElementInfo info = (ImportDeclarationElementInfo)this.getElementInfo();
        return info.getModifiers();
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((ModelElement)this.getParent()).getHandleMemento(buff);
        this.escapeMementoName(buff, this.getElementName());
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }

    public String getNameWithoutStar() {
        return this.m_name;
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        SourceModule cu = (SourceModule)this.parent.getParent();
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        ImportContainer container = new ImportContainer(cu);
        return container.getImport(this.getElementName());
    }

    @Override
    public boolean isLibrary() {
        try {
            return this.getFlags() != 0;
        }
        catch (ModelException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isOnDemand() {
        return this.m_isOnDemand;
    }

    @Override
    public void move(IModelElement container, IModelElement sibling, String rename, boolean replace, IProgressMonitor monitor) throws ModelException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    public void printNode(CorePrinter output) {
    }

    public String readableName() {
        return null;
    }

    @Override
    public void rename(String name, boolean replace, IProgressMonitor monitor) throws ModelException {
        throw new RuntimeException("Method not implemented");
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("import ");
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }
}

