/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.mod.core.IField;
import org.eclipse.dltk.mod.core.IMethod;
import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IProjectFragment;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.IJSInitializer;
import org.eclipse.dltk.mod.internal.core.JSInitializer;
import org.eclipse.dltk.mod.internal.core.JSSourceField;
import org.eclipse.dltk.mod.internal.core.JSSourceMethod;
import org.eclipse.dltk.mod.internal.core.JSSourceTypeElementInfo;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.SourceType;
import org.eclipse.dltk.mod.internal.core.SourceTypeElementInfo;
import org.eclipse.vjet.eclipse.core.IJSMethod;
import org.eclipse.vjet.eclipse.core.IJSType;

public class JSSourceType
extends SourceType
implements IJSType {
    public static final int CLASS_DECL = 1;
    public static final int ENUM_DECL = 3;
    public static final int INTERFACE_DECL = 2;

    public static final int kind(int flags) {
        switch (flags & 0x6200) {
            case 512: {
                return 2;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public JSSourceType(ModelElement parent, String name) {
        super(parent, name);
    }

    @Override
    public IJSInitializer getInitializer(int count) {
        return new JSInitializer(this, count);
    }

    @Override
    public IJSInitializer[] getInitializers() throws ModelException {
        ArrayList list = this.getChildrenOfType(11);
        IJSInitializer[] array = new IJSInitializer[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IJSMethod getMethod(String selector, String[] parameterTypeSignatures) {
        return new JSSourceMethod(this, selector, parameterTypeSignatures);
    }

    @Override
    public IMethod getMethod(String selector) {
        return new JSSourceMethod(this, selector);
    }

    @Override
    public IProjectFragment getProjectFragment() {
        IModelElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 3) {
                return (IProjectFragment)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    @Override
    public String[] getSuperInterfaceNames() throws ModelException {
        JSSourceTypeElementInfo info = (JSSourceTypeElementInfo)this.getElementInfo();
        String[] names = info.getInterfaceNames();
        return names;
    }

    @Override
    public boolean isClass() throws ModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        return JSSourceType.kind(info.getModifiers()) == 1;
    }

    @Override
    public boolean isInterface() throws ModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        switch (JSSourceType.kind(info.getModifiers())) {
            case 2: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEnum() throws ModelException {
        SourceTypeElementInfo info = (SourceTypeElementInfo)this.getElementInfo();
        switch (JSSourceType.kind(info.getModifiers())) {
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IField getField(String fieldName) {
        return new JSSourceField(this, fieldName);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof JSSourceType)) {
            return false;
        }
        if (!this.getFullyQualifiedName(".").equals(((JSSourceType)o).getFullyQualifiedName("."))) {
            return false;
        }
        return super.equals(o);
    }
}

