/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.core.IModelElement;
import org.eclipse.dltk.mod.core.IPackageDeclaration;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.internal.core.ModelElement;
import org.eclipse.dltk.mod.internal.core.SourceRefElement;
import org.eclipse.dltk.mod.utils.CorePrinter;

class PackageDeclaration
extends SourceRefElement
implements IPackageDeclaration {
    String name;

    protected PackageDeclaration(ModelElement parent, String name) {
        super(parent);
        this.name = name;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof PackageDeclaration)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 10;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '%';
    }

    @Override
    public IModelElement getPrimaryElement(boolean checkOwner) {
        ISourceModule cu = (ISourceModule)this.getAncestor(5);
        if (checkOwner && cu.isPrimary()) {
            return this;
        }
        return cu.getPackageDeclaration(this.name);
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        buffer.append("package ");
        this.toStringName(buffer);
        if (info == null) {
            buffer.append(" (not open)");
        }
    }

    @Override
    protected void closing(Object info) throws ModelException {
    }

    @Override
    public void printNode(CorePrinter output) {
    }
}

