/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core;

import org.eclipse.dltk.mod.core.DLTKLanguageManager;
import org.eclipse.dltk.mod.core.ISearchableEnvironment;
import org.eclipse.dltk.mod.core.ISourceModule;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.WorkingCopyOwner;
import org.eclipse.dltk.mod.core.search.BasicSearchEngine;
import org.eclipse.dltk.mod.core.search.IDLTKSearchScope;
import org.eclipse.dltk.mod.internal.core.ModelManager;
import org.eclipse.dltk.mod.internal.core.NameLookup;
import org.eclipse.dltk.mod.internal.core.ScriptProject;

public class SearchableEnvironment
implements ISearchableEnvironment {
    public NameLookup nameLookup;
    protected org.eclipse.dltk.mod.compiler.env.ISourceModule unitToSkip;
    protected ISourceModule[] workingCopies;
    protected ScriptProject project;
    protected IDLTKSearchScope searchScope;
    protected boolean checkAccessRestrictions;

    public SearchableEnvironment(ScriptProject project, ISourceModule[] workingCopies) throws ModelException {
        this.project = project;
        this.checkAccessRestrictions = !"ignore".equals(project.getOption("org.eclipse.dltk.mod.core.compiler.problem.forbiddenReference", true)) || !"ignore".equals(project.getOption("org.eclipse.dltk.mod.core.compiler.problem.discouragedReference", true));
        this.workingCopies = workingCopies;
        this.nameLookup = project.newNameLookup(workingCopies);
        this.searchScope = this.checkAccessRestrictions ? BasicSearchEngine.createSearchScope(project) : BasicSearchEngine.createSearchScope(this.nameLookup.projectFragments, DLTKLanguageManager.getLanguageToolkit(project));
    }

    public SearchableEnvironment(ScriptProject project, WorkingCopyOwner owner) throws ModelException {
        this(project, owner == null ? null : ModelManager.getModelManager().getWorkingCopies(owner, true));
    }

    @Override
    public void cleanup() {
    }

    @Override
    public NameLookup getNameLookup() {
        return this.nameLookup;
    }
}

