/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.internal.core.util;

import org.eclipse.dltk.mod.core.Flags;
import org.eclipse.dltk.mod.core.IMember;
import org.eclipse.dltk.mod.core.IType;
import org.eclipse.dltk.mod.core.ModelException;
import org.eclipse.dltk.mod.core.ScriptModelUtil;

public class VjoFlags {
    public static final String VISIBILITY_STRING_PRIVATE = "private";
    public static final String VISIBILITY_STRING_PACKAGE = "";
    public static final String VISIBILITY_STRING_PROTECTED = "protected";
    public static final String VISIBILITY_STRING_PUBLIC = "public";
    public static final int VISIBILITY_CODE_INVALID = -1;

    private VjoFlags() {
    }

    public static boolean isAbstract(IMember member) throws ModelException {
        if (VjoFlags.isInterfaceOrAnnotationMethod(member)) {
            return true;
        }
        return Flags.isAbstract(member.getFlags());
    }

    public static boolean isFinal(IMember member) throws ModelException {
        if (VjoFlags.isInterfaceOrAnnotationField(member)) {
            return true;
        }
        if (VjoFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isFinal(member.getFlags());
    }

    public static boolean isPackageVisible(IMember member) throws ModelException {
        return !VjoFlags.isPrivate(member) && !VjoFlags.isProtected(member) && !VjoFlags.isPublic(member);
    }

    public static boolean isPrivate(IMember member) throws ModelException {
        return Flags.isPrivate(member.getFlags());
    }

    public static boolean isProtected(IMember member) throws ModelException {
        return Flags.isProtected(member.getFlags());
    }

    public static boolean isPublic(IMember member) throws ModelException {
        if (VjoFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (VjoFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isPublic(member.getFlags());
    }

    public static boolean isStatic(IMember member) throws ModelException {
        if (VjoFlags.isNestedInterfaceOrAnnotation(member)) {
            return true;
        }
        if (member.getElementType() != 9 && VjoFlags.isInterfaceOrAnnotationMember(member)) {
            return true;
        }
        if (VjoFlags.isEnumConstant(member)) {
            return true;
        }
        return Flags.isStatic(member.getFlags());
    }

    public static boolean isAnnotation(IMember member) throws ModelException {
        return Flags.isAnnotation(member.getFlags());
    }

    public static boolean isEnum(IMember member) throws ModelException {
        return Flags.isEnum(member.getFlags());
    }

    private static boolean isInterfaceOrAnnotationMethod(IMember member) throws ModelException {
        return member.getElementType() == 9 && VjoFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationField(IMember member) throws ModelException {
        return member.getElementType() == 8 && VjoFlags.isInterfaceOrAnnotationMember(member);
    }

    private static boolean isInterfaceOrAnnotationMember(IMember member) throws ModelException {
        return member.getDeclaringType() != null && ScriptModelUtil.isInterfaceOrAnnotation(member.getDeclaringType());
    }

    private static boolean isNestedInterfaceOrAnnotation(IMember member) throws ModelException {
        return member.getElementType() == 7 && member.getDeclaringType() != null && ScriptModelUtil.isInterfaceOrAnnotation((IType)member);
    }

    private static boolean isEnumConstant(IMember member) throws ModelException {
        return member.getElementType() == 8 && VjoFlags.isEnum(member);
    }

    public static int clearFlag(int flag, int flags) {
        return flags & ~flag;
    }
}

