/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.mod.dbgp.internal.commands;

import java.io.IOException;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpDebuggingEngineException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpIOException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpOpertionCanceledException;
import org.eclipse.dltk.mod.dbgp.exceptions.DbgpTimeoutException;
import org.eclipse.dltk.mod.dbgp.internal.DbgpRequest;
import org.eclipse.dltk.mod.dbgp.internal.IDbgpDebugingEngine;
import org.eclipse.dltk.mod.dbgp.internal.commands.IDbgpCommunicator;
import org.eclipse.dltk.mod.dbgp.internal.packets.DbgpResponsePacket;
import org.eclipse.dltk.mod.dbgp.internal.utils.DbgpXmlParser;
import org.eclipse.dltk.mod.debug.core.DLTKDebugPlugin;
import org.eclipse.dltk.mod.debug.core.DebugOption;
import org.eclipse.dltk.mod.debug.core.IDebugOptions;
import org.w3c.dom.Element;

public class DbgpDebuggingEngineCommunicator
implements IDbgpCommunicator {
    private final int timeout;
    private final IDbgpDebugingEngine engine;
    private IDebugOptions options;
    private final Map activeRequests = new IdentityHashMap();
    private static final boolean DEBUG = false;

    private void sendRequest(DbgpRequest command) throws IOException {
        this.engine.sendCommand(command);
    }

    private DbgpResponsePacket receiveResponse(int transactionId) throws IOException, InterruptedException {
        return this.engine.getResponsePacket(transactionId, this.timeout);
    }

    public DbgpDebuggingEngineCommunicator(IDbgpDebugingEngine engine, IDebugOptions options) {
        if (engine == null) {
            throw new IllegalArgumentException();
        }
        this.engine = engine;
        this.options = options;
        this.timeout = DLTKDebugPlugin.getDefault().getPluginPreferences().getInt("dbgp_response_timeout");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element communicate(DbgpRequest request) throws DbgpException {
        try {
            DbgpResponsePacket packet;
            int requestId = Integer.parseInt(request.getOption("-i"));
            if (this.options.get(DebugOption.DBGP_ASYNC) || request.isAsync()) {
                this.sendRequest(request);
                packet = this.receiveResponse(requestId);
            } else {
                long startTime = 0L;
                Map map = this.activeRequests;
                synchronized (map) {
                    while (!this.activeRequests.isEmpty()) {
                        this.activeRequests.wait();
                    }
                    this.activeRequests.put(request, request);
                }
                try {
                    this.sendRequest(request);
                    packet = this.receiveResponse(requestId);
                }
                catch (Throwable throwable) {
                    Map map2 = this.activeRequests;
                    synchronized (map2) {
                        this.activeRequests.remove(request);
                        this.activeRequests.notifyAll();
                    }
                    throw throwable;
                }
                Map map3 = this.activeRequests;
                synchronized (map3) {
                    this.activeRequests.remove(request);
                    this.activeRequests.notifyAll();
                }
            }
            if (packet == null) {
                throw new DbgpTimeoutException();
            }
            Element response = packet.getContent();
            DbgpDebuggingEngineException e = DbgpXmlParser.checkError(response);
            if (e != null) {
                throw e;
            }
            return response;
        }
        catch (InterruptedException interruptedException) {
            throw new DbgpOpertionCanceledException();
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    @Override
    public void send(DbgpRequest request) throws DbgpException {
        try {
            this.sendRequest(request);
        }
        catch (IOException e) {
            throw new DbgpIOException(e);
        }
    }

    @Override
    public void configure(IDebugOptions debugOptions) {
        this.options = debugOptions;
    }
}

