/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.cml.vjetv.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.ArgumentsParser;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.core.LauncherFactory;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.messages.Messages;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadLessLauncherResult;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.IHeadlessParserConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.HeadlessParserConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.model.impl.VjetvHeadlessConfigure;
import org.eclipse.vjet.dsf.jstojava.cml.vjetv.util.ParserHelper;

public class HeadLessValidationEntry {
    private static VjetvHeadlessConfigure convert2VjetvConfig(IHeadlessParserConfigure parserConf) {
        VjetvHeadlessConfigure vjetvConf = new VjetvHeadlessConfigure();
        vjetvConf.setLibrariesToLoad(HeadLessValidationEntry.findLibraries(parserConf.getBuildPath()));
        vjetvConf.setExclusionPatterns(parserConf.getExclusionPatterns());
        vjetvConf.setReportType(parserConf.getReportType());
        vjetvConf.setValidatedJSFiles(parserConf.getValidatedJSFiles());
        vjetvConf.setReportLevel(parserConf.getReportLevel());
        vjetvConf.setReportPath(parserConf.getReportPath());
        vjetvConf.setReportType(parserConf.getReportType());
        vjetvConf.setVerbose(parserConf.isVerbose());
        vjetvConf.setFailBuild(parserConf.isFailBuild());
        return vjetvConf;
    }

    private static List<String> findLibraries(HashSet<File> buildPath) {
        ArrayList<String> libs = new ArrayList<String>();
        for (File path : buildPath) {
            if (!path.getAbsolutePath().endsWith(".zip")) continue;
            libs.add(path.getAbsolutePath());
        }
        return libs;
    }

    public static void main(String[] args) {
        if (args.length != 0) {
            HeadLessValidationEntry.runVjetv(args);
        } else {
            ParserHelper.printOptionsHelp(ArgumentsParser.getEVOptions(), Messages.getString("VjetVEntry.ADDCOMMAND"));
            System.exit(0);
        }
    }

    public static IHeadLessLauncherResult runVjetv(String[] args) {
        ArgumentsParser parser = new ArgumentsParser();
        HeadlessParserConfigure parserConf = new HeadlessParserConfigure();
        parser.parser(args, parserConf);
        parser.initEnv(parserConf);
        VjetvHeadlessConfigure vjetvConf = HeadLessValidationEntry.convert2VjetvConfig(parserConf);
        IHeadLessLauncherResult result = LauncherFactory.getVjetValidationLauncher().launch(vjetvConf);
        if (result.getErrorNumber() > 0 && parserConf.isFailBuild()) {
            throw new RuntimeException("There are  " + result.getErrorNumber() + " validation errors, please fix it");
        }
        return result;
    }
}

