/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.resolver;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.vjet.dsf.jstojava.resolver.FunctionMetaMapping;
import org.eclipse.vjet.dsf.jstojava.resolver.IFunctionMetaMapping;
import org.eclipse.vjet.dsf.jstojava.resolver.IMetaExtension;

public class FunctionMetaRegistry {
    private static FunctionMetaRegistry s_instance = new FunctionMetaRegistry();
    private Map<String, FunctionMetaMapping> m_funcMetaMappings = new LinkedHashMap<String, FunctionMetaMapping>();
    private Set<String> m_tergetFuncs = new HashSet<String>();

    public static FunctionMetaRegistry getInstance() {
        return s_instance;
    }

    public void addMapping(FunctionMetaMapping mapping) {
        String[] stringArray = mapping.getGroupIds();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String grp = stringArray[n2];
            this.m_funcMetaMappings.put(grp, mapping);
            ++n2;
        }
        this.m_tergetFuncs.addAll(mapping.getSupportedTargetFuncs());
    }

    public boolean isFuncMetaMappingSupported(String targetFunc) {
        return this.m_tergetFuncs.contains(targetFunc);
    }

    public IMetaExtension getExtentedArgBinding(String targetFunc, String key, String groupId, List<String> dependentGroupIds) {
        IMetaExtension method = this.getExtentedArgBinding(targetFunc, key, groupId);
        if (method == null && dependentGroupIds != null) {
            int i = 0;
            while (i < dependentGroupIds.size()) {
                method = this.getExtentedArgBinding(targetFunc, key, dependentGroupIds.get(i));
                if (method != null) break;
                ++i;
            }
        }
        return method;
    }

    public void clear(String groupId) {
        this.m_funcMetaMappings.remove(groupId);
        this.m_tergetFuncs.clear();
        for (IFunctionMetaMapping iFunctionMetaMapping : this.m_funcMetaMappings.values()) {
            this.m_tergetFuncs.addAll(iFunctionMetaMapping.getSupportedTargetFuncs());
        }
    }

    public void clearAll() {
        this.m_funcMetaMappings.clear();
        this.m_tergetFuncs.clear();
    }

    private IMetaExtension getExtentedArgBinding(String targetFunc, String key, String groupId) {
        IFunctionMetaMapping mapping = this.m_funcMetaMappings.get(groupId);
        return mapping == null ? null : mapping.getExtentedArgBinding(targetFunc, key);
    }

    public boolean isFirstArgumentType(String targetFunc, String groupId) {
        IFunctionMetaMapping mapping = this.m_funcMetaMappings.get(groupId);
        if (mapping != null) {
            return mapping.isFirstArgumentType(targetFunc);
        }
        return false;
    }
}

