/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.eclipse.mod.wst.jsdt.core.ast.IASTNode;
import org.eclipse.mod.wst.jsdt.core.ast.IExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.Literal;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstMethod;
import org.eclipse.vjet.dsf.jst.IJstNode;
import org.eclipse.vjet.dsf.jst.IJstProperty;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.IJstTypeReference;
import org.eclipse.vjet.dsf.jst.ISynthesized;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstArg;
import org.eclipse.vjet.dsf.jst.declaration.JstBlock;
import org.eclipse.vjet.dsf.jst.declaration.JstCache;
import org.eclipse.vjet.dsf.jst.declaration.JstFactory;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.declaration.JstVar;
import org.eclipse.vjet.dsf.jst.declaration.JstVars;
import org.eclipse.vjet.dsf.jst.expr.ArrayAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.AssignExpr;
import org.eclipse.vjet.dsf.jst.expr.BoolExpr;
import org.eclipse.vjet.dsf.jst.expr.FieldAccessExpr;
import org.eclipse.vjet.dsf.jst.expr.InfixExpr;
import org.eclipse.vjet.dsf.jst.expr.MtdInvocationExpr;
import org.eclipse.vjet.dsf.jst.expr.ObjCreationExpr;
import org.eclipse.vjet.dsf.jst.expr.ParenthesizedExpr;
import org.eclipse.vjet.dsf.jst.expr.PostfixExpr;
import org.eclipse.vjet.dsf.jst.expr.PrefixExpr;
import org.eclipse.vjet.dsf.jst.stmt.CatchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForInStmt;
import org.eclipse.vjet.dsf.jst.stmt.ForStmt;
import org.eclipse.vjet.dsf.jst.stmt.IfStmt;
import org.eclipse.vjet.dsf.jst.stmt.RtnStmt;
import org.eclipse.vjet.dsf.jst.stmt.SwitchStmt;
import org.eclipse.vjet.dsf.jst.stmt.ThrowStmt;
import org.eclipse.vjet.dsf.jst.stmt.TryStmt;
import org.eclipse.vjet.dsf.jst.stmt.WhileStmt;
import org.eclipse.vjet.dsf.jst.term.JstIdentifier;
import org.eclipse.vjet.dsf.jst.token.IExpr;
import org.eclipse.vjet.dsf.jst.token.IInitializer;
import org.eclipse.vjet.dsf.jst.token.ILHS;
import org.eclipse.vjet.dsf.jst.token.IStmt;
import org.eclipse.vjet.dsf.jst.traversal.IJstNodeVisitor;
import org.eclipse.vjet.dsf.jstojava.translator.JstUtilVisitor;

public class JstUtil {
    private static final String SPACE = "";
    private static final String QUOTE = "'";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String EMPTY = "";
    private static boolean s_debug = false;

    public static BaseJstNode getLeafNode(IJstType type, int startOffset, int endOffset) {
        return JstUtil.getLeafNode(type, startOffset, endOffset, false);
    }

    public static BaseJstNode getLeafNode(IJstType type, int startOffset, int endOffset, boolean visitOverlodedNodes) {
        return JstUtil.getLeafNode(type, startOffset, endOffset, visitOverlodedNodes, false);
    }

    public static BaseJstNode getLeafNode(IJstType type, int startOffset, int endOffset, boolean visitOverlodedNodes, boolean countIdentifierEndOffset) {
        if (type == null) {
            return null;
        }
        JstUtil.debug("JstUtil: looking for  " + type.getName() + ", startOffset=" + startOffset + " , endOffset=" + endOffset);
        Object node = null;
        List<BaseJstNode> nodeList = JstUtil.getAllNodes(type, startOffset, endOffset, visitOverlodedNodes, countIdentifierEndOffset);
        if (!nodeList.isEmpty()) {
            for (BaseJstNode n : nodeList) {
                JstSource curSrc;
                int curRange;
                if (node == null) {
                    node = n;
                    continue;
                }
                JstSource source = n.getSource();
                int range = source.getEndOffSet() - source.getStartOffSet();
                if (range > (curRange = (curSrc = node.getSource()).getEndOffSet() - curSrc.getStartOffSet())) continue;
                node = n;
            }
            JstUtil.debug("JstUtil: found " + node.getClass().getName());
            JstUtil.print(node);
        }
        return node;
    }

    public static List<BaseJstNode> getAllNodes(IJstType type, int startOffset, int endOffset) {
        return JstUtil.getAllNodes(type, startOffset, endOffset, false);
    }

    public static List<BaseJstNode> getAllNodes(IJstType type, int startOffset, int endOffset, boolean visitOverlodedNodes) {
        return JstUtil.getAllNodes(type, startOffset, endOffset, visitOverlodedNodes, false);
    }

    public static List<BaseJstNode> getAllNodes(IJstType type, int startOffset, int endOffset, boolean visitOverlodedNodes, boolean countIdentifierEndOffset) {
        if (type == null) {
            return Collections.EMPTY_LIST;
        }
        JstUtilVisitor visitor = new JstUtilVisitor(startOffset, endOffset, visitOverlodedNodes, countIdentifierEndOffset);
        type.accept((IJstNodeVisitor)visitor);
        return visitor.getFoundNodes();
    }

    private static Object processFields(IJstType type, int startOffset, int endOffset) {
        List fields = type.getInstanceProperties();
        Object field = JstUtil.processFields(fields, startOffset, endOffset);
        if (field != null) {
            return field;
        }
        fields = type.getStaticProperties();
        return JstUtil.processFields(fields, startOffset, endOffset);
    }

    private static Object processFields(Collection<IJstProperty> fields, int startOffset, int endOffset) {
        for (IJstProperty field : fields) {
            if (JstUtil.includes(field.getName().getSource(), startOffset, endOffset)) {
                return field;
            }
            IJstTypeReference type = field.getTypeRef();
            if (type != null && JstUtil.includes(type.getSource(), startOffset, endOffset)) {
                return type;
            }
            if (field.getInitializer() == null) continue;
            IExpr expr = field.getInitializer();
            return JstUtil.processExpression(expr, startOffset, endOffset);
        }
        return null;
    }

    private static Object processStatements(JstBlock block, int startOffset, int endOffset) {
        if (block != null) {
            List statements = block.getStmts();
            for (IStmt statement : statements) {
                Object node = JstUtil.processStatement(statement, startOffset, endOffset);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    private static Object processStatement(IStmt statement, int startOffset, int endOffset) {
        if (statement instanceof AssignExpr) {
            return JstUtil.processAssignExpr((AssignExpr)statement, startOffset, endOffset);
        }
        if (statement instanceof ForStmt) {
            Object node;
            ForStmt forStatement = (ForStmt)statement;
            IInitializer initializer = forStatement.getInitializers();
            if (initializer instanceof JstVars) {
                node = JstUtil.processStatement((IStmt)((JstVars)initializer), startOffset, endOffset);
                if (node != null) {
                    return node;
                }
            } else if (initializer != null) {
                initializer.getAssignments();
            }
            if ((node = JstUtil.processExpression((IExpr)forStatement.getCondition(), startOffset, endOffset)) != null) {
                return node;
            }
            List updaters = forStatement.getUpdaters();
            for (IExpr updater : updaters) {
                node = JstUtil.processExpression(updater, startOffset, endOffset);
                if (node == null) continue;
                return node;
            }
            return JstUtil.processStatements(forStatement.getBody(), startOffset, endOffset);
        }
        if (statement instanceof ForInStmt) {
            Object node;
            ForInStmt forInStmt = (ForInStmt)statement;
            ILHS var = forInStmt.getVar();
            if (var instanceof IStmt && (node = JstUtil.processStatement((IStmt)var, startOffset, endOffset)) != null) {
                return node;
            }
            IExpr expr = forInStmt.getExpr();
            node = JstUtil.processExpression(expr, startOffset, endOffset);
            if (node != null) {
                return node;
            }
            return JstUtil.processStatements(forInStmt.getBody(), startOffset, endOffset);
        }
        if (statement instanceof WhileStmt) {
            WhileStmt whileStmt = (WhileStmt)statement;
            Object node = JstUtil.processExpression((IExpr)whileStmt.getCondition(), startOffset, endOffset);
            if (node != null) {
                return node;
            }
            return JstUtil.processStatements(whileStmt.getBody(), startOffset, endOffset);
        }
        if (statement instanceof TryStmt) {
            TryStmt tryStmt = (TryStmt)statement;
            Object node = JstUtil.processStatements(tryStmt.getBody(), startOffset, endOffset);
            if (node != null) {
                return node;
            }
            JstBlock catchBlock = tryStmt.getCatchBlock(false);
            if (catchBlock != null) {
                for (IStmt catchStmt : catchBlock.getStmts()) {
                    node = JstUtil.processStatement(catchStmt, startOffset, endOffset);
                    if (node == null) continue;
                    return node;
                }
            }
            return JstUtil.processStatements(tryStmt.getFinallyBlock(false), startOffset, endOffset);
        }
        if (statement instanceof CatchStmt) {
            CatchStmt catchStmt = (CatchStmt)statement;
            JstVar exception = catchStmt.getException();
            if (JstUtil.includes(exception.getSource(), startOffset, endOffset)) {
                return exception;
            }
            return JstUtil.processStatements(catchStmt.getBody(), startOffset, endOffset);
        }
        if (statement instanceof SwitchStmt) {
            SwitchStmt switchStmt = (SwitchStmt)statement;
            Object node = JstUtil.processExpression(switchStmt.getExpr(), startOffset, endOffset);
            if (node != null) {
                return node;
            }
            return JstUtil.processStatements(switchStmt.getBody(), startOffset, endOffset);
        }
        if (statement instanceof SwitchStmt.CaseStmt) {
            return JstUtil.processExpression(((SwitchStmt.CaseStmt)statement).getExpr(), startOffset, endOffset);
        }
        if (statement instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)statement;
            Object node = JstUtil.processExpression((IExpr)ifStmt.getCondition(), startOffset, endOffset);
            if (node != null) {
                return node;
            }
            node = JstUtil.processStatements(ifStmt.getBody(), startOffset, endOffset);
            if (node != null) {
                return node;
            }
            if (ifStmt.getElseIfBlock(false) != null) {
                for (IStmt elseIfStmt : ifStmt.getElseIfBlock(false).getStmts()) {
                    node = JstUtil.processStatement(elseIfStmt, startOffset, endOffset);
                    if (node == null) continue;
                    return node;
                }
            }
            return JstUtil.processStatements(ifStmt.getElseBlock(false), startOffset, endOffset);
        }
        if (statement instanceof ThrowStmt) {
            ThrowStmt throwStmt = (ThrowStmt)statement;
            return JstUtil.processExpression(throwStmt.getExpression(), startOffset, endOffset);
        }
        if (statement instanceof RtnStmt) {
            RtnStmt returnStmt = (RtnStmt)statement;
            return JstUtil.processExpression(returnStmt.getExpression(), startOffset, endOffset);
        }
        if (statement instanceof MtdInvocationExpr) {
            return JstUtil.processExpression((IExpr)statement, startOffset, endOffset);
        }
        if (statement instanceof JstVars) {
            IJstTypeReference type = ((JstVars)statement).getTypeRef();
            if (type != null && JstUtil.includes(type.getSource(), startOffset, endOffset)) {
                return type;
            }
            List initializers = ((JstVars)statement).getAssignments();
            if (initializers != null && initializers.size() > 0) {
                for (AssignExpr jstInitializer : initializers) {
                    Object node = JstUtil.processAssignExpr(jstInitializer, startOffset, endOffset);
                    if (node == null) continue;
                    return node;
                }
            }
        }
        return null;
    }

    private static Object processExpression(IExpr expression, int startOffset, int endOffset) {
        if (expression == null) {
            return null;
        }
        if (expression instanceof JstIdentifier) {
            if (JstUtil.includes(((JstIdentifier)expression).getSource(), startOffset, endOffset)) {
                return expression;
            }
        } else {
            if (expression instanceof MtdInvocationExpr) {
                MtdInvocationExpr methodInvocation = (MtdInvocationExpr)expression;
                if (JstUtil.processExpression(methodInvocation.getMethodIdentifier(), startOffset, endOffset) != null) {
                    return methodInvocation;
                }
                List args = methodInvocation.getArgs();
                for (IExpr arg : args) {
                    Object result = JstUtil.processExpression(arg, startOffset, endOffset);
                    if (result == null) continue;
                    return result;
                }
                return JstUtil.processExpression(methodInvocation.getQualifyExpr(), startOffset, endOffset);
            }
            if (expression instanceof BoolExpr) {
                BoolExpr boolExpr = (BoolExpr)expression;
                Object node = JstUtil.processExpression(boolExpr.getLeft(), startOffset, endOffset);
                if (node != null) {
                    return node;
                }
                return JstUtil.processExpression(boolExpr.getRight(), startOffset, endOffset);
            }
            if (expression instanceof PostfixExpr) {
                return JstUtil.processExpression(((PostfixExpr)expression).getIdentifier(), startOffset, endOffset);
            }
            if (expression instanceof InfixExpr) {
                InfixExpr infixExpr = (InfixExpr)expression;
                Object node = JstUtil.processExpression(infixExpr.getLeft(), startOffset, endOffset);
                if (node != null) {
                    return node;
                }
                return JstUtil.processExpression(infixExpr.getRight(), startOffset, endOffset);
            }
            if (expression instanceof ParenthesizedExpr) {
                return JstUtil.processExpression(((ParenthesizedExpr)expression).getExpression(), startOffset, endOffset);
            }
            if (expression instanceof PrefixExpr) {
                return JstUtil.processExpression(((PrefixExpr)expression).getIdentifier(), startOffset, endOffset);
            }
            if (expression instanceof FieldAccessExpr) {
                FieldAccessExpr fieldExpr = (FieldAccessExpr)expression;
                if (JstUtil.processExpression((IExpr)fieldExpr.getName(), startOffset, endOffset) != null) {
                    return fieldExpr;
                }
                return JstUtil.processExpression(fieldExpr.getExpr(), startOffset, endOffset);
            }
            if (expression instanceof ArrayAccessExpr) {
                ArrayAccessExpr arrayExpr = (ArrayAccessExpr)expression;
                Object node = JstUtil.processExpression(arrayExpr.getIndex(), startOffset, endOffset);
                if (node != null) {
                    return node;
                }
                return JstUtil.processExpression(arrayExpr.getExpr(), startOffset, endOffset);
            }
            if (expression instanceof ObjCreationExpr) {
                ObjCreationExpr expr = (ObjCreationExpr)expression;
                expr.getSource().getEndOffSet();
                Object node = JstUtil.processExpression((IExpr)expr.getInvocationExpr(), startOffset, endOffset);
                if (node == null && JstUtil.includes(expr.getSource(), startOffset, endOffset)) {
                    return expr;
                }
                return node;
            }
        }
        return null;
    }

    private static Object processAssignExpr(AssignExpr assignExpr, int startOffset, int endOffset) {
        ILHS lhs = assignExpr.getLHS();
        if (lhs instanceof IExpr) {
            Object node = JstUtil.processExpression((IExpr)lhs, startOffset, endOffset);
            if (node != null) {
                return node;
            }
        } else if (lhs instanceof JstVar && JstUtil.includes(((JstVar)lhs).getSource(), startOffset, endOffset)) {
            return lhs;
        }
        return JstUtil.processExpression(assignExpr.getExpr(), startOffset, endOffset);
    }

    private static Object processConstructor(IJstType type, int startOffset, int endOffset) {
        IJstMethod constructor = type.getConstructor();
        if (constructor != null && !(constructor instanceof ISynthesized)) {
            return JstUtil.processMethod(constructor, startOffset, endOffset);
        }
        return null;
    }

    private static IJstTypeReference processImports(IJstType type, int startOffset, int endOffset) {
        List importsMap = type.getImportsRef();
        for (IJstTypeReference importedType : importsMap) {
            JstSource source = importedType.getSource();
            if (!JstUtil.includes(source, startOffset, endOffset)) continue;
            return importedType;
        }
        return null;
    }

    private static IJstTypeReference processExtends(IJstType type, int startOffset, int endOffset) {
        JstSource source;
        IJstTypeReference extendedType = type.getExtendRef();
        if (extendedType != null && JstUtil.includes(source = extendedType.getSource(), startOffset, endOffset)) {
            return extendedType;
        }
        return null;
    }

    private static IJstTypeReference processImplements(IJstType type, int startOffset, int endOffset) {
        List implementedTypes = type.getSatisfiesRef();
        return JstUtil.processTypes(implementedTypes, startOffset, endOffset);
    }

    private static IJstTypeReference processTypes(List<? extends IJstTypeReference> types, int startOffset, int endOffset) {
        for (IJstTypeReference iJstTypeReference : types) {
            JstSource source = iJstTypeReference.getSource();
            if (!JstUtil.includes(source, startOffset, endOffset)) continue;
            return iJstTypeReference;
        }
        return null;
    }

    public static boolean includes(JstSource elementSource, int selectionStart, int selectionEnd) {
        if (elementSource != null) {
            return JstUtil.includes(elementSource.getStartOffSet(), elementSource.getEndOffSet(), selectionStart, selectionEnd);
        }
        return false;
    }

    private static Object processMethods(IJstType type, int startOffset, int endOffset) {
        List methods = type.getInstanceMethods();
        Object node = JstUtil.processMethods(methods, startOffset, endOffset);
        if (node != null) {
            return node;
        }
        methods = type.getStaticMethods();
        return JstUtil.processMethods(methods, startOffset, endOffset);
    }

    private static Object processMethods(List<? extends IJstMethod> methods, int startOffset, int endOffset) {
        for (IJstMethod iJstMethod : methods) {
            Object node = JstUtil.processMethod(iJstMethod, startOffset, endOffset);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private static Object processMethod(IJstMethod method, int startOffset, int endOffset) {
        if (JstUtil.includes(method.getName().getSource(), startOffset, endOffset)) {
            return method;
        }
        IJstTypeReference retType = method.getRtnTypeRef();
        if (retType != null && JstUtil.includes(retType.getSource(), startOffset, endOffset)) {
            return retType;
        }
        List params = method.getArgs();
        for (JstArg param : params) {
            JstSource paramSource = param.getSource();
            if (JstUtil.includes(paramSource, startOffset, endOffset)) {
                return param;
            }
            IJstTypeReference paramType = param.getTypeRef();
            if (!JstUtil.includes(paramType.getSource(), startOffset, endOffset)) continue;
            return paramType;
        }
        Object node = JstUtil.processStatements(method.getBlock(), startOffset, endOffset);
        if (node != null) {
            return node;
        }
        return JstUtil.processChildren(method.getBlock(), startOffset, endOffset);
    }

    private static Object processChildren(JstBlock block, int startOffset, int endOffset) {
        if (block != null) {
            List statements = block.getChildren();
            for (BaseJstNode statement : statements) {
                Object node = null;
                if (statement instanceof IExpr) {
                    IExpr expr = (IExpr)statement;
                    node = JstUtil.processExpression(expr, startOffset, endOffset);
                }
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    private static boolean includes(int elementStart, int elementEnd, int selectionStart, int selectionEnd) {
        return elementStart <= selectionStart && elementEnd >= selectionEnd;
    }

    private static boolean intersects(int range1Start, int range1End, int range2Start, int range2End) {
        return range1Start <= range2Start && range1End > range2Start || range1Start < range2End && range1End >= range2End;
    }

    public static boolean include(JstSource source, int position) {
        return source.getStartOffSet() <= position && source.getEndOffSet() >= position;
    }

    public static IJstMethod getMethod(int position, Collection<? extends IJstMethod> ms) {
        IJstMethod jstMethod = null;
        for (IJstMethod iJstMethod : ms) {
            if (!JstUtil.include(iJstMethod.getSource(), position)) continue;
            jstMethod = iJstMethod;
        }
        return jstMethod;
    }

    public static IJstMethod getMethod(int position, IJstType jstType) {
        List collection = jstType.getInstanceMethods();
        IJstMethod jstMethod = JstUtil.getMethod(position, collection);
        if (jstMethod == null) {
            collection = jstType.getStaticMethods();
            jstMethod = JstUtil.getMethod(position, collection);
        }
        return jstMethod;
    }

    public static JstType findType(String name) {
        JstType jst = JstCache.getInstance().getType(name);
        if (jst == null) {
            jst = JstFactory.getInstance().createJstType(name, true);
        }
        return jst;
    }

    public static String getCorrectName(Literal literal) {
        String s = String.valueOf(literal.source());
        s = JstUtil.getCorrectName(s);
        return s;
    }

    public static String getCorrectName(String s) {
        s = s.replace(DOUBLE_QUOTE, "").replace(QUOTE, "");
        return s;
    }

    public static boolean isType(String method) {
        return "type".equals(method) || "itype".equals(method) || "ltype".equals(method) || "ctype".equals(method) || "etype".equals(method) || "otype".equals(method) || "mtype".equals(method) || "ftype".equals(method);
    }

    public static boolean isVjo(String name) {
        return "vjo".equals(name);
    }

    public static boolean isInnerType(Stack<IASTNode> list) {
        boolean isInnerType = false;
        if (list.size() > 2) {
            isInnerType = "vjo".equals(JstUtil.getName((IASTNode)list.get(0))) && JstUtil.isType(JstUtil.getName((IASTNode)list.get(1)));
        }
        return isInnerType;
    }

    public static String getInnerTypeName(Stack<IASTNode> list) {
        IASTNode node;
        if (list.size() > 2 && (node = (IASTNode)list.get(1)) instanceof MessageSend) {
            Expression arg;
            MessageSend send = (MessageSend)node;
            Expression[] args = send.arguments;
            if (args != null && args.length == 1 && (arg = args[0]) instanceof StringLiteral) {
                return JstUtil.getCorrectName((Literal)arg);
            }
        }
        return null;
    }

    public static String getName(IASTNode node) {
        String s = "";
        if (node instanceof MessageSend) {
            MessageSend send = (MessageSend)node;
            s = String.valueOf(send.selector);
        }
        if (node instanceof SingleNameReference) {
            SingleNameReference reference = (SingleNameReference)node;
            s = String.valueOf(reference.token);
        }
        return s;
    }

    public static Stack<IASTNode> createMessageSendStack(IExpression expr) {
        Stack<IASTNode> stack = new Stack<IASTNode>();
        IExpression node = expr;
        while (true) {
            stack.add(0, (IASTNode)node);
            if (!(node instanceof MessageSend)) break;
            MessageSend send = (MessageSend)node;
            node = send.receiver;
        }
        return stack;
    }

    public static BaseJstNode findScope(IJstType type, int startOffset, int endOffset) {
        return null;
    }

    private static void debug(String msg) {
        if (s_debug) {
            System.out.println(msg);
        }
    }

    private static void print(Object node) {
        IJstNode jstNode;
        if (s_debug && node instanceof IJstNode && (jstNode = (IJstNode)node).getSource() != null) {
            System.out.println("start=" + jstNode.getSource().getStartOffSet() + " end=" + jstNode.getSource().getEndOffSet());
        }
    }
}

