/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jstojava.translator.robust.completion;

import java.util.List;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.mod.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.vjet.dsf.jsgen.shared.ids.ScopeIds;
import org.eclipse.vjet.dsf.jst.BaseJstNode;
import org.eclipse.vjet.dsf.jst.IJstType;
import org.eclipse.vjet.dsf.jst.JstSource;
import org.eclipse.vjet.dsf.jst.declaration.JstType;
import org.eclipse.vjet.dsf.jst.meta.IJsCommentMeta;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateCtx;
import org.eclipse.vjet.dsf.jstojava.translator.TranslateHelper;
import org.eclipse.vjet.dsf.jstojava.translator.robust.JstSourceUtil;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCommentCompletion;
import org.eclipse.vjet.dsf.jstojava.translator.robust.completion.JstCompletion;

public class JstCommentUtil {
    public static List<String> getNonMetaComments(ASTNode astNode, TranslateCtx ctx) {
        return ctx.getCommentCollector().getComments(ctx.getPreviousNodeSourceEnd(), astNode.sourceStart());
    }

    private static void fillScope(ASTNode astNode, TranslateCtx ctx, JstCommentCompletion comp) {
        if (astNode instanceof MessageSend && (astNode.toString().startsWith("vjo.ctype") || astNode.toString().startsWith("vjo.itype"))) {
            comp.pushScope(ScopeIds.TYPE);
        } else if (astNode instanceof MethodDeclaration) {
            comp.pushScope(ScopeIds.METHOD);
        } else if (astNode instanceof FunctionExpression) {
            boolean inBody;
            MethodDeclaration astMethodDeclaration = ((FunctionExpression)astNode).getMethodDeclaration();
            boolean bl = inBody = astMethodDeclaration.bodyStart <= ctx.getCompletionPos();
            if (inBody) {
                comp.pushScope(ScopeIds.METHOD);
            }
        } else if (astNode instanceof ObjectLiteralField) {
            if (((ObjectLiteralField)astNode).initializer instanceof FunctionExpression) {
                comp.pushScope(ScopeIds.METHOD);
            } else {
                comp.pushScope(ScopeIds.PROPERTY);
            }
        } else {
            comp.pushScope(ScopeIds.VAR);
        }
    }

    public static boolean isWithInComment(int start, int end, int completionPos) {
        return completionPos <= end && completionPos >= start;
    }

    public static List<IJsCommentMeta> getCommentMeta(ASTNode astNode, TranslateCtx ctx) {
        return ctx.getCommentCollector().getCommentMeta(astNode.sourceStart(), astNode.sourceEnd(), ctx.getPreviousNodeSourceEnd(), ctx.getNextNodeSourceStart(), true);
    }

    public static void fillCompletion(ASTNode astNode, TranslateCtx ctx, JstCompletion completion) {
        JstType jstType = ctx.getCurrentType();
        if (completion.getSource() == null) {
            JstSource jstSource = JstCommentUtil.createSource(astNode.sourceStart(), astNode.sourceEnd(), ctx.getSourceUtil());
            completion.setSource(jstSource);
        }
        if (completion.isEmptyStack()) {
            completion.setScopeStack(ctx.getScopeStack());
        }
        completion.setParent((IJstType)jstType);
    }

    public static void createComentCompletion(ASTNode astNode, IJsCommentMeta meta, TranslateCtx ctx) {
        JstType type = ctx.getCurrentType();
        int relativeCompletionPos = ctx.getCompletionPos() >= meta.getBeginOffset() && ctx.getCompletionPos() <= meta.getEndOffset() ? ctx.getCompletionPos() - meta.getBeginOffset() : meta.getEndOffset();
        JstCommentCompletion commentCompletion = new JstCommentCompletion((BaseJstNode)type, meta.getCommentSrc(), relativeCompletionPos);
        commentCompletion.setScopeStack(ctx.getScopeStack());
        JstCommentUtil.fillCompletion(astNode, ctx, commentCompletion);
        ctx.addSyntaxError(commentCompletion);
        ctx.setCreatedCompletion(true);
        JstCommentUtil.fillScope(astNode, ctx, commentCompletion);
    }

    public static void createComentCompletion(ASTNode astNode, String comment, int beginOffset, int endOffset, TranslateCtx ctx) {
        JstType type = ctx.getCurrentType();
        int relativeCompletionPos = ctx.getCompletionPos() >= beginOffset && ctx.getCompletionPos() <= endOffset ? ctx.getCompletionPos() - beginOffset : endOffset;
        JstCommentCompletion commentCompletion = new JstCommentCompletion((BaseJstNode)type, comment, relativeCompletionPos);
        commentCompletion.setScopeStack(ctx.getScopeStack());
        JstCommentUtil.fillCompletion(astNode, ctx, commentCompletion);
        ctx.addSyntaxError(commentCompletion);
        ctx.setCreatedCompletion(true);
        JstCommentUtil.fillScope(astNode, ctx, commentCompletion);
    }

    private static JstSource createSource(int start, int end, JstSourceUtil util) {
        return TranslateHelper.createJstSource(util, end - start, start, end);
    }
}

