/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.js.dbgp;

import java.util.Map;
import org.eclipse.vjet.dsf.js.dbgp.Base64Helper;
import org.eclipse.vjet.dsf.js.dbgp.DBGPDebugger;

final class UpdateBreakPointCommand
extends DBGPDebugger.Command {
    private final DBGPDebugger m_debugger;

    UpdateBreakPointCommand(DBGPDebugger debugger) {
        this.m_debugger = debugger;
    }

    @Override
    void parseAndExecute(String command, Map<String, String> options) {
        String id = options.get("-d");
        String newState = options.get("-s");
        String newLine = options.get("-n");
        String hitValue = options.get("-h");
        String hitCondition = options.get("-o");
        String condEString = options.get("--");
        if (condEString != null) {
            condEString = Base64Helper.decodeString(condEString);
        }
        this.m_debugger.m_stackmanager.updateBreakpoint(id, newState, newLine, hitValue, hitCondition, condEString);
        String enabled = newState;
        this.m_debugger.printResponse("<response command=\"breakpoint_update\"\r\n transaction_id=\"" + options.get("-i") + "\">\r\n" + " id=\"" + id + "\" state=\"" + enabled + "\" " + "</response>\r\n");
    }
}

