/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.vjet.dsf.jsdebugger.ContextData;
import org.eclipse.vjet.dsf.jsdebugger.ScopeProvider;
import org.eclipse.vjet.dsf.jsdebugger.StackFrame;
import org.eclipse.vjet.dsf.jsdi.FunctionSource;
import org.eclipse.vjet.dsf.jsdi.IDebuggerControl;
import org.eclipse.vjet.dsf.jsdi.IGuiCallback;
import org.eclipse.vjet.dsf.jsdi.ISourceInfo;
import org.eclipse.vjet.dsf.jsdi.IValue;
import org.eclipse.vjet.dsf.jsdi.IVariable;
import org.eclipse.vjet.dsf.jsdi.SourceInfo;
import org.eclipse.vjet.dsf.jsdi.StackFrameInfo;
import org.eclipse.vjet.dsf.jsdi.Value;
import org.eclipse.vjet.dsf.jsdi.Variable;
import org.eclipse.vjet.dsf.jsdi.VariableType;
import org.mozilla.mod.javascript.Callable;
import org.mozilla.mod.javascript.Context;
import org.mozilla.mod.javascript.ContextAction;
import org.mozilla.mod.javascript.ContextFactory;
import org.mozilla.mod.javascript.ImporterTopLevel;
import org.mozilla.mod.javascript.Kit;
import org.mozilla.mod.javascript.NativeCall;
import org.mozilla.mod.javascript.ObjArray;
import org.mozilla.mod.javascript.ScriptRuntime;
import org.mozilla.mod.javascript.Scriptable;
import org.mozilla.mod.javascript.ScriptableObject;
import org.mozilla.mod.javascript.Undefined;
import org.mozilla.mod.javascript.debug.DebugFrame;
import org.mozilla.mod.javascript.debug.DebuggableObject;
import org.mozilla.mod.javascript.debug.DebuggableScript;
import org.mozilla.mod.javascript.debug.Debugger;

public class DebuggerAdapter
implements IDebuggerControl {
    private static final int IPROXY_DEBUG = 0;
    private static final int IPROXY_LISTEN = 1;
    private static final int IPROXY_COMPILE_SCRIPT = 2;
    private static final int IPROXY_EVAL_SCRIPT = 3;
    private static final int IPROXY_STRING_IS_COMPILABLE = 4;
    private static final int IPROXY_OBJECT_TO_STRING = 5;
    private static final int IPROXY_OBJECT_PROPERTY = 6;
    private static final int IPROXY_OBJECT_IDS = 7;
    private IGuiCallback m_callback;
    private boolean m_shouldBreak;
    private ScopeProvider m_scopeProvider;
    private int m_frameIndex = -1;
    private volatile ContextData m_interruptedContextData;
    private ContextFactory m_contextFactory;
    private Object m_monitor = new Object();
    private Object m_eventThreadMonitor = new Object();
    private volatile int m_returnValue = -1;
    private boolean m_insideInterruptLoop;
    private String m_evalRequest;
    private StackFrame m_evalFrame;
    private String m_evalResult;
    private boolean m_breakOnExceptions;
    private boolean m_breakOnEnter;
    private boolean m_breakOnReturn;
    private final Hashtable<String, SourceInfo> m_urlToSourceInfo = new Hashtable();
    private final Hashtable<String, FunctionSource> m_functionNames = new Hashtable();
    private final Hashtable<DebuggableScript, FunctionSource> m_functionToSource = new Hashtable();
    private DimIProxy m_listener;

    public void setGuiCallback(IGuiCallback callback) {
        this.m_callback = callback;
    }

    public void setBreak() {
        this.m_shouldBreak = true;
    }

    public boolean shouldBreak() {
        return this.m_shouldBreak;
    }

    public void setScopeProvider(ScopeProvider scopeProvider) {
        this.m_scopeProvider = scopeProvider;
    }

    public void contextSwitch(int frameIndex) {
        this.m_frameIndex = frameIndex;
    }

    public void setBreakOnExceptions(boolean breakOnExceptions) {
        this.m_breakOnExceptions = breakOnExceptions;
    }

    public boolean isBreakOnExceptions() {
        return this.m_breakOnExceptions;
    }

    public void setBreakOnEnter(boolean breakOnEnter) {
        this.m_breakOnEnter = breakOnEnter;
    }

    public boolean isBreakOnEnter() {
        return this.m_breakOnEnter;
    }

    public void setBreakOnReturn(boolean breakOnReturn) {
        this.m_breakOnReturn = breakOnReturn;
    }

    public boolean isBreakOnReturn() {
        return this.m_breakOnReturn;
    }

    public void attachTo(ContextFactory factory) {
        this.detach();
        this.m_contextFactory = factory;
        this.m_listener = new DimIProxy(this, 1);
        factory.addListener((ContextFactory.Listener)this.m_listener);
    }

    public void detach() {
        if (this.m_listener != null) {
            this.m_contextFactory.removeListener((ContextFactory.Listener)this.m_listener);
            this.m_contextFactory = null;
            this.m_listener = null;
        }
    }

    public void dispose() {
        this.detach();
        try {
            this.m_callback.detach(true);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private FunctionSource getFunctionSource(DebuggableScript fnOrScript) {
        String source;
        String url;
        SourceInfo si;
        FunctionSource fsource = this.functionSource(fnOrScript);
        if (fsource == null && (si = this.getSourceInfo(url = this.getNormalizedUrl(fnOrScript))) == null && !fnOrScript.isGeneratedScript() && (source = this.loadSource(url)) != null) {
            DebuggableScript parent;
            DebuggableScript top = fnOrScript;
            while ((parent = top.getParent()) != null) {
                top = parent;
            }
            this.registerTopScript(top, source);
            fsource = this.functionSource(fnOrScript);
        }
        return fsource;
    }

    private String loadSource(String sourceUrl) {
        String source = null;
        int hash = sourceUrl.indexOf(35);
        if (hash >= 0) {
            sourceUrl = sourceUrl.substring(0, hash);
        }
        try {
            InputStream is;
            block10: {
                if (sourceUrl.indexOf(58) < 0) {
                    block11: {
                        try {
                            String pathFromHome;
                            File f;
                            String home;
                            if (sourceUrl.startsWith("~/") && (home = System.getProperty("user.home")) != null && (f = new File(new File(home), pathFromHome = sourceUrl.substring(2))).exists()) {
                                is = new FileInputStream(f);
                                break block10;
                            }
                            File f2 = new File(sourceUrl);
                            if (!f2.exists()) break block11;
                            is = new FileInputStream(f2);
                            break block10;
                        }
                        catch (SecurityException securityException) {}
                    }
                    sourceUrl = sourceUrl.startsWith("//") ? "http:" + sourceUrl : (sourceUrl.startsWith("/") ? "http://127.0.0.1" + sourceUrl : "http://" + sourceUrl);
                }
                is = new URL(sourceUrl).openStream();
            }
            try {
                source = Kit.readReader((Reader)new InputStreamReader(is));
            }
            finally {
                is.close();
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to load source from " + sourceUrl + ": " + ex);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerTopScript(DebuggableScript topScript, String source) {
        if (!topScript.isTopLevel()) {
            throw new IllegalArgumentException();
        }
        String url = this.getNormalizedUrl(topScript);
        DebuggableScript[] functions = DebuggerAdapter.getAllFunctions(topScript);
        SourceInfo sourceInfo = null;
        try {
            sourceInfo = new SourceInfo(source, functions, url, this.m_callback.getBreakPoints(url));
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
        Hashtable<String, SourceInfo> e = this.m_urlToSourceInfo;
        synchronized (e) {
            SourceInfo old = this.m_urlToSourceInfo.get(url);
            if (old != null) {
                sourceInfo.copyBreakpointsFrom(old);
            }
            this.m_urlToSourceInfo.put(url, sourceInfo);
            int i = 0;
            while (i != sourceInfo.getFunctionSourceCount()) {
                FunctionSource fsource = sourceInfo.getFunctionSource(i);
                String name = fsource.name();
                if (name.length() != 0) {
                    this.m_functionNames.put(name, fsource);
                }
                ++i;
            }
        }
        e = this.m_functionToSource;
        synchronized (e) {
            int i = 0;
            while (i != functions.length) {
                FunctionSource fsource = sourceInfo.getFunctionSource(i);
                this.m_functionToSource.put(functions[i], fsource);
                ++i;
            }
        }
        try {
            this.m_callback.updateSourceText((ISourceInfo)sourceInfo);
        }
        catch (RemoteException e2) {
            throw new RuntimeException(e2);
        }
    }

    private FunctionSource functionSource(DebuggableScript fnOrScript) {
        return this.m_functionToSource.get(fnOrScript);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] functionNames() {
        String[] a;
        Hashtable<String, SourceInfo> hashtable = this.m_urlToSourceInfo;
        synchronized (hashtable) {
            Enumeration<String> e = this.m_functionNames.keys();
            a = new String[this.m_functionNames.size()];
            int i = 0;
            while (e.hasMoreElements()) {
                a[i++] = e.nextElement();
            }
        }
        return a;
    }

    public FunctionSource functionSourceByName(String functionName) {
        return this.m_functionNames.get(functionName);
    }

    public SourceInfo getSourceInfo(String url) {
        return this.m_urlToSourceInfo.get(url);
    }

    private String getNormalizedUrl(DebuggableScript fnOrScript) {
        String url = fnOrScript.getSourceName();
        if (url == null) {
            url = "<stdin>";
        } else {
            int searchStart;
            int evalSeparator = 35;
            StringBuffer sb = null;
            int urlLength = url.length();
            int cursor = 0;
            while ((searchStart = url.indexOf(evalSeparator, cursor)) >= 0) {
                String replace = null;
                int i = searchStart + 1;
                while (i != urlLength) {
                    char c = url.charAt(i);
                    if ('0' > c || c > '9') break;
                    ++i;
                }
                if (i != searchStart + 1 && "(eval)".regionMatches(0, url, i, 6)) {
                    cursor = i + 6;
                    replace = "(eval)";
                }
                if (replace == null) break;
                if (sb == null) {
                    sb = new StringBuffer();
                    sb.append(url.substring(0, searchStart));
                }
                sb.append(replace);
            }
            if (sb != null) {
                if (cursor != urlLength) {
                    sb.append(url.substring(cursor));
                }
                url = sb.toString();
            }
        }
        return url;
    }

    private static DebuggableScript[] getAllFunctions(DebuggableScript function) {
        ObjArray functions = new ObjArray();
        DebuggerAdapter.collectFunctions_r(function, functions);
        Object[] result = new DebuggableScript[functions.size()];
        functions.toArray(result);
        return result;
    }

    private static void collectFunctions_r(DebuggableScript function, ObjArray array) {
        array.add((Object)function);
        int i = 0;
        while (i != function.getFunctionCount()) {
            DebuggerAdapter.collectFunctions_r(function.getFunction(i), array);
            ++i;
        }
    }

    public void clearAllBreakpoints() {
        Enumeration<SourceInfo> e = this.m_urlToSourceInfo.elements();
        while (e.hasMoreElements()) {
            SourceInfo si = e.nextElement();
            si.removeAllBreakpoints();
        }
    }

    void handleBreakpointHit(StackFrame frame, Context cx) {
        this.m_shouldBreak = false;
        try {
            this.interrupted(cx, frame, null);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    void handleExceptionThrown(Context cx, Throwable ex, StackFrame frame) {
        ContextData cd;
        if (this.m_breakOnExceptions && (cd = frame.contextData()).getLastProcessedException() != ex) {
            try {
                this.interrupted(cx, frame, ex);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
            cd.setLastProcessedException(ex);
        }
    }

    public ContextData currentContextData() {
        return this.m_interruptedContextData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReturnValue(int returnValue) {
        Object object = this.m_monitor;
        synchronized (object) {
            this.m_returnValue = returnValue;
            this.m_monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void go() {
        Object object = this.m_monitor;
        synchronized (object) {
            this.m_returnValue = 3;
            this.m_monitor.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String eval(String expr) {
        String result = "undefined";
        if (expr == null) {
            return result;
        }
        ContextData contextData = this.currentContextData();
        if (contextData == null || this.m_frameIndex >= contextData.frameCount()) {
            return result;
        }
        StackFrame frame = contextData.getFrame(this.m_frameIndex);
        if (contextData.getEventThreadFlag()) {
            Context cx = Context.getCurrentContext();
            result = DebuggerAdapter.do_eval(cx, frame, expr);
        } else {
            Object object = this.m_monitor;
            synchronized (object) {
                if (this.m_insideInterruptLoop) {
                    this.m_evalRequest = expr;
                    this.m_evalFrame = frame;
                    this.m_monitor.notify();
                    do {
                        try {
                            this.m_monitor.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            break;
                        }
                    } while (this.m_evalRequest != null);
                    result = this.m_evalResult;
                }
            }
        }
        return result;
    }

    public void compileScript(String url, String text) {
        DimIProxy action = new DimIProxy(this, 2);
        action.m_url = url;
        action.m_text = text;
        action.withContext();
    }

    public void evalScript(String url, String text) {
        DimIProxy action = new DimIProxy(this, 3);
        action.m_url = url;
        action.m_text = text;
        action.withContext();
    }

    public String objectToString(Object object) {
        DimIProxy action = new DimIProxy(this, 5);
        action.m_object = object;
        action.withContext();
        return action.m_stringResult;
    }

    public boolean stringIsCompilableUnit(String str) {
        DimIProxy action = new DimIProxy(this, 4);
        action.m_text = str;
        action.withContext();
        return action.m_booleanResult;
    }

    public Object getObjectProperty(Object object, Object id) {
        DimIProxy action = new DimIProxy(this, 6);
        action.m_object = object;
        action.m_id = id;
        action.withContext();
        return action.m_objectResult;
    }

    public Object[] getObjectIds(Object object) {
        DimIProxy action = new DimIProxy(this, 7);
        action.m_object = object;
        action.withContext();
        return action.m_objectArrayResult;
    }

    private Object getObjectPropertyImpl(Context cx, Object object, Object id) {
        Object result;
        Scriptable scriptable = (Scriptable)object;
        if (id instanceof String) {
            String name = (String)id;
            if (name.equals("this")) {
                result = scriptable;
            } else if (name.equals("__proto__")) {
                result = scriptable.getPrototype();
            } else if (name.equals("__parent__")) {
                result = scriptable.getParentScope();
            } else {
                result = ScriptableObject.getProperty((Scriptable)scriptable, (String)name);
                if (result == ScriptableObject.NOT_FOUND) {
                    result = Undefined.instance;
                }
            }
        } else {
            int index = (Integer)id;
            result = ScriptableObject.getProperty((Scriptable)scriptable, (int)index);
            if (result == ScriptableObject.NOT_FOUND) {
                result = Undefined.instance;
            }
        }
        return result;
    }

    private Object[] getObjectIdsImpl(Context cx, Object object) {
        if (!(object instanceof Scriptable) || object == Undefined.instance) {
            return Context.emptyArgs;
        }
        Scriptable scriptable = (Scriptable)object;
        Object[] ids = scriptable instanceof DebuggableObject ? ((DebuggableObject)scriptable).getAllIds() : scriptable.getIds();
        Scriptable proto = scriptable.getPrototype();
        Scriptable parent = scriptable.getParentScope();
        int extra = 0;
        if (proto != null) {
            ++extra;
        }
        if (parent != null) {
            ++extra;
        }
        if (extra != 0) {
            Object[] tmp = new Object[extra + ids.length];
            System.arraycopy(ids, 0, tmp, extra, ids.length);
            ids = tmp;
            extra = 0;
            if (proto != null) {
                ids[extra++] = "__proto__";
            }
            if (parent != null) {
                ids[extra++] = "__parent__";
            }
        }
        return ids;
    }

    /*
     * Exception decompiling
     */
    private void interrupted(Context cx, StackFrame frame, Throwable scriptException) throws RemoteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String do_eval(Context cx, StackFrame frame, String expr) {
        String resultString;
        block6: {
            Debugger saved_debugger = cx.getDebugger();
            Object saved_data = cx.getDebuggerContextData();
            int saved_level = cx.getOptimizationLevel();
            cx.setDebugger(null, null);
            cx.setOptimizationLevel(-1);
            cx.setGeneratingDebug(false);
            try {
                try {
                    Callable script = (Callable)cx.compileString(expr, "", 0, null);
                    Object result = script.call(cx, frame.scope(), frame.thisObj(), ScriptRuntime.emptyArgs);
                    resultString = result == Undefined.instance ? "" : ScriptRuntime.toString((Object)result);
                }
                catch (Exception exc) {
                    resultString = exc.getMessage();
                    cx.setGeneratingDebug(true);
                    cx.setOptimizationLevel(saved_level);
                    cx.setDebugger(saved_debugger, saved_data);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                cx.setGeneratingDebug(true);
                cx.setOptimizationLevel(saved_level);
                cx.setDebugger(saved_debugger, saved_data);
                throw throwable;
            }
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(saved_level);
            cx.setDebugger(saved_debugger, saved_data);
        }
        if (resultString == null) {
            resultString = "null";
        }
        return resultString;
    }

    public int getFrameCount() {
        return this.currentContextData().frameCount();
    }

    public StackFrameInfo getFrameInfo(int frameIndex) {
        StackFrame frame = this.currentContextData().getFrame(frameIndex);
        return new StackFrameInfo(frameIndex, frame.getUrl(), frame.getLineNumber(), frame.thisObj() != frame.scope());
    }

    public IVariable[] loadMembers(long id) {
        StackFrame frame = this.currentContextData().getFrame(this.m_frameIndex);
        Object obj = frame.getObject(id);
        Object[] propIds = this.getObjectIds(obj);
        IVariable[] members = new IVariable[propIds.length];
        Object prop = null;
        int i = 0;
        while (i < members.length) {
            Object propId = propIds[i];
            prop = this.getObjectProperty(obj, propId);
            Value value = Value.forPrimitive((Object)prop);
            if (value == null) {
                value = new Value(VariableType.OBJECT, null, (Object)frame.getId(prop));
            }
            members[i] = new Variable(propId.toString(), (IValue)value, obj.getClass().getName());
            ++i;
        }
        return members;
    }

    public String getObjectValueAsString(long id) {
        StackFrame frame = this.currentContextData().getFrame(this.m_frameIndex);
        Object obj = frame.getObject(id);
        return this.objectToString(obj);
    }

    private static class DimIProxy
    implements ContextAction,
    ContextFactory.Listener,
    Debugger {
        private DebuggerAdapter m_dim;
        private int m_type;
        private String m_url;
        private String m_text;
        private Object m_object;
        private Object m_id;
        private boolean m_booleanResult;
        private String m_stringResult;
        private Object m_objectResult;
        private Object[] m_objectArrayResult;

        private DimIProxy(DebuggerAdapter dim, int type) {
            this.m_dim = dim;
            this.m_type = type;
        }

        public Object run(Context cx) {
            switch (this.m_type) {
                case 2: {
                    cx.compileString(this.m_text, this.m_url, 1, null);
                    break;
                }
                case 3: {
                    Scriptable scope = null;
                    if (this.m_dim.m_scopeProvider != null) {
                        scope = this.m_dim.m_scopeProvider.getScope();
                    }
                    if (scope == null) {
                        scope = new ImporterTopLevel(cx);
                    }
                    cx.evaluateString(scope, this.m_text, this.m_url, 1, null);
                    break;
                }
                case 4: {
                    this.m_booleanResult = cx.stringIsCompilableUnit(this.m_text);
                    break;
                }
                case 5: {
                    if (this.m_object == Undefined.instance) {
                        this.m_stringResult = "undefined";
                        break;
                    }
                    if (this.m_object == null) {
                        this.m_stringResult = "null";
                        break;
                    }
                    if (this.m_object instanceof NativeCall) {
                        this.m_stringResult = "[object Call]";
                        break;
                    }
                    this.m_stringResult = Context.toString((Object)this.m_object);
                    break;
                }
                case 6: {
                    this.m_objectResult = this.m_dim.getObjectPropertyImpl(cx, this.m_object, this.m_id);
                    break;
                }
                case 7: {
                    this.m_objectArrayResult = this.m_dim.getObjectIdsImpl(cx, this.m_object);
                    break;
                }
                default: {
                    throw Kit.codeBug();
                }
            }
            return null;
        }

        private void withContext() {
            this.m_dim.m_contextFactory.call((ContextAction)this);
        }

        public void contextCreated(Context cx) {
            if (this.m_type != 1) {
                Kit.codeBug();
            }
            ContextData contextData = new ContextData();
            DimIProxy debugger = new DimIProxy(this.m_dim, 0);
            cx.setDebugger((Debugger)debugger, (Object)contextData);
            cx.setGeneratingDebug(true);
            cx.setOptimizationLevel(-1);
        }

        public void contextReleased(Context cx) {
            if (this.m_type != 1) {
                Kit.codeBug();
            }
        }

        public DebugFrame getFrame(Context cx, DebuggableScript fnOrScript) {
            FunctionSource item;
            if (this.m_type != 0) {
                Kit.codeBug();
            }
            if ((item = this.m_dim.getFunctionSource(fnOrScript)) == null) {
                return null;
            }
            return new StackFrame(cx, this.m_dim, item);
        }

        public void handleCompilationDone(Context cx, DebuggableScript fnOrScript, String source) {
            if (this.m_type != 0) {
                Kit.codeBug();
            }
            if (!fnOrScript.isTopLevel()) {
                return;
            }
            this.m_dim.registerTopScript(fnOrScript, source);
        }
    }
}

