/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.vjet.dsf.jsdebugger.gui;

import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.eclipse.vjet.dsf.jsdebugger.gui.SwingGui;

class SimpleTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 2971618907207577000L;
    private SwingGui m_debugGui;
    private Vector<String> m_expressions;
    private Vector<String> m_values;

    public SimpleTableModel(SwingGui debugGui) {
        this.m_debugGui = debugGui;
        this.m_expressions = new Vector();
        this.m_values = new Vector();
        this.m_expressions.addElement("");
        this.m_values.addElement("");
    }

    public void clear() {
        this.m_expressions.clear();
        this.m_values.clear();
        this.m_expressions.addElement("");
        this.m_values.addElement("");
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.m_expressions.size();
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Expression";
            }
            case 1: {
                return "Value";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return this.m_expressions.elementAt(row);
            }
            case 1: {
                return this.m_values.elementAt(row);
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        switch (column) {
            case 0: {
                String expr = value.toString();
                this.m_expressions.setElementAt(expr, row);
                String result = "";
                if (expr.length() > 0) {
                    try {
                        result = this.m_debugGui.m_debuggerControl.eval(expr);
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                    if (result == null) {
                        result = "";
                    }
                }
                this.m_values.setElementAt(result, row);
                this.updateModel();
                if (row + 1 != this.m_expressions.size()) break;
                this.m_expressions.addElement("");
                this.m_values.addElement("");
                this.fireTableRowsInserted(row + 1, row + 1);
                break;
            }
            case 1: {
                this.fireTableDataChanged();
            }
        }
    }

    void updateModel() {
        int i = 0;
        while (i < this.m_expressions.size()) {
            String value = this.m_expressions.elementAt(i);
            String expr = value.toString();
            String result = "";
            if (expr.length() > 0) {
                try {
                    result = this.m_debugGui.m_debuggerControl.eval(expr);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                if (result == null) {
                    result = "";
                }
            } else {
                result = "";
            }
            result = result.replace('\n', ' ');
            this.m_values.setElementAt(result, i);
            ++i;
        }
        this.fireTableDataChanged();
    }
}

